/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.routing;

import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.query.routing.Candidate;
import org.apache.kylin.query.util.RexUtils;

public abstract class PruningRule {
    private static final Pattern DATE_PATTERN = Pattern.compile("\\d{4}-\\d{2}-\\d{2}");
    private static final Pattern TIMESTAMP_PATTERN = Pattern.compile("\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}(\\.\\d*[1-9])?");

    public String toString() {
        return this.getClass().getName();
    }

    public abstract void apply(Candidate var1);

    public abstract boolean isStorageMatch(Candidate var1);

    PartitionDesc getPartitionDesc(NDataflow dataflow, OlapContext olapContext) {
        boolean isBatchFusionModel;
        NDataModel model = dataflow.getModel();
        boolean isStreamingFactTable = olapContext.getFirstTableScan().getOlapTable().getSourceTable().getSourceType() == 1;
        boolean bl = isBatchFusionModel = isStreamingFactTable && dataflow.getModel().isFusionModel() && !dataflow.isStreaming();
        if (!isBatchFusionModel) {
            return model.getPartitionDesc();
        }
        return NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)dataflow.getProject()).getDataModelDesc(model.getFusionId()).getPartitionDesc();
    }

    boolean isFullBuildModel(PartitionDesc partitionCol) {
        return PartitionDesc.isEmptyPartitionDesc((PartitionDesc)partitionCol) || partitionCol.getPartitionDateFormat() == null;
    }

    List<RexNode> transformValue2RexCall(RexBuilder rexBuilder, RexInputRef colInputRef, DataType colType, String left, String right, boolean closedRight) {
        RexNode startRexLiteral = RexUtils.transformValue2RexLiteral(rexBuilder, left, colType);
        RexNode endRexLiteral = RexUtils.transformValue2RexLiteral(rexBuilder, right, colType);
        RexNode greaterThanOrEqualCall = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (List)Lists.newArrayList((Object[])new RexNode[]{colInputRef, startRexLiteral}));
        SqlBinaryOperator sqlOperator = closedRight ? SqlStdOperatorTable.LESS_THAN_OR_EQUAL : SqlStdOperatorTable.LESS_THAN;
        RexNode lessCall = rexBuilder.makeCall((SqlOperator)sqlOperator, (List)Lists.newArrayList((Object[])new RexNode[]{colInputRef, endRexLiteral}));
        return Lists.newArrayList((Object[])new RexNode[]{greaterThanOrEqualCall, lessCall});
    }

    static String checkAndReformatDateType(String formattedValue, long segmentTs, DataType colType) {
        switch (colType.getName()) {
            case "date": {
                if (DATE_PATTERN.matcher(formattedValue).matches()) {
                    return formattedValue;
                }
                return DateFormat.formatToDateStr((long)segmentTs, (String)"yyyy-MM-dd");
            }
            case "timestamp": {
                if (TIMESTAMP_PATTERN.matcher(formattedValue).matches()) {
                    return formattedValue;
                }
                return DateFormat.formatToDateStr((long)segmentTs, (String)"yyyy-MM-dd HH:mm:ss");
            }
            case "varchar": 
            case "string": 
            case "integer": 
            case "bigint": {
                return formattedValue;
            }
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "%s data type is not supported for partition column", colType));
    }
}

