/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import lombok.Generated;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.ContextUtil;
import org.apache.kylin.query.relnode.OlapAggregateRel;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.query.relnode.OlapTableScan;
import org.apache.kylin.query.util.ICutContextStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface OlapRel
extends RelNode {
    public static final Logger logger = LoggerFactory.getLogger(OlapRel.class);
    public static final Convention CONVENTION = new Convention.Impl("OLAP", OlapRel.class);
    public static final double OLAP_COST_FACTOR = 0.05;

    public OlapContext getContext();

    public ColumnRowType getColumnRowType();

    public boolean hasSubQuery();

    public RelTraitSet replaceTraitSet(RelTrait var1);

    public void implementOlap(OlapImpl var1);

    public void implementRewrite(RewriteImpl var1);

    public EnumerableRel implementEnumerable(List<EnumerableRel> var1);

    public void implementContext(ContextImpl var1, ContextVisitorState var2);

    public void implementCutContext(ICutContextStrategy.ContextCutImpl var1);

    public void setContext(OlapContext var1);

    public boolean pushRelInfoToContext(OlapContext var1);

    public Set<OlapContext> getSubContexts();

    public void setSubContexts(Set<OlapContext> var1);

    default public String displayCtxId(OlapContext ctx) {
        return ctx == null ? "" : ctx.getId() + "@" + ctx.getRealization();
    }

    public static class ContextVisitorState {
        private boolean hasFilter;
        private boolean hasFreeTable;
        private boolean hasIncrementalTable;
        private boolean hasFirstTable;
        private boolean hasModelView;

        public ContextVisitorState(boolean hasFilter, boolean hasFreeTable, boolean hasIncrementalTable) {
            this.hasFilter = hasFilter;
            this.hasFreeTable = hasFreeTable;
            this.hasIncrementalTable = hasIncrementalTable;
        }

        public static ContextVisitorState of(boolean hasFilter, boolean hasFreeTable) {
            return ContextVisitorState.of(hasFilter, hasFreeTable, false);
        }

        public static ContextVisitorState of(boolean hasFilter, boolean hasFreeTable, boolean hasIncrementalTable) {
            return new ContextVisitorState(hasFilter, hasFreeTable, hasIncrementalTable);
        }

        public static ContextVisitorState init() {
            return ContextVisitorState.of(false, false, false);
        }

        public boolean hasFirstTable() {
            return this.hasFirstTable;
        }

        public boolean hasIncrementalTable() {
            return this.hasIncrementalTable;
        }

        public boolean hasFilter() {
            return this.hasFilter;
        }

        public boolean hasFreeTable() {
            return this.hasFreeTable;
        }

        public boolean hasModelView() {
            return this.hasModelView;
        }

        public ContextVisitorState merge(ContextVisitorState that) {
            this.hasFilter = that.hasFilter || this.hasFilter;
            this.hasFreeTable = that.hasFreeTable || this.hasFreeTable;
            this.hasIncrementalTable = that.hasIncrementalTable || this.hasIncrementalTable;
            this.hasFirstTable = that.hasFirstTable || this.hasFirstTable;
            this.hasModelView = that.hasModelView || this.hasModelView;
            return this;
        }

        @Generated
        public void setHasFilter(boolean hasFilter) {
            this.hasFilter = hasFilter;
        }

        @Generated
        public void setHasFreeTable(boolean hasFreeTable) {
            this.hasFreeTable = hasFreeTable;
        }

        @Generated
        public void setHasIncrementalTable(boolean hasIncrementalTable) {
            this.hasIncrementalTable = hasIncrementalTable;
        }

        @Generated
        public void setHasFirstTable(boolean hasFirstTable) {
            this.hasFirstTable = hasFirstTable;
        }

        @Generated
        public void setHasModelView(boolean hasModelView) {
            this.hasModelView = hasModelView;
        }
    }

    public static class ContextImpl {
        private TableDesc firstTableDesc;
        private final Deque<RelNode> parentNodeStack = new ArrayDeque<RelNode>();
        private int ctxSeq = 0;
        private final Queue<RelNode> aggRelQueue = new LinkedList<RelNode>();

        public void visitChild(RelNode input, RelNode parentNode, ContextVisitorState state) {
            this.parentNodeStack.offerLast(parentNode);
            ((OlapRel)input).implementContext(this, state);
            if (input instanceof OlapAggregateRel) {
                this.addAgg(input);
            }
            this.parentNodeStack.pollLast();
        }

        public OlapContext allocateContext(OlapRel topNode, RelNode parentOfTopNode) {
            OlapContext context = new OlapContext(this.ctxSeq++);
            ContextUtil.registerContext(context);
            context.setTopNode(topNode);
            context.setParentOfTopNode(parentOfTopNode);
            topNode.setContext(context);
            return context;
        }

        public void fixSharedOlapTableScan(SingleRel parent) {
            OlapTableScan copy = this.copyTableScanIfNeeded(parent.getInput());
            if (copy != null) {
                parent.replaceInput(0, (RelNode)copy);
            }
        }

        public void fixSharedOlapTableScanOnTheLeft(BiRel parent) {
            OlapTableScan copy = this.copyTableScanIfNeeded(parent.getLeft());
            if (copy != null) {
                parent.replaceInput(0, (RelNode)copy);
            }
        }

        public void fixSharedOlapTableScanOnTheRight(BiRel parent) {
            OlapTableScan copy = this.copyTableScanIfNeeded(parent.getRight());
            if (copy != null) {
                parent.replaceInput(1, (RelNode)copy);
            }
        }

        public void fixSharedOlapTableScanAt(RelNode parent, int ordinalInParent) {
            OlapTableScan copy = this.copyTableScanIfNeeded((RelNode)parent.getInputs().get(ordinalInParent));
            if (copy != null) {
                parent.replaceInput(ordinalInParent, (RelNode)copy);
            }
        }

        private OlapTableScan copyTableScanIfNeeded(RelNode input) {
            OlapTableScan tableScan;
            if (input instanceof OlapTableScan && (tableScan = (OlapTableScan)input).isContextVisited()) {
                return (OlapTableScan)tableScan.copy(tableScan.getTraitSet(), tableScan.getInputs());
            }
            return null;
        }

        public void addAgg(RelNode relNode) {
            this.aggRelQueue.add(relNode);
        }

        public void optimizeContextCut() {
            RelNode rel = this.aggRelQueue.poll();
            while (rel != null) {
                ((OlapAggregateRel)rel).optimizeContextCut();
                rel = this.aggRelQueue.poll();
            }
        }

        @Generated
        public void setFirstTableDesc(TableDesc firstTableDesc) {
            this.firstTableDesc = firstTableDesc;
        }

        @Generated
        public TableDesc getFirstTableDesc() {
            return this.firstTableDesc;
        }
    }

    public static class JavaImplementor
    extends EnumerableRelImplementor {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(JavaImplementor.class);
        private final IdentityHashMap<EnumerableRel, OlapContext> relContexts = Maps.newIdentityHashMap();
        private final boolean calciteDebug = System.getProperty("calcite.debug") != null;

        public JavaImplementor(EnumerableRelImplementor enumImplementor) {
            super(enumImplementor.getRexBuilder(), new LinkedHashMap());
        }

        public EnumerableRel createEnumerable(OlapRel parent) {
            ArrayList enumInputs = null;
            List children = parent.getInputs();
            if (children != null) {
                enumInputs = Lists.newArrayListWithCapacity((int)children.size());
                for (RelNode child : children) {
                    enumInputs.add(this.createEnumerable((OlapRel)child));
                }
            }
            EnumerableRel result = parent.implementEnumerable(enumInputs);
            this.relContexts.put(result, parent.getContext());
            return result;
        }

        public EnumerableRel.Result visitChild(EnumerableRel parent, int ordinal, EnumerableRel child, EnumerableRel.Prefer prefer) {
            if (this.calciteDebug) {
                OlapContext context = child instanceof OlapRel ? ((OlapRel)child).getContext() : this.relContexts.get(child);
                log.info(context + " - " + child);
            }
            return super.visitChild(parent, ordinal, child, prefer);
        }
    }

    public static class RewriteImpl {
        private OlapContext parentContext;

        public static boolean needRewrite(OlapContext ctx) {
            if (ctx.isHasJoin()) {
                return true;
            }
            if (ctx.getRealization() == null) {
                return false;
            }
            String realRootFact = ctx.getRealization().getModel().getRootFactTable().getTableIdentity();
            return ctx.getFirstTableScan().getTableName().equals(realRootFact);
        }

        public void visitChild(RelNode parent, RelNode child) {
            if (parent instanceof OlapRel) {
                OlapRel olapRel = (OlapRel)parent;
                this.parentContext = olapRel.getContext();
            }
            OlapRel olapChild = (OlapRel)child;
            olapChild.implementRewrite(this);
        }

        @Generated
        public OlapContext getParentContext() {
            return this.parentContext;
        }
    }

    public static class OlapImpl {
        private final Deque<RelNode> parentNodeStack = new ArrayDeque<RelNode>();

        public void visitChild(RelNode input, RelNode parentNode) {
            this.parentNodeStack.offerLast(parentNode);
            ((OlapRel)input).implementOlap(this);
            this.parentNodeStack.pollLast();
        }

        public Deque<RelNode> getParentNodeStack() {
            return this.parentNodeStack;
        }

        public RelNode getParentNode() {
            return this.parentNodeStack.peekLast();
        }
    }
}

