/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableLimit;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.ContextUtil;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.query.relnode.OlapRel;
import org.apache.kylin.query.util.ICutContextStrategy;

public class OlapLimitRel
extends SingleRel
implements OlapRel {
    private final RexNode localOffset;
    private final RexNode localFetch;
    private ColumnRowType columnRowType;
    private OlapContext context;
    private Set<OlapContext> subContexts = Sets.newHashSet();

    public OlapLimitRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexNode offset, RexNode fetch) {
        super(cluster, traitSet, child);
        Preconditions.checkArgument((this.getConvention() == CONVENTION ? 1 : 0) != 0);
        Preconditions.checkArgument((this.getConvention() == child.getConvention() ? 1 : 0) != 0);
        this.localOffset = offset;
        this.localFetch = fetch;
    }

    public OlapLimitRel copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new OlapLimitRel(this.getCluster(), traitSet, (RelNode)AbstractRelNode.sole(inputs), this.localOffset, this.localFetch);
    }

    @Override
    public void implementCutContext(ICutContextStrategy.ContextCutImpl contextCutImpl) {
        this.context = null;
        this.columnRowType = null;
        contextCutImpl.visitChild(this.getInput());
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.05);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("ctx", (Object)this.displayCtxId(this.context)).itemIf("offset", (Object)this.localOffset, this.localOffset != null).itemIf("fetch", (Object)this.localFetch, this.localFetch != null);
    }

    protected Integer translateRexToValue(RexNode rexNode, int defaultValue) {
        if (rexNode instanceof RexLiteral) {
            RexLiteral rexLiteral = (RexLiteral)rexNode;
            Number number = (Number)((Object)rexLiteral.getValue());
            return number.intValue();
        }
        if (rexNode instanceof RexDynamicParam) {
            return defaultValue;
        }
        throw new IllegalStateException("Unsupported RexNode for limit Rel " + rexNode);
    }

    protected ColumnRowType buildColumnRowType() {
        OlapRel olapChild = (OlapRel)this.getInput();
        return olapChild.getColumnRowType();
    }

    @Override
    public void implementRewrite(OlapRel.RewriteImpl rewriteImpl) {
        rewriteImpl.visitChild(this, this.getInput());
        if (this.context != null) {
            this.rowType = this.deriveRowType();
            this.columnRowType = this.buildColumnRowType();
        }
    }

    @Override
    public EnumerableRel implementEnumerable(List<EnumerableRel> inputs) {
        EnumerableRel input = (EnumerableRel)AbstractRelNode.sole(inputs);
        if (input instanceof OlapRel) {
            ((OlapRel)input).replaceTraitSet((RelTrait)EnumerableConvention.INSTANCE);
        }
        return EnumerableLimit.create((RelNode)input, (RexNode)this.localOffset, (RexNode)this.localFetch);
    }

    @Override
    public boolean hasSubQuery() {
        OlapRel olapChild = (OlapRel)this.getInput();
        return olapChild.hasSubQuery();
    }

    @Override
    public RelTraitSet replaceTraitSet(RelTrait trait) {
        RelTraitSet oldTraitSet = this.traitSet;
        this.traitSet = this.traitSet.replace(trait);
        return oldTraitSet;
    }

    @Override
    public void setContext(OlapContext context) {
        this.context = context;
        ((OlapRel)this.getInput()).setContext(context);
        this.subContexts.addAll(ContextUtil.collectSubContext(this.getInput()));
    }

    @Override
    public boolean pushRelInfoToContext(OlapContext context) {
        if (this.context == null && ((OlapRel)this.getInput()).pushRelInfoToContext(context)) {
            this.context = context;
            return true;
        }
        return false;
    }

    @Override
    public void implementContext(OlapRel.ContextImpl contextImpl, OlapRel.ContextVisitorState state) {
        contextImpl.fixSharedOlapTableScan(this);
        OlapRel.ContextVisitorState tempState = OlapRel.ContextVisitorState.init();
        contextImpl.visitChild(this.getInput(), this, tempState);
        if (tempState.hasFreeTable()) {
            contextImpl.allocateContext(this, null);
            tempState.setHasFreeTable(false);
        }
        this.subContexts.addAll(ContextUtil.collectSubContext(this.getInput()));
        if (this.context == null && this.subContexts.size() == 1 && this.getInput() == ((OlapContext)Lists.newArrayList(this.subContexts).get(0)).getTopNode()) {
            this.context = (OlapContext)Lists.newArrayList(this.subContexts).get(0);
            this.context.setTopNode(this);
        }
        state.merge(tempState);
    }

    @Override
    public void implementOlap(OlapRel.OlapImpl olapImpl) {
        olapImpl.visitChild(this.getInput(), this);
        this.columnRowType = this.buildColumnRowType();
        if (this.context != null) {
            if (!this.context.isAfterHavingClauseFilter() && !this.context.isAfterLimit()) {
                int limit = this.translateRexToValue(this.localFetch, Integer.MAX_VALUE);
                this.context.setLimit(limit);
                this.context.setAfterLimit(true);
            }
            if (this == this.context.getTopNode() && !this.context.isHasAgg()) {
                ContextUtil.amendAllColsIfNoAgg(this);
            }
        }
    }

    @Generated
    public RexNode getLocalOffset() {
        return this.localOffset;
    }

    @Generated
    public RexNode getLocalFetch() {
        return this.localFetch;
    }

    @Override
    @Generated
    public ColumnRowType getColumnRowType() {
        return this.columnRowType;
    }

    @Override
    @Generated
    public OlapContext getContext() {
        return this.context;
    }

    @Override
    @Generated
    public Set<OlapContext> getSubContexts() {
        return this.subContexts;
    }

    @Override
    @Generated
    public void setSubContexts(Set<OlapContext> subContexts) {
        this.subContexts = subContexts;
    }
}

