/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.fun.SqlLibrary;
import org.apache.calcite.sql.fun.SqlLibraryOperatorTableFactory;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.util.SqlOperatorTables;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.sql2rel.StandardConvertletTable;
import org.apache.calcite.util.Pair;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.query.calcite.KylinRelDataTypeSystem;
import org.apache.kylin.query.engine.KylinConnectionConfig;
import org.apache.kylin.query.engine.TypeSystem;
import org.apache.kylin.query.schema.KylinSqlValidator;

public class SqlConverter {
    private final SqlParser.Config parserConfig;
    private final SqlValidator validator;
    private final SqlToRelConverter sqlToRelConverter;
    private final CalciteConnectionConfig connectionConfig;

    public SqlConverter(KylinConnectionConfig connectionConfig, RelOptPlanner planner, Prepare.CatalogReader catalogReader) {
        this(connectionConfig, planner, catalogReader, null);
    }

    public SqlConverter(KylinConnectionConfig connectionConfig, RelOptPlanner planner, Prepare.CatalogReader catalogReader, RelOptTable.ViewExpander viewExpander) {
        this.connectionConfig = connectionConfig;
        this.parserConfig = SqlParser.config().withQuotedCasing(connectionConfig.quotedCasing()).withUnquotedCasing(connectionConfig.unquotedCasing()).withQuoting(connectionConfig.quoting()).withIdentifierMaxLength(connectionConfig.getIdentifierMaxLength()).withConformance(connectionConfig.conformance()).withCaseSensitive(connectionConfig.caseSensitive());
        SqlOperatorTable sqlOperatorTable = this.createOperatorTable(catalogReader);
        this.validator = this.createValidator((CalciteConnectionConfig)connectionConfig, catalogReader, sqlOperatorTable);
        this.sqlToRelConverter = this.createSqlToRelConverter(connectionConfig, viewExpander, planner, this.validator, catalogReader);
    }

    public RelRoot convertSqlToRelNode(String sql) throws SqlParseException {
        SqlNode sqlNode = this.parseSQL(sql);
        QueryContext.current().record("end_calcite_parse_sql");
        return this.convertToRelNode(sqlNode);
    }

    public CalcitePrepare.AnalyzeViewResult analyzeSQl(String sql) throws SqlParseException {
        SqlNode sqlNode = this.parseSQL(sql);
        RelRoot relRoot = this.convertToRelNode(sqlNode);
        return new CalcitePrepare.AnalyzeViewResult(null, this.validator, sql, sqlNode, relRoot.validatedRowType, relRoot, null, null, null, null, false);
    }

    public static Prepare.CatalogReader createCatalogReader(CalciteConnectionConfig connectionConfig, CalciteSchema rootSchema, String defaultSchemaName) {
        KylinRelDataTypeSystem relTypeSystem = new KylinRelDataTypeSystem();
        JavaTypeFactoryImpl javaTypeFactory = new JavaTypeFactoryImpl((RelDataTypeSystem)relTypeSystem);
        return new CalciteCatalogReader(rootSchema, Collections.singletonList(defaultSchemaName), (RelDataTypeFactory)javaTypeFactory, connectionConfig);
    }

    private SqlValidator createValidator(CalciteConnectionConfig connectionConfig, Prepare.CatalogReader catalogReader, SqlOperatorTable sqlOperatorTable) {
        SqlValidator.Config config = SqlValidator.Config.DEFAULT.withConformance(connectionConfig.conformance()).withIdentifierExpansion(true).withDefaultNullCollation(connectionConfig.defaultNullCollation());
        return new KylinSqlValidator((SqlValidatorImpl)SqlValidatorUtil.newValidator((SqlOperatorTable)sqlOperatorTable, (SqlValidatorCatalogReader)catalogReader, (RelDataTypeFactory)this.javaTypeFactory(), (SqlValidator.Config)config));
    }

    private SqlOperatorTable createOperatorTable(Prepare.CatalogReader catalogReader) {
        return SqlOperatorTables.chain((SqlOperatorTable[])new SqlOperatorTable[]{catalogReader, SqlLibraryOperatorTableFactory.INSTANCE.getOperatorTable(new SqlLibrary[]{SqlLibrary.SPARK}), SqlStdOperatorTable.instance()});
    }

    private SqlToRelConverter createSqlToRelConverter(KylinConnectionConfig connectionConfig, RelOptTable.ViewExpander viewExpander, RelOptPlanner planner, SqlValidator sqlValidator, Prepare.CatalogReader catalogReader) {
        KylinConfig kylinConfig = connectionConfig.getKylinConfig();
        SqlToRelConverter.Config config = SqlToRelConverter.CONFIG.withTrimUnusedFields(true).withInSubQueryThreshold(kylinConfig.convertInSubQueryThreshold()).withExpand(Boolean.TRUE.equals(Prepare.THREAD_EXPAND.get())).addRelBuilderConfigTransform(x -> x.withBloat(kylinConfig.getProjectBloatThreshold())).withExplain(false);
        RelOptCluster cluster = RelOptCluster.create((RelOptPlanner)planner, (RexBuilder)new RexBuilder((RelDataTypeFactory)this.javaTypeFactory()));
        return new SqlToRelConverter(viewExpander, sqlValidator, catalogReader, cluster, (SqlRexConvertletTable)StandardConvertletTable.INSTANCE, config);
    }

    private JavaTypeFactory javaTypeFactory() {
        return TypeSystem.javaTypeFactory();
    }

    private SqlNode parseSQL(String sql) throws SqlParseException {
        return SqlParser.create((String)sql, (SqlParser.Config)this.parserConfig).parseQuery();
    }

    private RelRoot convertToRelNode(SqlNode sqlNode) {
        RelRoot root = this.sqlToRelConverter.convertQuery(sqlNode, true, true);
        if (this.connectionConfig.forceDecorrelate()) {
            root = root.withRel(this.sqlToRelConverter.decorrelate(sqlNode, root.rel));
        }
        RelNode rel = root.rel;
        if (this.connectionConfig.projectUnderRelRoot() && !root.isRefTrivial()) {
            ArrayList<RexInputRef> projects = new ArrayList<RexInputRef>();
            RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
            Iterator iterator = Pair.left((List)root.fields).iterator();
            while (iterator.hasNext()) {
                int field = (Integer)iterator.next();
                projects.add(rexBuilder.makeInputRef(rel, field));
            }
            LogicalProject project = LogicalProject.create((RelNode)root.rel, (List)ImmutableList.of(), projects, (RelDataType)root.validatedRowType);
            root = new RelRoot((RelNode)project, root.validatedRowType, root.kind, (List)root.fields, RelCollations.EMPTY, (List)ImmutableList.of());
        }
        return root;
    }
}

