/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import com.github.luben.zstd.ZstdInputStreamNoFinalizer;
import com.ning.compress.lzf.LZFInputStream;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.zip.CheckedInputStream;
import net.jpountz.lz4.LZ4BlockInputStream;
import org.apache.gluten.exception.GlutenException;
import org.apache.gluten.vectorized.LowCopyFileSegmentShuffleInputStream;
import org.apache.gluten.vectorized.LowCopyNettyShuffleInputStream;
import org.apache.gluten.vectorized.OnHeapCopyShuffleInputStream;
import org.apache.gluten.vectorized.ShuffleInputStream;
import org.apache.spark.network.util.LimitedInputStream;
import org.apache.spark.storage.BufferReleasingInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xerial.snappy.SnappyInputStream;

public final class CHShuffleReadStreamFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CHShuffleReadStreamFactory.class);
    public static final Field FIELD_FilterInputStream_in;
    public static final Field FIELD_ByteBufInputStream_buffer;
    public static final Field FIELD_LimitedInputStream_left;
    public static final Field FIELD_SnappyInputStream_in;
    public static final Field FIELD_LZ4BlockInputStream_in;
    public static final Field FIELD_BufferedInputStream_in;
    public static final Field FIELD_ZstdInputStreamNoFinalizer_in;
    public static final Field FIELD_LZFInputStream_in;

    private CHShuffleReadStreamFactory() {
    }

    public static ShuffleInputStream create(byte[] allBatches, boolean compressed) {
        return new OnHeapCopyShuffleInputStream(new ByteArrayInputStream(allBatches), compressed);
    }

    public static ShuffleInputStream create(InputStream in, boolean forceCompress, boolean isCustomizedShuffleCodec) {
        InputStream unwrapped = CHShuffleReadStreamFactory.unwrapInputStream(in, forceCompress, isCustomizedShuffleCodec);
        if (unwrapped != null) {
            return CHShuffleReadStreamFactory.createCompressedShuffleInputStream(in, unwrapped);
        }
        return new OnHeapCopyShuffleInputStream(in, false);
    }

    private static InputStream unwrapInputStream(InputStream in, boolean forceCompress, boolean isCustomizedShuffleCodec) {
        if (forceCompress) {
            return CHShuffleReadStreamFactory.unwrapSparkInputStream(in);
        }
        if (isCustomizedShuffleCodec) {
            return CHShuffleReadStreamFactory.unwrapSparkWithCompressedInputStream(in);
        }
        return null;
    }

    private static ShuffleInputStream createCompressedShuffleInputStream(InputStream in, InputStream unwrapped) {
        LimitedInputStream limitedInputStream = CHShuffleReadStreamFactory.isReadFromFileSegment(unwrapped);
        if (limitedInputStream != null) {
            return new LowCopyFileSegmentShuffleInputStream(in, limitedInputStream, true);
        }
        ByteBuf byteBuf = CHShuffleReadStreamFactory.isReadFromNettySupported(unwrapped);
        if (byteBuf != null) {
            return new LowCopyNettyShuffleInputStream(in, byteBuf, true);
        }
        return new OnHeapCopyShuffleInputStream(in, true);
    }

    public static InputStream unwrapSparkInputStream(InputStream in) {
        InputStream unwrapped = in;
        if (unwrapped instanceof BufferReleasingInputStream) {
            BufferReleasingInputStream brin = (BufferReleasingInputStream)unwrapped;
            unwrapped = brin.delegate();
        }
        if (unwrapped instanceof CheckedInputStream) {
            CheckedInputStream cin = (CheckedInputStream)unwrapped;
            try {
                unwrapped = (InputStream)FIELD_FilterInputStream_in.get(cin);
            }
            catch (IllegalAccessException e) {
                LOG.error("Can not get the field 'in' from CheckedInputStream: ", (Throwable)e);
                return in;
            }
        }
        return unwrapped;
    }

    public static InputStream unwrapSparkWithCompressedInputStream(InputStream in) {
        InputStream unwrappedCompression;
        InputStream unwrapped = in;
        if (unwrapped instanceof BufferReleasingInputStream) {
            BufferReleasingInputStream brin = (BufferReleasingInputStream)unwrapped;
            unwrapped = brin.delegate();
        }
        if ((unwrappedCompression = CHShuffleReadStreamFactory.unwrapCompressionInputStream(unwrapped)) != null) {
            if (unwrappedCompression instanceof CheckedInputStream) {
                CheckedInputStream cin = (CheckedInputStream)unwrappedCompression;
                try {
                    return (InputStream)FIELD_FilterInputStream_in.get(cin);
                }
                catch (IllegalAccessException e) {
                    LOG.error("Can not get the field 'in' from CheckedInputStream: ", (Throwable)e);
                    return null;
                }
            }
        } else {
            return null;
        }
        return unwrapped;
    }

    public static LimitedInputStream isReadFromFileSegment(InputStream in) {
        InputStream wrapped;
        if (!(in instanceof LimitedInputStream)) {
            return null;
        }
        LimitedInputStream lin = (LimitedInputStream)in;
        try {
            wrapped = (InputStream)FIELD_FilterInputStream_in.get(lin);
        }
        catch (IllegalAccessException e) {
            LOG.error("Can not get the fields from LimitedInputStream: ", (Throwable)e);
            return null;
        }
        if (!(wrapped instanceof FileInputStream)) {
            return null;
        }
        return lin;
    }

    public static ByteBuf isReadFromNettySupported(InputStream in) {
        if (!(in instanceof ByteBufInputStream)) {
            return null;
        }
        ByteBufInputStream bbin = (ByteBufInputStream)in;
        try {
            ByteBuf byteBuf = (ByteBuf)FIELD_ByteBufInputStream_buffer.get(bbin);
            if (!byteBuf.isDirect()) {
                return null;
            }
            return byteBuf;
        }
        catch (IllegalAccessException e) {
            LOG.error("Can not get the field 'buffer' from ByteBufInputStream: ", (Throwable)e);
            return null;
        }
    }

    public static InputStream unwrapCompressionInputStream(InputStream is) {
        InputStream unwrapped = is;
        try {
            if (unwrapped instanceof BufferedInputStream) {
                InputStream cis = (InputStream)FIELD_BufferedInputStream_in.get(unwrapped);
                if (cis instanceof ZstdInputStreamNoFinalizer) {
                    unwrapped = (InputStream)FIELD_ZstdInputStreamNoFinalizer_in.get(cis);
                }
            } else {
                if (unwrapped instanceof SnappyInputStream) {
                    return null;
                }
                if (unwrapped instanceof LZ4BlockInputStream) {
                    unwrapped = (InputStream)FIELD_LZ4BlockInputStream_in.get(unwrapped);
                } else if (unwrapped instanceof LZFInputStream) {
                    unwrapped = (InputStream)FIELD_LZFInputStream_in.get(unwrapped);
                }
            }
        }
        catch (IllegalAccessException e) {
            LOG.error("Can not get the field 'in' from compression input stream: ", (Throwable)e);
            return null;
        }
        return unwrapped;
    }

    static {
        try {
            FIELD_FilterInputStream_in = FilterInputStream.class.getDeclaredField("in");
            FIELD_FilterInputStream_in.setAccessible(true);
            FIELD_ByteBufInputStream_buffer = ByteBufInputStream.class.getDeclaredField("buffer");
            FIELD_ByteBufInputStream_buffer.setAccessible(true);
            FIELD_LimitedInputStream_left = LimitedInputStream.class.getDeclaredField("left");
            FIELD_LimitedInputStream_left.setAccessible(true);
            FIELD_SnappyInputStream_in = SnappyInputStream.class.getDeclaredField("in");
            FIELD_SnappyInputStream_in.setAccessible(true);
            FIELD_LZ4BlockInputStream_in = LZ4BlockInputStream.class.getSuperclass().getDeclaredField("in");
            FIELD_LZ4BlockInputStream_in.setAccessible(true);
            FIELD_BufferedInputStream_in = BufferedInputStream.class.getSuperclass().getDeclaredField("in");
            FIELD_BufferedInputStream_in.setAccessible(true);
            FIELD_ZstdInputStreamNoFinalizer_in = ZstdInputStreamNoFinalizer.class.getSuperclass().getDeclaredField("in");
            FIELD_ZstdInputStreamNoFinalizer_in.setAccessible(true);
            FIELD_LZFInputStream_in = LZFInputStream.class.getDeclaredField("_inputStream");
            FIELD_LZFInputStream_in.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new GlutenException((Throwable)e);
        }
    }
}

