/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.vectorized;

import org.apache.gluten.exception.GlutenException;
import org.apache.gluten.vectorized.BlockStats;
import org.apache.gluten.vectorized.CHColumnVector;
import org.apache.spark.sql.execution.utils.CHExecUtil;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;

public class CHNativeBlock {
    private long blockAddress;

    public CHNativeBlock(long blockAddress) {
        this.blockAddress = blockAddress;
    }

    public static CHNativeBlock fromColumnarBatch(ColumnarBatch batch) {
        if (batch.numCols() == 0 || !(batch.column(0) instanceof CHColumnVector)) {
            throw new GlutenException("Unexpected ColumnarBatch: " + (batch.numCols() == 0 ? "0 column" : "expected CHColumnVector, but " + batch.column(0).getClass()));
        }
        CHColumnVector columnVector = (CHColumnVector)batch.column(0);
        return new CHNativeBlock(columnVector.getBlockAddress());
    }

    private native int nativeNumRows(long var1);

    public int numRows() {
        return this.nativeNumRows(this.blockAddress);
    }

    public long blockAddress() {
        return this.blockAddress;
    }

    private native int nativeNumColumns(long var1);

    public int numColumns() {
        return this.nativeNumColumns(this.blockAddress);
    }

    private native byte[] nativeColumnType(long var1, int var3);

    public byte[] getTypeByPosition(int position) {
        return this.nativeColumnType(this.blockAddress, position);
    }

    private native long nativeTotalBytes(long var1);

    public long totalBytes() {
        return this.nativeTotalBytes(this.blockAddress);
    }

    public native void nativeClose(long var1);

    public native BlockStats nativeBlockStats(long var1, int var3);

    public BlockStats getBlockStats(int columnPosition) {
        return this.nativeBlockStats(this.blockAddress, columnPosition);
    }

    public void close() {
        if (this.blockAddress != 0L) {
            this.nativeClose(this.blockAddress);
            this.blockAddress = 0L;
        }
    }

    public static void closeFromColumnarBatch(ColumnarBatch cb) {
        if (cb != null) {
            if (cb.numCols() > 0) {
                CHColumnVector col = (CHColumnVector)cb.column(0);
                CHNativeBlock block = new CHNativeBlock(col.getBlockAddress());
                block.close();
            }
            cb.close();
        }
    }

    public ColumnarBatch toColumnarBatch() {
        int numRows = this.numRows();
        int cols = this.numColumns();
        ColumnVector[] vectors = new ColumnVector[cols];
        for (int i = 0; i < cols; ++i) {
            vectors[i] = new CHColumnVector(CHExecUtil.inferSparkDataType(this.getTypeByPosition(i)), this.blockAddress, i);
        }
        return new ColumnarBatch(vectors, numRows);
    }
}

