/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableMap;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.graph.JoinsGraph;
import org.apache.kylin.metadata.model.util.JoinDescUtil;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.query.util.QueryModelPriorities;
import org.apache.kylin.rec.AbstractContext;
import org.apache.kylin.rec.common.AccelerateInfo;
import org.apache.kylin.rec.model.ModelTree;
import org.apache.kylin.rec.util.TableAliasGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreedyModelTreesBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GreedyModelTreesBuilder.class);
    private final Map<String, TableDesc> tableMap;
    KylinConfig kylinConfig;
    AbstractContext proposeContext;

    public GreedyModelTreesBuilder(KylinConfig kylinConfig, String project, AbstractContext proposeContext) {
        this.kylinConfig = kylinConfig;
        this.tableMap = NTableMetadataManager.getInstance((KylinConfig)kylinConfig, (String)project).getAllTablesMap();
        this.proposeContext = proposeContext;
    }

    public List<ModelTree> build(Map<String, Collection<OlapContext>> olapContexts, TableDesc expectedFactTable) {
        HashMap groupedMap = Maps.newHashMap();
        olapContexts.forEach((sql, sqlContexts) -> {
            Map<TableDesc, Map<String, List<OlapContext>>> groupingResult = sqlContexts.stream().filter(ctx -> this.isFactTableCompatible((OlapContext)ctx, expectedFactTable)).collect(Collectors.groupingBy(ctx -> ctx.getFirstTableScan().getTableRef().getTableDesc(), Collectors.groupingBy(ctx -> {
                Object[] modelPriorities = QueryModelPriorities.getModelPrioritiesFromComment((String)ctx.getSql());
                return StringUtils.join((Object[])modelPriorities);
            })));
            groupingResult.forEach((table, map) -> {
                groupedMap.putIfAbsent(table, Maps.newLinkedHashMap());
                Map hintOlapMap = (Map)groupedMap.get(table);
                map.forEach((hint, olapList) -> {
                    List contexts = hintOlapMap.computeIfAbsent(hint, h -> Lists.newArrayList());
                    contexts.addAll(olapList);
                });
            });
        });
        List<ModelTree> modelTreeList = groupedMap.values().stream().flatMap(hintOlapMap -> hintOlapMap.values().stream()).filter(olapList -> !olapList.isEmpty()).map(olapList -> {
            TableDesc table = ((OlapContext)olapList.get(0)).getFirstTableScan().getTableRef().getTableDesc();
            TreeBuilder builder = new TreeBuilder(table, this.tableMap, this.proposeContext);
            builder.contextList.addAll(olapList);
            return builder.build();
        }).flatMap(Collection::stream).collect(Collectors.toList());
        LinkedHashMap<ModelTree, ModelTree> modelTreeMap = new LinkedHashMap<ModelTree, ModelTree>();
        for (ModelTree modelTree : modelTreeList) {
            if (modelTreeMap.containsKey(modelTree)) {
                ModelTree existingTree = (ModelTree)modelTreeMap.get(modelTree);
                existingTree.getOlapContexts().addAll(modelTree.getOlapContexts());
                existingTree.getTableRefAliasMap().putAll(modelTree.getTableRefAliasMap());
                continue;
            }
            modelTreeMap.put(modelTree, modelTree);
        }
        modelTreeList = new ArrayList(modelTreeMap.values());
        if (expectedFactTable != null && modelTreeList.stream().noneMatch(tree -> tree.getRootFactTable() == expectedFactTable)) {
            log.debug("There is no modelTree relies on fact table({}), add a new one.", (Object)expectedFactTable.getIdentity());
            ModelTree emptyTree = new ModelTree(expectedFactTable, (Collection<OlapContext>)ImmutableList.of(), (Map<String, JoinTableDesc>)ImmutableMap.of(), (Map<TableRef, String>)ImmutableMap.of());
            modelTreeList.add(emptyTree);
        }
        return modelTreeList;
    }

    private boolean isFactTableCompatible(OlapContext ctx, TableDesc factTable) {
        if (ctx.getFirstTableScan() == null) {
            return false;
        }
        TableDesc ctxFactTable = ctx.getFirstTableScan().getTableRef().getTableDesc();
        return factTable == null || Objects.equals(ctxFactTable.getIdentity(), factTable.getIdentity());
    }

    public ModelTree build(Collection<OlapContext> olapContexts, TableDesc actualFactTbl) {
        TreeBuilder treeBuilder = new TreeBuilder(actualFactTbl, this.tableMap, this.proposeContext);
        treeBuilder.contextList.addAll(olapContexts);
        return treeBuilder.buildOne(olapContexts, false);
    }

    public static class TreeBuilder {
        private final TableDesc rootFact;
        private final TableAliasGenerator.TableAliasDict dict;
        private final AbstractContext proposeContext;
        private final List<OlapContext> contextList = Lists.newArrayList();

        public TreeBuilder(TableDesc rootFact, Map<String, TableDesc> tableMap, AbstractContext proposeContext) {
            this.rootFact = rootFact;
            this.dict = TableAliasGenerator.generateNewDict(tableMap.keySet().toArray(new String[0]));
            this.proposeContext = proposeContext;
        }

        static Map<TableRef, String> getUniqueTblAliasBasedOnPosInGraph(OlapContext ctx, TableAliasGenerator.TableAliasDict dict) {
            JoinsGraph joinsGraph = ctx.getJoinsGraph();
            if (joinsGraph == null) {
                joinsGraph = new JoinsGraph(ctx.getFirstTableScan().getTableRef(), ctx.getJoins());
            }
            return TreeBuilder.getUniqueTblAliasBasedOnPosInGraph(joinsGraph, dict);
        }

        static Map<TableRef, String> getUniqueTblAliasBasedOnPosInGraph(JoinsGraph joinsGraph, TableAliasGenerator.TableAliasDict dict) {
            HashMap<TableRef, String> allTableAlias = new HashMap<TableRef, String>();
            for (TableRef tableRef : joinsGraph.getAllTblRefNodes()) {
                JoinDesc[] joinHierarchy = TreeBuilder.getJoinDescHierarchy(joinsGraph, tableRef);
                String tblAlias = joinHierarchy.length == 0 ? joinsGraph.getCenter().getTableName() : dict.getHierarchyAliasFromJoins(joinHierarchy);
                allTableAlias.put(tableRef, tblAlias);
            }
            return allTableAlias;
        }

        static Map<TableRef, String> correctTblAliasAndKeepOriginAlias(Map<TableRef, String> tblRef2TreePathName, TableDesc rootFact, Map<TableRef, String> originTblAlias) {
            String corrected;
            HashMap<String, TableDesc> classifiedAlias = new HashMap<String, TableDesc>();
            for (Map.Entry<TableRef, String> entry : tblRef2TreePathName.entrySet()) {
                classifiedAlias.put(entry.getValue(), entry.getKey().getTableDesc());
            }
            HashMap<Object, String> orig2corrected = new HashMap<Object, String>();
            String factTableName = rootFact.getName();
            orig2corrected.put(factTableName, factTableName);
            classifiedAlias.remove(factTableName);
            for (Map.Entry<TableRef, String> entry : originTblAlias.entrySet()) {
                orig2corrected.putIfAbsent(tblRef2TreePathName.get(entry.getKey()), entry.getValue());
                classifiedAlias.remove(tblRef2TreePathName.get(entry.getKey()));
            }
            for (Map.Entry<Object, String> entry : classifiedAlias.entrySet()) {
                String tableName;
                corrected = tableName = ((TableDesc)entry.getValue()).getName();
                int i = 1;
                while (orig2corrected.containsValue(corrected)) {
                    corrected = tableName + "_" + i;
                    ++i;
                }
                orig2corrected.put(entry.getKey(), corrected);
            }
            HashMap correctedTableAlias = Maps.newHashMap();
            for (Map.Entry<TableRef, String> entry : tblRef2TreePathName.entrySet()) {
                corrected = (String)orig2corrected.get(entry.getValue());
                correctedTableAlias.put(entry.getKey(), corrected);
            }
            return correctedTableAlias;
        }

        private static Map<TableRef, String> correctTableAlias(Map<TableRef, String> innerTableRefAlias, TableDesc rootFact) {
            return TreeBuilder.correctTblAliasAndKeepOriginAlias(innerTableRefAlias, rootFact, Maps.newHashMap());
        }

        private List<ModelTree> build() {
            ArrayList result = Lists.newArrayList();
            while (!this.contextList.isEmpty()) {
                result.add(this.buildOne(this.contextList, false));
            }
            return result;
        }

        private ModelTree buildOne(Collection<OlapContext> inputCtxs, boolean forceMerge) {
            HashMap innerTableRefAlias = Maps.newHashMap();
            HashMap correctedTableAlias = Maps.newHashMap();
            ArrayList usedCtxs = Lists.newArrayList();
            ArrayList ctxsNeedMerge = Lists.newArrayList();
            inputCtxs.removeIf(Objects::isNull);
            inputCtxs.stream().filter(ctx -> forceMerge || this.matchContext(usedCtxs, (OlapContext)ctx)).filter(ctx -> {
                innerTableRefAlias.putAll(TreeBuilder.getUniqueTblAliasBasedOnPosInGraph(ctx, this.dict));
                correctedTableAlias.putAll(TreeBuilder.correctTableAlias(innerTableRefAlias, this.rootFact));
                usedCtxs.add(ctx);
                return !ctx.getJoins().isEmpty();
            }).forEach(ctxsNeedMerge::add);
            HashMap aliasRefMap = Maps.newHashMap();
            LinkedHashMap<String, JoinTableDesc> joinTables = new LinkedHashMap<String, JoinTableDesc>();
            Map<String, AccelerateInfo> accelerateInfoMap = this.proposeContext.getAccelerateInfoMap();
            for (OlapContext ctx2 : ctxsNeedMerge) {
                AccelerateInfo accelerateInfo = accelerateInfoMap.get(ctx2.getSql());
                if (accelerateInfo.isNotSucceed()) {
                    inputCtxs.remove(ctx2);
                    usedCtxs.remove(ctx2);
                    continue;
                }
                try {
                    TreeBuilder.mergeContext(ctx2, joinTables, correctedTableAlias, aliasRefMap);
                }
                catch (Exception e) {
                    log.debug("Failed to accelerate sql: \n{}\n", (Object)ctx2.getSql(), (Object)e);
                    inputCtxs.remove(ctx2);
                    usedCtxs.remove(ctx2);
                    accelerateInfo.setFailedCause(e);
                }
            }
            inputCtxs.removeAll(usedCtxs);
            return new ModelTree(this.rootFact, usedCtxs, joinTables, correctedTableAlias);
        }

        public boolean matchContext(List<OlapContext> ctxs, OlapContext anotherCtx) {
            return ctxs.stream().allMatch(thisCtx -> this.matchContext((OlapContext)thisCtx, anotherCtx));
        }

        public boolean matchContext(OlapContext ctxA, OlapContext ctxB) {
            JoinsGraph graphB;
            if (ctxA == ctxB) {
                return true;
            }
            if (ctxA == null || ctxB == null) {
                return false;
            }
            JoinsGraph graphA = new JoinsGraph(ctxA.getFirstTableScan().getTableRef(), (List)Lists.newArrayList((Iterable)ctxA.getJoins()));
            return graphA.match(graphB = new JoinsGraph(ctxB.getFirstTableScan().getTableRef(), (List)Lists.newArrayList((Iterable)ctxB.getJoins())), (Map)Maps.newHashMap(), this.proposeContext.isPartialMatch(), this.proposeContext.isPartialMatchNonEqui()) || graphB.match(graphA, (Map)Maps.newHashMap(), this.proposeContext.isPartialMatch(), this.proposeContext.isPartialMatchNonEqui()) || graphA.unmatched(graphB).stream().allMatch(e -> e.isLeftJoin() && !e.isNonEquiJoin()) && graphB.unmatched(graphA).stream().allMatch(e -> e.isLeftJoin() && !e.isNonEquiJoin());
        }

        static void mergeContext(OlapContext ctx, Map<String, JoinTableDesc> alias2JoinTables, Map<TableRef, String> tableRef2Alias, Map<String, TableRef> aliasRefMap) {
            TreeBuilder.mergeJoins(ctx.getJoins(), alias2JoinTables, tableRef2Alias, aliasRefMap);
        }

        public AbstractContext.ModelContext mergeModelContext(AbstractContext proposeContext, AbstractContext.ModelContext modelContext, AbstractContext.ModelContext another) {
            ArrayList olapCtxs = Lists.newArrayList(modelContext.getModelTree().getOlapContexts());
            olapCtxs.addAll(another.getModelTree().getOlapContexts());
            return new AbstractContext.ModelContext(proposeContext, this.buildOne(olapCtxs, true));
        }

        private static void mergeJoins(List<JoinDesc> joins, Map<String, JoinTableDesc> alias2JoinTables, Map<TableRef, String> tableRef2Alias, Map<String, TableRef> aliasRefMap) {
            LinkedHashMap<String, JoinTableDesc> alias2JoinTablesUpdates = new LinkedHashMap<String, JoinTableDesc>(alias2JoinTables);
            LinkedHashMap<TableRef, String> tableRef2AliasUpdates = new LinkedHashMap<TableRef, String>(tableRef2Alias);
            List tableKindByJoins = JoinDescUtil.resolveTableType(joins);
            for (Pair pair : tableKindByJoins) {
                JoinDesc join = (JoinDesc)pair.getFirst();
                NDataModel.TableKind kind = (NDataModel.TableKind)pair.getSecond();
                String pkTblAlias = (String)tableRef2AliasUpdates.get(join.getPKSide());
                String fkTblAlias = (String)tableRef2AliasUpdates.get(join.getFKSide());
                String joinTableAlias = pkTblAlias;
                boolean isValidJoin = false;
                int loops = 0;
                while (!isValidJoin) {
                    JoinTableDesc newJoinTable = JoinDescUtil.convert((JoinDesc)join, (NDataModel.TableKind)kind, (String)joinTableAlias, (String)fkTblAlias, aliasRefMap);
                    JoinTableDesc oldJoinTable = alias2JoinTablesUpdates.computeIfAbsent(joinTableAlias, alias -> newJoinTable);
                    if (JoinDescUtil.isJoinTableEqual((JoinTableDesc)oldJoinTable, (JoinTableDesc)newJoinTable)) {
                        isValidJoin = true;
                    } else if (JoinDescUtil.isJoinKeysEqual((JoinDesc)oldJoinTable.getJoin(), (JoinDesc)newJoinTable.getJoin()) && JoinDescUtil.isJoinTypeEqual((JoinDesc)oldJoinTable.getJoin(), (JoinDesc)newJoinTable.getJoin()) && oldJoinTable.getKind() != newJoinTable.getKind()) {
                        newJoinTable.setKind(NDataModel.TableKind.FACT);
                        alias2JoinTablesUpdates.put(joinTableAlias, newJoinTable);
                    } else {
                        joinTableAlias = TreeBuilder.getNewAlias(join.getPKSide().getTableName(), newJoinTable.getAlias());
                    }
                    if (loops++ <= 100) continue;
                    break;
                }
                Preconditions.checkState((boolean)isValidJoin, (String)"Failed to merge table join: %s.", (Object)join);
                tableRef2AliasUpdates.put(join.getPKSide(), joinTableAlias);
            }
            alias2JoinTables.putAll(alias2JoinTablesUpdates);
            tableRef2Alias.putAll(tableRef2AliasUpdates);
        }

        private static JoinDesc[] getJoinDescHierarchy(JoinsGraph joinsTree, TableRef leaf) {
            Preconditions.checkState((leaf != null ? 1 : 0) != 0, (Object)"The TableRef cannot be null!");
            JoinDesc join = joinsTree.getJoinByPKSide(leaf);
            if (join == null) {
                return new JoinDesc[0];
            }
            return (JoinDesc[])ArrayUtils.add((Object[])TreeBuilder.getJoinDescHierarchy(joinsTree, join.getFKSide()), (Object)join);
        }

        private static String getNewAlias(String originalName, String oldAlias) {
            if (oldAlias.equals(originalName)) {
                return originalName + "_1";
            }
            if (!oldAlias.startsWith(originalName + "_")) {
                return originalName;
            }
            String number = oldAlias.substring(originalName.length() + 1);
            try {
                int i = Integer.parseInt(number);
                return originalName + "_" + (i + 1);
            }
            catch (Exception e) {
                return originalName + "_1";
            }
        }
    }
}

