/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.stats;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Arrays;
import org.apache.spark.sql.delta.stats.FileSizeHistogram$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005uf\u0001B\u0010!\u00016B\u0001B\u000f\u0001\u0003\u0016\u0004%\ta\u000f\u0005\t\u0017\u0002\u0011\t\u0012)A\u0005y!AA\n\u0001BK\u0002\u0013\u0005Q\n\u0003\u0005R\u0001\tE\t\u0015!\u0003O\u0011!\u0011\u0006A!f\u0001\n\u0003i\u0005\u0002C*\u0001\u0005#\u0005\u000b\u0011\u0002(\t\u000bQ\u0003A\u0011A+\t\u000bM\u0004A\u0011\t;\t\u000ba\u0004A\u0011I=\t\u000f\u0005\u0015\u0001\u0001\"\u0001\u0002\b!9\u00111\u0003\u0001\u0005\u0002\u0005U\u0001\"CA\r\u0001\u0005\u0005I\u0011AA\u000e\u0011%\t\u0019\u0003AI\u0001\n\u0003\t)\u0003C\u0005\u0002:\u0001\t\n\u0011\"\u0001\u0002<!I\u0011q\b\u0001\u0012\u0002\u0013\u0005\u00111\b\u0005\n\u0003\u0003\u0002\u0011\u0011!C!\u0003\u0007B\u0011\"a\u0013\u0001\u0003\u0003%\t!!\u0014\t\u0013\u0005=\u0003!!A\u0005\u0002\u0005E\u0003\"CA,\u0001\u0005\u0005I\u0011IA-\u0011%\t9\u0007AA\u0001\n\u0003\tI\u0007C\u0005\u0002n\u0001\t\t\u0011\"\u0011\u0002p\u001dA\u0011\u0011\u000f\u0011\t\u0002\t\n\u0019HB\u0004 A!\u0005!%!\u001e\t\rQ;B\u0011AA<\u0011\u001d\tIh\u0006C\u0001\u0003wBq!!!\u0018\t\u0003\t\u0019\t\u0003\u0006\u0002\b^A)\u0019!C\u0001\u0003\u0013C\u0011\"!!\u0018\u0003\u0003%\t)a&\t\u0013\u0005}u#!A\u0005\u0002\u0006\u0005\u0006\"CAZ/\u0005\u0005I\u0011BA[\u0005E1\u0015\u000e\\3TSj,\u0007*[:u_\u001e\u0014\u0018-\u001c\u0006\u0003C\t\nQa\u001d;biNT!a\t\u0013\u0002\u000b\u0011,G\u000e^1\u000b\u0005\u00152\u0013aA:rY*\u0011q\u0005K\u0001\u0006gB\f'o\u001b\u0006\u0003S)\na!\u00199bG\",'\"A\u0016\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001qCg\u000e\t\u0003_Ij\u0011\u0001\r\u0006\u0002c\u0005)1oY1mC&\u00111\u0007\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=*\u0014B\u0001\u001c1\u0005\u001d\u0001&o\u001c3vGR\u0004\"a\f\u001d\n\u0005e\u0002$\u0001D*fe&\fG.\u001b>bE2,\u0017aE:peR,GMQ5o\u0005>,h\u000eZ1sS\u0016\u001cX#\u0001\u001f\u0011\u0007u*\u0005J\u0004\u0002?\u0007:\u0011qHQ\u0007\u0002\u0001*\u0011\u0011\tL\u0001\u0007yI|w\u000e\u001e \n\u0003EJ!\u0001\u0012\u0019\u0002\u000fA\f7m[1hK&\u0011ai\u0012\u0002\u000b\u0013:$W\r_3e'\u0016\f(B\u0001#1!\ty\u0013*\u0003\u0002Ka\t!Aj\u001c8h\u0003Q\u0019xN\u001d;fI\nKgNQ8v]\u0012\f'/[3tA\u0005Qa-\u001b7f\u0007>,h\u000e^:\u0016\u00039\u00032aL(I\u0013\t\u0001\u0006GA\u0003BeJ\f\u00170A\u0006gS2,7i\\;oiN\u0004\u0013A\u0003;pi\u0006d')\u001f;fg\u0006YAo\u001c;bY\nKH/Z:!\u0003\u0019a\u0014N\\5u}Q!a\u000bW9s!\t9\u0006!D\u0001!\u0011\u0015Qt\u00011\u0001=Q\u0011A&\f[5\u0011\u0005m3W\"\u0001/\u000b\u0005us\u0016AC1o]>$\u0018\r^5p]*\u0011q\fY\u0001\tI\u0006$\u0018MY5oI*\u0011\u0011MY\u0001\bU\u0006\u001c7n]8o\u0015\t\u0019G-A\u0005gCN$XM\u001d=nY*\tQ-A\u0002d_6L!a\u001a/\u0003\u001f)\u001bxN\u001c#fg\u0016\u0014\u0018.\u00197ju\u0016\f\u0011bY8oi\u0016tG/Q:$\u0003)\u0004\"a\u001b9\u000e\u00031T!!\u001c8\u0002\t1\fgn\u001a\u0006\u0002_\u0006!!.\u0019<b\u0013\tQE\u000eC\u0003M\u000f\u0001\u0007a\nC\u0003S\u000f\u0001\u0007a*\u0001\u0005iCND7i\u001c3f)\u0005)\bCA\u0018w\u0013\t9\bGA\u0002J]R\fa!Z9vC2\u001cHC\u0001>~!\ty30\u0003\u0002}a\t9!i\\8mK\u0006t\u0007\"\u0002@\n\u0001\u0004y\u0018\u0001\u0002;iCR\u00042aLA\u0001\u0013\r\t\u0019\u0001\r\u0002\u0004\u0003:L\u0018AB5og\u0016\u0014H\u000f\u0006\u0003\u0002\n\u0005=\u0001cA\u0018\u0002\f%\u0019\u0011Q\u0002\u0019\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003#Q\u0001\u0019\u0001%\u0002\u0011\u0019LG.Z*ju\u0016\faA]3n_Z,G\u0003BA\u0005\u0003/Aa!!\u0005\f\u0001\u0004A\u0015\u0001B2paf$rAVA\u000f\u0003?\t\t\u0003C\u0004;\u0019A\u0005\t\u0019\u0001\u001f\t\u000f1c\u0001\u0013!a\u0001\u001d\"9!\u000b\u0004I\u0001\u0002\u0004q\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003OQ3\u0001PA\u0015W\t\tY\u0003\u0005\u0003\u0002.\u0005URBAA\u0018\u0015\u0011\t\t$a\r\u0002\u0013Ut7\r[3dW\u0016$'BA/1\u0013\u0011\t9$a\f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005u\"f\u0001(\u0002*\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002FA\u00191.a\u0012\n\u0007\u0005%CN\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0002k\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HcA@\u0002T!A\u0011Q\u000b\n\u0002\u0002\u0003\u0007Q/A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u00037\u0002R!!\u0018\u0002d}l!!a\u0018\u000b\u0007\u0005\u0005\u0004'\u0001\u0006d_2dWm\u0019;j_:LA!!\u001a\u0002`\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\rQ\u00181\u000e\u0005\t\u0003+\"\u0012\u0011!a\u0001\u007f\u0006AAo\\*ue&tw\r\u0006\u0002\u0002F\u0005\tb)\u001b7f'&TX\rS5ti><'/Y7\u0011\u0005];2cA\f/oQ\u0011\u00111O\u0001\fO\u0016$()\u001b8J]\u0012,\u0007\u0010F\u0003v\u0003{\ny\b\u0003\u0004\u0002\u0012e\u0001\r\u0001\u0013\u0005\u0006ue\u0001\r\u0001P\u0001\u0006CB\u0004H.\u001f\u000b\u0004-\u0006\u0015\u0005\"\u0002\u001e\u001b\u0001\u0004a\u0014AB:dQ\u0016l\u0017-\u0006\u0002\u0002\fB!\u0011QRAJ\u001b\t\tyIC\u0002\u0002\u0012\u0012\nQ\u0001^=qKNLA!!&\u0002\u0010\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0015\u000fY\u000bI*a'\u0002\u001e\")!\b\ba\u0001y!)A\n\ba\u0001\u001d\")!\u000b\ba\u0001\u001d\u00069QO\\1qa2LH\u0003BAR\u0003_\u0003RaLAS\u0003SK1!a*1\u0005\u0019y\u0005\u000f^5p]B1q&a+=\u001d:K1!!,1\u0005\u0019!V\u000f\u001d7fg!A\u0011\u0011W\u000f\u0002\u0002\u0003\u0007a+A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011q\u0017\t\u0004W\u0006e\u0016bAA^Y\n1qJ\u00196fGR\u0004")
public class FileSizeHistogram
implements Product,
Serializable {
    private final IndexedSeq<Object> sortedBinBoundaries;
    private final long[] fileCounts;
    private final long[] totalBytes;

    public static Option<Tuple3<IndexedSeq<Object>, long[], long[]>> unapply(FileSizeHistogram fileSizeHistogram) {
        return FileSizeHistogram$.MODULE$.unapply(fileSizeHistogram);
    }

    public static FileSizeHistogram apply(IndexedSeq<Object> indexedSeq, long[] lArray, long[] lArray2) {
        return FileSizeHistogram$.MODULE$.apply(indexedSeq, lArray, lArray2);
    }

    public static StructType schema() {
        return FileSizeHistogram$.MODULE$.schema();
    }

    public static FileSizeHistogram apply(IndexedSeq<Object> indexedSeq) {
        return FileSizeHistogram$.MODULE$.apply(indexedSeq);
    }

    public static int getBinIndex(long l, IndexedSeq<Object> indexedSeq) {
        return FileSizeHistogram$.MODULE$.getBinIndex(l, indexedSeq);
    }

    public IndexedSeq<Object> sortedBinBoundaries() {
        return this.sortedBinBoundaries;
    }

    public long[] fileCounts() {
        return this.fileCounts;
    }

    public long[] totalBytes() {
        return this.totalBytes;
    }

    public int hashCode() {
        return Arrays.hashCode(this.totalBytes());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        Object object = that;
        if (!(object instanceof FileSizeHistogram)) return false;
        FileSizeHistogram fileSizeHistogram = (FileSizeHistogram)object;
        IndexedSeq<Object> thatSB = fileSizeHistogram.sortedBinBoundaries();
        long[] thatFC = fileSizeHistogram.fileCounts();
        long[] thatTB = fileSizeHistogram.totalBytes();
        IndexedSeq<Object> indexedSeq = this.sortedBinBoundaries();
        IndexedSeq<Object> indexedSeq2 = thatSB;
        if (indexedSeq == null) {
            if (indexedSeq2 != null) {
                return false;
            }
        } else if (!indexedSeq.equals(indexedSeq2)) return false;
        if (!Arrays.equals(this.fileCounts(), thatFC)) return false;
        if (!Arrays.equals(this.totalBytes(), thatTB)) return false;
        return true;
    }

    public void insert(long fileSize) {
        block0: {
            int index = FileSizeHistogram$.MODULE$.getBinIndex(fileSize, this.sortedBinBoundaries());
            if (index < 0) break block0;
            this.fileCounts()[index] = this.fileCounts()[index] + 1L;
            this.totalBytes()[index] = this.totalBytes()[index] + fileSize;
        }
    }

    public void remove(long fileSize) {
        block0: {
            int index = FileSizeHistogram$.MODULE$.getBinIndex(fileSize, this.sortedBinBoundaries());
            if (index < 0) break block0;
            this.fileCounts()[index] = this.fileCounts()[index] - 1L;
            this.totalBytes()[index] = this.totalBytes()[index] - fileSize;
        }
    }

    public FileSizeHistogram copy(IndexedSeq<Object> sortedBinBoundaries, long[] fileCounts, long[] totalBytes) {
        return new FileSizeHistogram(sortedBinBoundaries, fileCounts, totalBytes);
    }

    public IndexedSeq<Object> copy$default$1() {
        return this.sortedBinBoundaries();
    }

    public long[] copy$default$2() {
        return this.fileCounts();
    }

    public long[] copy$default$3() {
        return this.totalBytes();
    }

    public String productPrefix() {
        return "FileSizeHistogram";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.sortedBinBoundaries();
                break;
            }
            case 1: {
                object = this.fileCounts();
                break;
            }
            case 2: {
                object = this.totalBytes();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FileSizeHistogram;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public FileSizeHistogram(@JsonDeserialize(contentAs=Long.class) IndexedSeq<Object> sortedBinBoundaries, long[] fileCounts, long[] totalBytes) {
        this.sortedBinBoundaries = sortedBinBoundaries;
        this.fileCounts = fileCounts;
        this.totalBytes = totalBytes;
        Product.$init$((Product)this);
        Predef$.MODULE$.require(sortedBinBoundaries.nonEmpty());
        Predef$.MODULE$.require(BoxesRunTime.unboxToLong((Object)sortedBinBoundaries.head()) == 0L, (Function0 & java.io.Serializable & Serializable)() -> "The first bin should start from 0");
        Predef$.MODULE$.require(sortedBinBoundaries.length() == fileCounts.length, (Function0 & java.io.Serializable & Serializable)() -> "number of binBoundaries should be same as size of fileCounts");
        Predef$.MODULE$.require(sortedBinBoundaries.length() == totalBytes.length, (Function0 & java.io.Serializable & Serializable)() -> "number of binBoundaries should be same as size of totalBytes");
    }
}

