/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.constraints;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.constraints.CharVarcharConstraint$;
import org.apache.spark.sql.delta.constraints.Constraint;
import org.apache.spark.sql.delta.constraints.Constraints;
import org.apache.spark.sql.delta.constraints.Invariants$;
import org.apache.spark.sql.delta.schema.SchemaUtils$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class Constraints$ {
    public static Constraints$ MODULE$;

    static {
        new Constraints$();
    }

    public Seq<Constraint> getCheckConstraints(Metadata metadata, SparkSession spark) {
        return ((TraversableOnce)metadata.configuration().collect((PartialFunction)new scala.Serializable(spark){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    String key = (String)A1._1();
                    String constraintText = (String)A1._2();
                    if (key.toLowerCase(Locale.ROOT).startsWith("delta.constraints.")) {
                        String name = new StringOps(Predef$.MODULE$.augmentString(key)).stripPrefix("delta.constraints.");
                        Expression expression = this.spark$1.sessionState().sqlParser().parseExpression(constraintText);
                        object = new Constraints.Check(name, expression);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<String, String> x1) {
                String key;
                Tuple2<String, String> tuple2 = x1;
                boolean bl = tuple2 != null && (key = (String)tuple2._1()).toLowerCase(Locale.ROOT).startsWith("delta.constraints.");
                return bl;
            }
            {
                this.spark$1 = spark$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    public Seq<Constraint> getAll(Metadata metadata, SparkSession spark) {
        Seq<Constraint> checkConstraints = this.getCheckConstraints(metadata, spark);
        Seq<Constraint> constraintsFromSchema = Invariants$.MODULE$.getFromSchema(metadata.schema(), spark);
        Seq<Constraint> charVarcharLengthChecks = spark.sessionState().conf().charVarcharAsString() ? Nil$.MODULE$ : CharVarcharConstraint$.MODULE$.stringConstraints(metadata.schema());
        return ((SeqLike)((TraversableLike)checkConstraints.$plus$plus(constraintsFromSchema, Seq$.MODULE$.canBuildFrom())).$plus$plus(charVarcharLengthChecks, Seq$.MODULE$.canBuildFrom())).toSeq();
    }

    public Option<String> getExprTextByName(String name, Metadata metadata, SparkSession spark) {
        return metadata.configuration().get((Object)this.checkConstraintPropertyName(name));
    }

    public String checkConstraintPropertyName(String constraintName) {
        return new StringBuilder(18).append("delta.constraints.").append(constraintName.toLowerCase(Locale.ROOT)).toString();
    }

    public Map<String, String> findDependentConstraints(SparkSession sparkSession, Seq<String> columnName, Metadata metadata) {
        return (Map)metadata.configuration().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Constraints$.$anonfun$findDependentConstraints$1(sparkSession, columnName, x0$1)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$findDependentConstraints$1(SparkSession sparkSession$1, Seq columnName$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) return false;
        String key = (String)tuple2._1();
        String constraint = (String)tuple2._2();
        if (!key.toLowerCase(Locale.ROOT).startsWith("delta.constraints.")) return false;
        return SchemaUtils$.MODULE$.containsDependentExpression(sparkSession$1, (Seq<String>)columnName$1, constraint, (Function2<String, String, Object>)sparkSession$1.sessionState().conf().resolver());
    }

    private Constraints$() {
        MODULE$ = this;
    }
}

