/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.actions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddCDCFile;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.AddFile$;
import org.apache.spark.sql.delta.actions.AddFile$ParsedStatsFields$;
import org.apache.spark.sql.delta.actions.AddFile$Tags$INSERTION_TIME$;
import org.apache.spark.sql.delta.actions.CommitInfo;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor;
import org.apache.spark.sql.delta.actions.FileAction;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.actions.SetTransaction;
import org.apache.spark.sql.delta.actions.SingleAction;
import org.apache.spark.sql.delta.actions.SingleAction$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple8;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r]g!\u0002:t\u0001\u0006\u0005\u0001BCA\u0012\u0001\tU\r\u0011\"\u0011\u0002&!Q\u0011Q\b\u0001\u0003\u0012\u0003\u0006I!a\n\t\u0015\u0005}\u0002A!f\u0001\n\u0003\t\t\u0005\u0003\u0006\u0002J\u0001\u0011\t\u0012)A\u0005\u0003\u0007B!\"a\u0013\u0001\u0005+\u0007I\u0011AA'\u0011)\t)\u0006\u0001B\tB\u0003%\u0011q\n\u0005\u000b\u0003/\u0002!Q3A\u0005\u0002\u00055\u0003BCA-\u0001\tE\t\u0015!\u0003\u0002P!Q\u00111\f\u0001\u0003\u0016\u0004%\t%!\u0018\t\u0015\u0005\u0015\u0004A!E!\u0002\u0013\ty\u0006\u0003\u0006\u0002h\u0001\u0011)\u001a!C\u0001\u0003KA!\"!\u001b\u0001\u0005#\u0005\u000b\u0011BA\u0014\u0011)\tY\u0007\u0001BK\u0002\u0013\u0005\u0013\u0011\t\u0005\u000b\u0003[\u0002!\u0011#Q\u0001\n\u0005\r\u0003BCA8\u0001\tU\r\u0011\"\u0001\u0002r!Q\u0011\u0011\u0010\u0001\u0003\u0012\u0003\u0006I!a\u001d\t\u000f\u0005m\u0004\u0001\"\u0001\u0002~!9\u00111\u0018\u0001\u0005B\u0005u\u0006bBAc\u0001\u0011\u0005\u0011q\u0019\u0005\b\u0003\u001f\u0004A\u0011AAi\u0011%\tI\u000eAI\u0001\n\u0003\tY\u000eC\u0005\u0002p\u0002\t\n\u0011\"\u0001\u0002r\"9\u0011Q\u001f\u0001\u0005\u0002\u0005]\b\"\u0003B\u0002\u0001E\u0005I\u0011AAy\u0011\u001d\u0011)\u0001\u0001C\u0001\u0005\u000fA!Ba\u0006\u0001\u0011\u000b\u0007I\u0011AA'\u0011\u001d\u0011Y\u0002\u0001C\u0001\u0005;AqAa9\u0001\t\u0003\u0011)\u000fC\u0004\u0003l\u0002!\tA!<\t\u000f\tE\b\u0001\"\u0011\u0002N\u00191!Q\u001f\u0001E\u0005oD!B!? \u0005+\u0007I\u0011\u0001B~\u0011)\u0011yp\bB\tB\u0003%!Q \u0005\b\u0003wzB\u0011AB\u0001\u0011%\u0019IaHA\u0001\n\u0003\u0019Y\u0001C\u0005\u0004\u0010}\t\n\u0011\"\u0001\u0004\u0012!I1QC\u0010\u0002\u0002\u0013\u00053q\u0003\u0005\n\u0007;y\u0012\u0011!C\u0001\u0007?A\u0011ba\n \u0003\u0003%\ta!\u000b\t\u0013\rUr$!A\u0005B\r]\u0002\"CB#?\u0005\u0005I\u0011AB$\u0011%\u0019YeHA\u0001\n\u0003\u001ai\u0005C\u0005\u0004P}\t\t\u0011\"\u0011\u0004R!I11K\u0010\u0002\u0002\u0013\u00053QK\u0004\n\u00073\u0002\u0011\u0011!E\u0005\u000772\u0011B!>\u0001\u0003\u0003EIa!\u0018\t\u000f\u0005md\u0006\"\u0001\u0004l!I1q\n\u0018\u0002\u0002\u0013\u00153\u0011\u000b\u0005\n\u0005's\u0013\u0011!CA\u0007[B\u0011B!//\u0003\u0003%\ti!\u001d\t\u000f\r]\u0004\u0001\"\u0011\u0002&!Q1\u0011\u0010\u0001\t\u0006\u0004%Iaa\u001f\t\u0015\te\b\u0001#b\u0001\n\u0003\u0012Y\u0010C\u0004\u0004\u000e\u0002!\t!!\u0014\t\u000f\rE\u0005\u0001\"\u0001\u0003|\"91Q\u0013\u0001\u0005\u0002\tm\bbBBM\u0001\u0011\u000511\u0014\u0005\b\u0007O\u0003A\u0011ABN\u0011%\u0019I\u0001AA\u0001\n\u0003\u0019Y\u000bC\u0005\u0004\u0010\u0001\t\n\u0011\"\u0001\u0003*\"I1Q\u0018\u0001\u0012\u0002\u0013\u0005!q\u0016\u0005\n\u0007\u007f\u0003\u0011\u0013!C\u0001\u00037D\u0011b!1\u0001#\u0003%\t!a7\t\u0013\r\r\u0007!%A\u0005\u0002\u0005E\b\"CBc\u0001E\u0005I\u0011\u0001BU\u0011%\u00199\rAI\u0001\n\u0003\u0011y\u000bC\u0005\u0004J\u0002\t\n\u0011\"\u0001\u00036\"I1Q\u0003\u0001\u0002\u0002\u0013\u00053q\u0003\u0005\n\u0007;\u0001\u0011\u0011!C\u0001\u0007?A\u0011ba\n\u0001\u0003\u0003%\taa3\t\u0013\rU\u0002!!A\u0005B\r]\u0002\"CB#\u0001\u0005\u0005I\u0011ABh\u0011%\u0019Y\u0005AA\u0001\n\u0003\u001ai\u0005C\u0005\u0004P\u0001\t\t\u0011\"\u0011\u0004R!I11\u000b\u0001\u0002\u0002\u0013\u000531[\u0004\b\u0005O\u0019\b\u0012\u0001B\u0015\r\u0019\u00118\u000f#\u0001\u0003,!9\u00111P'\u0005\u0002\t5ra\u0002B\u0018\u001b\"\u0005!\u0011\u0007\u0004\b\u0005ki\u0005\u0012\u0001B\u001c\u0011\u001d\tY\b\u0015C\u0001\u0005s1qAa\u000fQ\u0003C\u0011i\u0004\u0003\u0006\u0003@I\u0013)\u0019!C\u0001\u0003KA!B!\u0011S\u0005\u0003\u0005\u000b\u0011BA\u0014\u0011\u001d\tYH\u0015C\u0001\u0005\u0007:qA! Q\u0011\u0003\u0011YGB\u0004\u0003fAC\tAa\u001a\t\u000f\u0005mt\u000b\"\u0001\u0003j\u001d9!q\u0010)\t\u0002\tMda\u0002B7!\"\u0005!q\u000e\u0005\b\u0003wRF\u0011\u0001B9\u000f\u001d\u0011\t\t\u0015E\u0001\u0005w2qA!\u001eQ\u0011\u0003\u00119\bC\u0004\u0002|u#\tA!\u001f\b\u000f\t\r\u0005\u000b#\u0001\u0003T\u00199!Q\n)\t\u0002\t=\u0003bBA>A\u0012\u0005!\u0011K\u0004\b\u0005\u000b\u0003\u0006\u0012\u0001B2\r\u001d\u0011i\u0006\u0015E\u0001\u0005?Bq!a\u001fd\t\u0003\u0011\tgB\u0004\u0003\bBC\tAa\u0017\u0007\u000f\tU\u0003\u000b#\u0001\u0003X!9\u00111\u00104\u0005\u0002\te\u0003b\u0002B\u000e\u001b\u0012\u0005!\u0011\u0012\u0005\n\u0005'k\u0015\u0011!CA\u0005+C\u0011Ba*N#\u0003%\tA!+\t\u0013\t5V*%A\u0005\u0002\t=\u0006\"\u0003BZ\u001bF\u0005I\u0011\u0001B[\u0011%\u0011I,TA\u0001\n\u0003\u0013Y\fC\u0005\u0003J6\u000b\n\u0011\"\u0001\u0003*\"I!1Z'\u0012\u0002\u0013\u0005!q\u0016\u0005\n\u0005\u001bl\u0015\u0013!C\u0001\u0005kC\u0011Ba4N\u0003\u0003%IA!5\u0003\u000f\u0005#GMR5mK*\u0011A/^\u0001\bC\u000e$\u0018n\u001c8t\u0015\t1x/A\u0003eK2$\u0018M\u0003\u0002ys\u0006\u00191/\u001d7\u000b\u0005i\\\u0018!B:qCJ\\'B\u0001?~\u0003\u0019\t\u0007/Y2iK*\ta0A\u0002pe\u001e\u001c\u0001aE\u0005\u0001\u0003\u0007\ty!a\u0006\u0002\u001eA!\u0011QAA\u0006\u001b\t\t9A\u0003\u0002\u0002\n\u0005)1oY1mC&!\u0011QBA\u0004\u0005\u0019\te.\u001f*fMB!\u0011\u0011CA\n\u001b\u0005\u0019\u0018bAA\u000bg\nQa)\u001b7f\u0003\u000e$\u0018n\u001c8\u0011\t\u0005\u0015\u0011\u0011D\u0005\u0005\u00037\t9AA\u0004Qe>$Wo\u0019;\u0011\t\u0005\u0015\u0011qD\u0005\u0005\u0003C\t9A\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0003qCRDWCAA\u0014!\u0011\tI#a\u000e\u000f\t\u0005-\u00121\u0007\t\u0005\u0003[\t9!\u0004\u0002\u00020)\u0019\u0011\u0011G@\u0002\rq\u0012xn\u001c;?\u0013\u0011\t)$a\u0002\u0002\rA\u0013X\rZ3g\u0013\u0011\tI$a\u000f\u0003\rM#(/\u001b8h\u0015\u0011\t)$a\u0002\u0002\u000bA\fG\u000f\u001b\u0011\u0002\u001fA\f'\u000f^5uS>tg+\u00197vKN,\"!a\u0011\u0011\u0011\u0005%\u0012QIA\u0014\u0003OIA!a\u0012\u0002<\t\u0019Q*\u00199\u0002!A\f'\u000f^5uS>tg+\u00197vKN\u0004\u0013\u0001B:ju\u0016,\"!a\u0014\u0011\t\u0005\u0015\u0011\u0011K\u0005\u0005\u0003'\n9A\u0001\u0003M_:<\u0017!B:ju\u0016\u0004\u0013\u0001E7pI&4\u0017nY1uS>tG+[7f\u0003Eiw\u000eZ5gS\u000e\fG/[8o)&lW\rI\u0001\u000bI\u0006$\u0018m\u00115b]\u001e,WCAA0!\u0011\t)!!\u0019\n\t\u0005\r\u0014q\u0001\u0002\b\u0005>|G.Z1o\u0003-!\u0017\r^1DQ\u0006tw-\u001a\u0011\u0002\u000bM$\u0018\r^:\u0002\rM$\u0018\r^:!\u0003\u0011!\u0018mZ:\u0002\u000bQ\fwm\u001d\u0011\u0002\u001d\u0011,G.\u001a;j_:4Vm\u0019;peV\u0011\u00111\u000f\t\u0005\u0003#\t)(C\u0002\u0002xM\u0014\u0001\u0004R3mKRLwN\u001c,fGR|'\u000fR3tGJL\u0007\u000f^8s\u0003=!W\r\\3uS>tg+Z2u_J\u0004\u0013A\u0002\u001fj]&$h\b\u0006\n\u0002\u0000\u0005\u0005\u00151QAX\u0003c\u000b\u0019,!.\u00028\u0006e\u0006cAA\t\u0001!9\u00111E\tA\u0002\u0005\u001d\u0002bBA #\u0001\u0007\u00111\t\u0015\t\u0003\u0007\u000b9)a(\u0002\"B!\u0011\u0011RAN\u001b\t\tYI\u0003\u0003\u0002\u000e\u0006=\u0015AC1o]>$\u0018\r^5p]*!\u0011\u0011SAJ\u0003\u001dQ\u0017mY6t_:TA!!&\u0002\u0018\u0006Ia-Y:uKJDX\u000e\u001c\u0006\u0003\u00033\u000b1aY8n\u0013\u0011\ti*a#\u0003\u0017)\u001bxN\\%oG2,H-Z\u0001\u0006m\u0006dW/\u001a\u0013\u0003\u0003GKA!!*\u0002(\u00061\u0011\tT,B3NSA!!+\u0002,\u00069\u0011J\\2mk\u0012,'\u0002BAW\u0003\u0017\u000b1BS:p]&s7\r\\;eK\"9\u00111J\tA\u0002\u0005=\u0003bBA,#\u0001\u0007\u0011q\n\u0005\b\u00037\n\u0002\u0019AA0\u0011%\t9'\u0005I\u0001\u0002\u0004\t9\u0003C\u0005\u0002lE\u0001\n\u00111\u0001\u0002D!I\u0011qN\t\u0011\u0002\u0003\u0007\u00111O\u0001\u0005oJ\f\u0007/\u0006\u0002\u0002@B!\u0011\u0011CAa\u0013\r\t\u0019m\u001d\u0002\r'&tw\r\\3BGRLwN\\\u0001\u0007e\u0016lwN^3\u0016\u0005\u0005%\u0007\u0003BA\t\u0003\u0017L1!!4t\u0005)\u0011V-\\8wK\u001aKG.Z\u0001\u0014e\u0016lwN^3XSRDG+[7fgR\fW\u000e\u001d\u000b\u0007\u0003\u0013\f\u0019.a6\t\u0013\u0005UG\u0003%AA\u0002\u0005=\u0013!\u0003;j[\u0016\u001cH/Y7q\u0011%\tY\u0006\u0006I\u0001\u0002\u0004\ty&A\u000fsK6|g/Z,ji\"$\u0016.\\3ti\u0006l\u0007\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\tiN\u000b\u0003\u0002P\u0005}7FAAq!\u0011\t\u0019/a;\u000e\u0005\u0005\u0015(\u0002BAt\u0003S\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\t\u00055\u0015qA\u0005\u0005\u0003[\f)OA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQD]3n_Z,w+\u001b;i)&lWm\u001d;b[B$C-\u001a4bk2$HEM\u000b\u0003\u0003gTC!a\u0018\u0002`\u0006Q!/Z7pm\u0016\u0014vn^:\u0015\r\u0005e\u0018q B\u0001!!\t)!a?\u0002\u0000\u0005%\u0017\u0002BA\u007f\u0003\u000f\u0011a\u0001V;qY\u0016\u0014\u0004bBA8/\u0001\u0007\u00111\u000f\u0005\n\u00037:\u0002\u0013!a\u0001\u0003?\nAC]3n_Z,'k\\<tI\u0011,g-Y;mi\u0012\u0012\u0014!G4fi\u0012+G.\u001a;j_:4Vm\u0019;peVs\u0017.];f\u0013\u0012,\"A!\u0003\u0011\r\u0005\u0015!1BA\u0014\u0013\u0011\u0011i!a\u0002\u0003\r=\u0003H/[8oQ\rI\"\u0011\u0003\t\u0005\u0003\u0013\u0013\u0019\"\u0003\u0003\u0003\u0016\u0005-%A\u0003&t_:LuM\\8sK\u0006i\u0011N\\:feRLwN\u001c+j[\u0016D3A\u0007B\t\u0003\r!\u0018m\u001a\u000b\u0005\u0005\u0013\u0011y\u0002C\u0004\u0003\u001cm\u0001\rA!\t\u0011\u0007\t\r\"KD\u0002\u0003&=s1!!\u0005M\u0003\u001d\tE\r\u001a$jY\u0016\u00042!!\u0005N'\u0015i\u00151AA\u000f)\t\u0011I#\u0001\u0003UC\u001e\u001c\bc\u0001B\u001a!6\tQJ\u0001\u0003UC\u001e\u001c8c\u0001)\u0002\u0004Q\u0011!\u0011\u0007\u0002\b\u0017\u0016LH+\u001f9f'\r\u0011\u00161A\u0001\u0005]\u0006lW-A\u0003oC6,\u0007\u0005\u0006\u0003\u0003F\t%\u0003c\u0001B$%6\t\u0001\u000bC\u0004\u0003@U\u0003\r!a\n*\u000fI\u0003gmY,[;\nq\u0011JT*F%RKuJT0U\u00136+5c\u00011\u0003\"Q\u0011!1\u000b\t\u0004\u0005\u000f\u0002'\u0001F(Q)&k\u0015JW#`)\u0006\u0013v)\u0012+`'&SViE\u0002g\u0005C!\"Aa\u0017\u0011\u0007\t\u001dcM\u0001\u0007Q\u0003J#\u0016\nV%P\u001d~KEiE\u0002d\u0005C!\"Aa\u0019\u0011\u0007\t\u001d3M\u0001\u0005[\u0007V\u0013UiX%E'\r9&\u0011\u0005\u000b\u0003\u0005W\u00022Aa\u0012X\u0005=Q6)\u0016\"F?j{%\u000bR#S?\nK6c\u0001.\u0003\"Q\u0011!1\u000f\t\u0004\u0005\u000fR&A\u0005.D+\n+uLW(S\t\u0016\u0013vlQ+S-\u0016\u001b2!\u0018B\u0011)\t\u0011Y\bE\u0002\u0003Hu\u000b\u0001BW\"V\u0005\u0016{\u0016\nR\u0001\u00105\u000e+&)R0[\u001fJ#UIU0C3\u0006\u0011\"lQ+C\u000b~SvJ\u0015#F%~\u001bUK\u0015,F\u00039IejU#S)&{ej\u0018+J\u001b\u0016\u000bA\u0002U!S)&#\u0016j\u0014(`\u0013\u0012\u000bAc\u0014)U\u00136K%,R0U\u0003J;U\tV0T\u0013j+E\u0003BA\u0014\u0005\u0017CqA!$i\u0001\u0004\u0011y)\u0001\u0004uC\u001e\\U-\u001f\t\u0004\u0005#\u0013fb\u0001B\u001a\u001f\u0006)\u0011\r\u001d9msR\u0011\u0012q\u0010BL\u00053\u0013YJ!(\u0003 \n\u0005&1\u0015BS\u0011\u001d\t\u0019#\u001ba\u0001\u0003OAq!a\u0010j\u0001\u0004\t\u0019\u0005C\u0004\u0002L%\u0004\r!a\u0014\t\u000f\u0005]\u0013\u000e1\u0001\u0002P!9\u00111L5A\u0002\u0005}\u0003\"CA4SB\u0005\t\u0019AA\u0014\u0011%\tY'\u001bI\u0001\u0002\u0004\t\u0019\u0005C\u0005\u0002p%\u0004\n\u00111\u0001\u0002t\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$c'\u0006\u0002\u0003,*\"\u0011qEAp\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012:TC\u0001BYU\u0011\t\u0019%a8\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIa*\"Aa.+\t\u0005M\u0014q\\\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011iL!2\u0011\r\u0005\u0015!1\u0002B`!Q\t)A!1\u0002(\u0005\r\u0013qJA(\u0003?\n9#a\u0011\u0002t%!!1YA\u0004\u0005\u0019!V\u000f\u001d7fq!I!qY7\u0002\u0002\u0003\u0007\u0011qP\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$c'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeN\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001d\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005'\u0004BA!6\u0003`6\u0011!q\u001b\u0006\u0005\u00053\u0014Y.\u0001\u0003mC:<'B\u0001Bo\u0003\u0011Q\u0017M^1\n\t\t\u0005(q\u001b\u0002\u0007\u001f\nTWm\u0019;\u0002\u0017\r|\u0007/_,ji\"$\u0016m\u001a\u000b\u0007\u0003\u007f\u00129O!;\t\u000f\tmA\u00041\u0001\u0003\"!9\u0011q\u0014\u000fA\u0002\u0005\u001d\u0012AD2paf<\u0016\u000e\u001e5pkR$\u0016m\u001a\u000b\u0005\u0003\u007f\u0012y\u000fC\u0004\u0003\u001cu\u0001\rA!\t\u0002\u0017\u001d,GOR5mKNK'0\u001a\u0015\u0004=\tE!!\u0005)beN,Gm\u0015;biN4\u0015.\u001a7egN9q$a\u0001\u0002\u0018\u0005u\u0011!\u00058v[2{w-[2bYJ+7m\u001c:egV\u0011!Q \t\u0007\u0003\u000b\u0011Y!a\u0014\u0002%9,X\u000eT8hS\u000e\fGNU3d_J$7\u000f\t\u000b\u0005\u0007\u0007\u00199\u0001E\u0002\u0004\u0006}i\u0011\u0001\u0001\u0005\b\u0005s\u0014\u0003\u0019\u0001B\u007f\u0003\u0011\u0019w\u000e]=\u0015\t\r\r1Q\u0002\u0005\n\u0005s\u001c\u0003\u0013!a\u0001\u0005{\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004\u0014)\"!Q`Ap\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u00111\u0011\u0004\t\u0005\u0005+\u001cY\"\u0003\u0003\u0002:\t]\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAB\u0011!\u0011\t)aa\t\n\t\r\u0015\u0012q\u0001\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0007W\u0019\t\u0004\u0005\u0003\u0002\u0006\r5\u0012\u0002BB\u0018\u0003\u000f\u00111!\u00118z\u0011%\u0019\u0019dJA\u0001\u0002\u0004\u0019\t#A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0007s\u0001baa\u000f\u0004B\r-RBAB\u001f\u0015\u0011\u0019y$a\u0002\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0004D\ru\"\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\u0018\u0004J!I11G\u0015\u0002\u0002\u0003\u000711F\u0001\tQ\u0006\u001c\bnQ8eKR\u00111\u0011E\u0001\ti>\u001cFO]5oOR\u00111\u0011D\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005}3q\u000b\u0005\n\u0007ga\u0013\u0011!a\u0001\u0007W\t\u0011\u0003U1sg\u0016$7\u000b^1ug\u001aKW\r\u001c3t!\r\u0019)AL\n\u0006]\r}\u0013Q\u0004\t\t\u0007C\u001a9G!@\u0004\u00045\u001111\r\u0006\u0005\u0007K\n9!A\u0004sk:$\u0018.\\3\n\t\r%41\r\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\fDCAB.)\u0011\u0019\u0019aa\u001c\t\u000f\te\u0018\u00071\u0001\u0003~R!11OB;!\u0019\t)Aa\u0003\u0003~\"I!q\u0019\u001a\u0002\u0002\u0003\u000711A\u0001\u0005UN|g.A\tqCJ\u001cX\rZ*uCR\u001ch)[3mIN,\"a! \u0011\r\u0005\u0015!1BB\u0002Q\r!4\u0011\u0011\t\u0005\u0003\u000b\u0019\u0019)\u0003\u0003\u0004\u0006\u0006\u001d!!\u0003;sC:\u001c\u0018.\u001a8uQ\r!$\u0011\u0003\u0015\u0004k\r\u0005\u0005fA\u001b\u0003\u0012\u0005\tb.^7EK2,G/\u001a3SK\u000e|'\u000fZ:)\u0007Y\u0012\t\"\u0001\nok6\u0004\u0006._:jG\u0006d'+Z2pe\u0012\u001c\bfA\u001c\u0003\u0012\u0005\u0011Rm\u001d;M_\u001eL7-\u00197GS2,7+\u001b>fQ\rA$\u0011C\u0001\u001eY><\u0017nY1m)>\u0004\u0006._:jG\u0006d'+Z2pe\u0012\u001c(+\u0019;j_V\u00111Q\u0014\t\u0007\u0003\u000b\u0011Yaa(\u0011\t\u0005\u00151\u0011U\u0005\u0005\u0007G\u000b9A\u0001\u0004E_V\u0014G.\u001a\u0015\u0004s\tE\u0011!\b3fY\u0016$X\r\u001a+p!\"L8/[2bYJ+7m\u001c:egJ\u000bG/[8)\u0007i\u0012\t\u0002\u0006\n\u0002\u0000\r56qVBY\u0007g\u001b)la.\u0004:\u000em\u0006\"CA\u0012wA\u0005\t\u0019AA\u0014\u0011%\tyd\u000fI\u0001\u0002\u0004\t\u0019\u0005C\u0005\u0002Lm\u0002\n\u00111\u0001\u0002P!I\u0011qK\u001e\u0011\u0002\u0003\u0007\u0011q\n\u0005\n\u00037Z\u0004\u0013!a\u0001\u0003?B\u0011\"a\u001a<!\u0003\u0005\r!a\n\t\u0013\u0005-4\b%AA\u0002\u0005\r\u0003\"CA8wA\u0005\t\u0019AA:\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%k\u0005q1m\u001c9zI\u0011,g-Y;mi\u00122\u0014AD2paf$C-\u001a4bk2$HeN\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00139)\u0011\u0019Yc!4\t\u0013\rMb)!AA\u0002\r\u0005B\u0003BA0\u0007#D\u0011ba\rI\u0003\u0003\u0005\raa\u000b\u0015\t\u0005}3Q\u001b\u0005\n\u0007gY\u0015\u0011!a\u0001\u0007W\u0001")
public class AddFile
implements FileAction,
Product,
scala.Serializable {
    @JsonIgnore
    private long insertionTime;
    private volatile AddFile$ParsedStatsFields$ ParsedStatsFields$module;
    @JsonIgnore
    private transient Option<ParsedStatsFields> parsedStatsFields;
    @JsonIgnore
    private transient Option<Object> numLogicalRecords;
    private final String path;
    private final Map<String, String> partitionValues;
    private final long size;
    private final long modificationTime;
    private final boolean dataChange;
    private final String stats;
    private final Map<String, String> tags;
    private final DeletionVectorDescriptor deletionVector;
    @JsonIgnore
    private URI pathAsUri;
    private volatile byte bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static DeletionVectorDescriptor $lessinit$greater$default$8() {
        return AddFile$.MODULE$.$lessinit$greater$default$8();
    }

    public static Map<String, String> $lessinit$greater$default$7() {
        return AddFile$.MODULE$.$lessinit$greater$default$7();
    }

    public static String $lessinit$greater$default$6() {
        return AddFile$.MODULE$.$lessinit$greater$default$6();
    }

    public static Option<Tuple8<String, Map<String, String>, Object, Object, Object, String, Map<String, String>, DeletionVectorDescriptor>> unapply(AddFile addFile) {
        return AddFile$.MODULE$.unapply(addFile);
    }

    public static DeletionVectorDescriptor apply$default$8() {
        return AddFile$.MODULE$.apply$default$8();
    }

    public static Map<String, String> apply$default$7() {
        return AddFile$.MODULE$.apply$default$7();
    }

    public static String apply$default$6() {
        return AddFile$.MODULE$.apply$default$6();
    }

    public static AddFile apply(String string, Map<String, String> map, long l, long l2, boolean bl, String string2, Map<String, String> map2, DeletionVectorDescriptor deletionVectorDescriptor) {
        return AddFile$.MODULE$.apply(string, map, l, l2, bl, string2, map2, deletionVectorDescriptor);
    }

    @Override
    @JsonIgnore
    public Option<String> getTag(String tagName) {
        return FileAction.getTag$(this, tagName);
    }

    private AddFile$ParsedStatsFields$ ParsedStatsFields() {
        if (this.ParsedStatsFields$module == null) {
            this.ParsedStatsFields$lzycompute$1();
        }
        return this.ParsedStatsFields$module;
    }

    private URI pathAsUri$lzycompute() {
        AddFile addFile = this;
        synchronized (addFile) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.pathAsUri = FileAction.pathAsUri$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.pathAsUri;
    }

    @Override
    public URI pathAsUri() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.pathAsUri$lzycompute() : this.pathAsUri;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public Map<String, String> partitionValues() {
        return this.partitionValues;
    }

    public long size() {
        return this.size;
    }

    public long modificationTime() {
        return this.modificationTime;
    }

    @Override
    public boolean dataChange() {
        return this.dataChange;
    }

    public String stats() {
        return this.stats;
    }

    @Override
    public Map<String, String> tags() {
        return this.tags;
    }

    public DeletionVectorDescriptor deletionVector() {
        return this.deletionVector;
    }

    @Override
    public SingleAction wrap() {
        AddFile x$1 = this;
        SetTransaction x$2 = SingleAction$.MODULE$.apply$default$1();
        RemoveFile x$3 = SingleAction$.MODULE$.apply$default$3();
        Metadata x$4 = SingleAction$.MODULE$.apply$default$4();
        Protocol x$5 = SingleAction$.MODULE$.apply$default$5();
        AddCDCFile x$6 = SingleAction$.MODULE$.apply$default$6();
        CommitInfo x$7 = SingleAction$.MODULE$.apply$default$7();
        return new SingleAction(x$2, x$1, x$3, x$4, x$5, x$6, x$7);
    }

    public RemoveFile remove() {
        return this.removeWithTimestamp(this.removeWithTimestamp$default$1(), this.removeWithTimestamp$default$2());
    }

    public RemoveFile removeWithTimestamp(long timestamp, boolean dataChange) {
        Map<String, String> newTags = this.tags();
        RemoveFile removedFile = new RemoveFile(this.path(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)timestamp)), dataChange, (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)), this.partitionValues(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.size())), newTags, this.deletionVector());
        removedFile.numLogicalRecords_$eq(this.numLogicalRecords());
        return removedFile;
    }

    public long removeWithTimestamp$default$1() {
        return System.currentTimeMillis();
    }

    public boolean removeWithTimestamp$default$2() {
        return true;
    }

    public Tuple2<AddFile, RemoveFile> removeRows(DeletionVectorDescriptor deletionVector, boolean dataChange) {
        AddFile withUpdatedDV;
        DeletionVectorDescriptor dvDescriptorWithoutMaxRowIndex;
        DeletionVectorDescriptor deletionVectorDescriptor;
        Tuple2 tuple2 = new Tuple2(this.numPhysicalRecords(), deletionVector.maxRowIndex());
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some;
                long maxRowIndex;
                Some some2 = (Some)option;
                long numPhysicalRecords = BoxesRunTime.unboxToLong((Object)some2.value());
                if (option2 instanceof Some && (maxRowIndex = BoxesRunTime.unboxToLong((Object)(some = (Some)option2).value())) + 1L > numPhysicalRecords) {
                    throw DeltaErrors$.MODULE$.deletionVectorInvalidRowIndex();
                }
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        Option<Object> option = deletionVector.maxRowIndex();
        if (option instanceof Some) {
            None$ x$1 = None$.MODULE$;
            String x$2 = deletionVector.copy$default$1();
            String x$3 = deletionVector.copy$default$2();
            Option<Object> x$4 = deletionVector.copy$default$3();
            int x$5 = deletionVector.copy$default$4();
            long x$6 = deletionVector.copy$default$5();
            deletionVectorDescriptor = deletionVector.copy(x$2, x$3, x$4, x$5, x$6, (Option<Object>)x$1);
        } else {
            deletionVectorDescriptor = deletionVector;
        }
        DeletionVectorDescriptor x$7 = dvDescriptorWithoutMaxRowIndex = deletionVectorDescriptor;
        boolean x$8 = dataChange;
        String x$9 = this.copy$default$1();
        Map<String, String> x$10 = this.copy$default$2();
        long x$11 = this.copy$default$3();
        long x$12 = this.copy$default$4();
        String x$13 = this.copy$default$6();
        Map<String, String> x$14 = this.copy$default$7();
        AddFile addFile = withUpdatedDV = this.copy(x$9, x$10, x$11, x$12, x$8, x$13, x$14, x$7);
        boolean x$15 = dataChange;
        long x$16 = this.removeWithTimestamp$default$1();
        RemoveFile removeFile = this.removeWithTimestamp(x$16, x$15);
        return new Tuple2((Object)addFile, (Object)removeFile);
    }

    public boolean removeRows$default$2() {
        return true;
    }

    @JsonIgnore
    public Option<String> getDeletionVectorUniqueId() {
        return Option$.MODULE$.apply((Object)this.deletionVector()).map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.uniqueId());
    }

    private long insertionTime$lzycompute() {
        AddFile addFile = this;
        synchronized (addFile) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.insertionTime = BoxesRunTime.unboxToLong((Object)this.tag(AddFile$Tags$INSERTION_TIME$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToLong((long)AddFile.$anonfun$insertionTime$1(x$17))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> TimeUnit.MICROSECONDS.convert(this.modificationTime(), TimeUnit.MILLISECONDS)));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.insertionTime;
    }

    public long insertionTime() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.insertionTime$lzycompute() : this.insertionTime;
    }

    public Option<String> tag(Tags.KeyType tag) {
        return this.getTag(tag.name());
    }

    public AddFile copyWithTag(Tags.KeyType tag, String value) {
        Map x$1 = ((Map)Option$.MODULE$.apply(this.tags()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty())).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tag.name()), (Object)value));
        String x$2 = this.copy$default$1();
        Map<String, String> x$3 = this.copy$default$2();
        long x$4 = this.copy$default$3();
        long x$5 = this.copy$default$4();
        boolean x$6 = this.copy$default$5();
        String x$7 = this.copy$default$6();
        DeletionVectorDescriptor x$8 = this.copy$default$8();
        return this.copy(x$2, x$3, x$4, x$5, x$6, x$7, (Map<String, String>)x$1, x$8);
    }

    public AddFile copyWithoutTag(Tags.KeyType tag) {
        AddFile addFile;
        if (this.tags() == null) {
            addFile = this;
        } else {
            Map x$1 = (Map)this.tags().$minus((Object)tag.name());
            String x$2 = this.copy$default$1();
            Map<String, String> x$3 = this.copy$default$2();
            long x$4 = this.copy$default$3();
            long x$5 = this.copy$default$4();
            boolean x$6 = this.copy$default$5();
            String x$7 = this.copy$default$6();
            DeletionVectorDescriptor x$8 = this.copy$default$8();
            addFile = this.copy(x$2, x$3, x$4, x$5, x$6, x$7, (Map<String, String>)x$1, x$8);
        }
        return addFile;
    }

    @Override
    @JsonIgnore
    public long getFileSize() {
        return this.size();
    }

    @Override
    public String json() {
        block0: {
            if (this.deletionVector() == null) break block0;
            Predef$.MODULE$.assert(!this.deletionVector().maxRowIndex().isDefined());
        }
        return Action.json$(this);
    }

    private Option<ParsedStatsFields> parsedStatsFields$lzycompute() {
        AddFile addFile = this;
        synchronized (addFile) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                None$ none$;
                if (this.stats() == null || this.stats().isEmpty()) {
                    none$ = None$.MODULE$;
                } else {
                    JsonNode node = new ObjectMapper().readTree(this.stats());
                    None$ numLogicalRecords = node.has("numRecords") ? new Some((Object)node.get("numRecords")).filterNot((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.isNull())).map((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToLong((long)x$19.asLong())).map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$20 -> x$20 - this.numDeletedRecords()) : None$.MODULE$;
                    none$ = new Some((Object)new ParsedStatsFields(this, (Option<Object>)numLogicalRecords));
                }
                this.parsedStatsFields = none$;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.parsedStatsFields;
    }

    private Option<ParsedStatsFields> parsedStatsFields() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.parsedStatsFields$lzycompute() : this.parsedStatsFields;
    }

    private Option<Object> numLogicalRecords$lzycompute() {
        AddFile addFile = this;
        synchronized (addFile) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.numLogicalRecords = this.parsedStatsFields().flatMap((Function1 & Serializable & scala.Serializable)x$21 -> x$21.numLogicalRecords());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.numLogicalRecords;
    }

    @Override
    public Option<Object> numLogicalRecords() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.numLogicalRecords$lzycompute() : this.numLogicalRecords;
    }

    @JsonIgnore
    public long numDeletedRecords() {
        return this.deletionVector() != null ? this.deletionVector().cardinality() : 0L;
    }

    @JsonIgnore
    public Option<Object> numPhysicalRecords() {
        return this.numLogicalRecords().map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$22 -> x$22 + this.numDeletedRecords());
    }

    @JsonIgnore
    public Option<Object> estLogicalFileSize() {
        return this.logicalToPhysicalRecordsRatio().map((Function1)(JFunction1.mcJD.sp & Serializable & scala.Serializable)n -> (long)(n * (double)this.size()));
    }

    @JsonIgnore
    public Option<Object> logicalToPhysicalRecordsRatio() {
        return this.numLogicalRecords().map((Function1)(JFunction1.mcDJ.sp & Serializable & scala.Serializable)numLogicalRecords -> (double)numLogicalRecords / (double)(numLogicalRecords + this.numDeletedRecords()));
    }

    @JsonIgnore
    public Option<Object> deletedToPhysicalRecordsRatio() {
        return this.logicalToPhysicalRecordsRatio().map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$23 -> 1.0 - x$23);
    }

    public AddFile copy(String path, Map<String, String> partitionValues, long size, long modificationTime, boolean dataChange, String stats, Map<String, String> tags, DeletionVectorDescriptor deletionVector) {
        return new AddFile(path, partitionValues, size, modificationTime, dataChange, stats, tags, deletionVector);
    }

    public String copy$default$1() {
        return this.path();
    }

    public Map<String, String> copy$default$2() {
        return this.partitionValues();
    }

    public long copy$default$3() {
        return this.size();
    }

    public long copy$default$4() {
        return this.modificationTime();
    }

    public boolean copy$default$5() {
        return this.dataChange();
    }

    public String copy$default$6() {
        return this.stats();
    }

    public Map<String, String> copy$default$7() {
        return this.tags();
    }

    public DeletionVectorDescriptor copy$default$8() {
        return this.deletionVector();
    }

    public String productPrefix() {
        return "AddFile";
    }

    public int productArity() {
        return 8;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.path();
                break;
            }
            case 1: {
                object = this.partitionValues();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToLong((long)this.size());
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToLong((long)this.modificationTime());
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToBoolean((boolean)this.dataChange());
                break;
            }
            case 5: {
                object = this.stats();
                break;
            }
            case 6: {
                object = this.tags();
                break;
            }
            case 7: {
                object = this.deletionVector();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AddFile;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.path()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.partitionValues()));
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.size()));
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.modificationTime()));
        n = Statics.mix((int)n, (int)(this.dataChange() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.stats()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.tags()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.deletionVector()));
        return Statics.finalizeHash((int)n, (int)8);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AddFile)) return false;
        boolean bl = true;
        if (!bl) return false;
        AddFile addFile = (AddFile)x$1;
        String string = this.path();
        String string2 = addFile.path();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Map<String, String> map = this.partitionValues();
        Map<String, String> map2 = addFile.partitionValues();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        if (this.size() != addFile.size()) return false;
        if (this.modificationTime() != addFile.modificationTime()) return false;
        if (this.dataChange() != addFile.dataChange()) return false;
        String string3 = this.stats();
        String string4 = addFile.stats();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        Map<String, String> map3 = this.tags();
        Map<String, String> map4 = addFile.tags();
        if (map3 == null) {
            if (map4 != null) {
                return false;
            }
        } else if (!map3.equals(map4)) return false;
        DeletionVectorDescriptor deletionVectorDescriptor = this.deletionVector();
        DeletionVectorDescriptor deletionVectorDescriptor2 = addFile.deletionVector();
        if (deletionVectorDescriptor == null) {
            if (deletionVectorDescriptor2 != null) {
                return false;
            }
        } else if (!((Object)deletionVectorDescriptor).equals(deletionVectorDescriptor2)) return false;
        if (!addFile.canEqual(this)) return false;
        return true;
    }

    private final void ParsedStatsFields$lzycompute$1() {
        AddFile addFile = this;
        synchronized (addFile) {
            if (this.ParsedStatsFields$module == null) {
                this.ParsedStatsFields$module = new AddFile$ParsedStatsFields$(this);
            }
        }
    }

    public static final /* synthetic */ long $anonfun$insertionTime$1(String x$17) {
        return new StringOps(Predef$.MODULE$.augmentString(x$17)).toLong();
    }

    public AddFile(String path, @JsonInclude(value=JsonInclude.Include.ALWAYS) Map<String, String> partitionValues, long size, long modificationTime, boolean dataChange, String stats, Map<String, String> tags, DeletionVectorDescriptor deletionVector) {
        this.path = path;
        this.partitionValues = partitionValues;
        this.size = size;
        this.modificationTime = modificationTime;
        this.dataChange = dataChange;
        this.stats = stats;
        this.tags = tags;
        this.deletionVector = deletionVector;
        Action.$init$(this);
        FileAction.$init$(this);
        Product.$init$((Product)this);
        Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(path)).nonEmpty());
    }

    private class ParsedStatsFields
    implements Product,
    scala.Serializable {
        private final Option<Object> numLogicalRecords;
        public final /* synthetic */ AddFile $outer;

        public Option<Object> numLogicalRecords() {
            return this.numLogicalRecords;
        }

        public ParsedStatsFields copy(Option<Object> numLogicalRecords) {
            return new ParsedStatsFields(this.org$apache$spark$sql$delta$actions$AddFile$ParsedStatsFields$$$outer(), numLogicalRecords);
        }

        public Option<Object> copy$default$1() {
            return this.numLogicalRecords();
        }

        public String productPrefix() {
            return "ParsedStatsFields";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return this.numLogicalRecords();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ParsedStatsFields;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ParsedStatsFields)) return false;
            if (((ParsedStatsFields)object).org$apache$spark$sql$delta$actions$AddFile$ParsedStatsFields$$$outer() != this.org$apache$spark$sql$delta$actions$AddFile$ParsedStatsFields$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ParsedStatsFields parsedStatsFields = (ParsedStatsFields)x$1;
            Option<Object> option = this.numLogicalRecords();
            Option<Object> option2 = parsedStatsFields.numLogicalRecords();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!parsedStatsFields.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ AddFile org$apache$spark$sql$delta$actions$AddFile$ParsedStatsFields$$$outer() {
            return this.$outer;
        }

        public ParsedStatsFields(AddFile $outer, Option<Object> numLogicalRecords) {
            this.numLogicalRecords = numLogicalRecords;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

