/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionSet;
import org.apache.spark.sql.catalyst.expressions.ExpressionSet$;
import org.apache.spark.sql.delta.CurrentTransactionInfo;
import org.apache.spark.sql.delta.DeltaColumnMapping$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaLog$;
import org.apache.spark.sql.delta.DeltaTablePartitionReadPredicate;
import org.apache.spark.sql.delta.DeltaTablePartitionReadPredicate$;
import org.apache.spark.sql.delta.IsolationLevel;
import org.apache.spark.sql.delta.Serializable$;
import org.apache.spark.sql.delta.SnapshotIsolation$;
import org.apache.spark.sql.delta.WinningCommitSummary;
import org.apache.spark.sql.delta.WriteSerializable$;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.Action$;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.implicits.package$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.delta.util.FileNames$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\rc!B\u000e\u001d\u0001q1\u0003\u0002C\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\t\u0011a\u0002!\u0011!Q\u0001\neB\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\")Q\t\u0001C\u0001\r\"9A\n\u0001b\u0001\n#i\u0005B\u0002(\u0001A\u0003%a\bC\u0004P\u0001\t\u0007I\u0011\u0003)\t\r\u0011\u0004\u0001\u0015!\u0003R\u0011\u001d)\u0007A1A\u0005\u0012\u0019DaA\u001b\u0001!\u0002\u00139\u0007\"B6\u0001\t\u0003a\u0007bB7\u0001\u0005\u0004%\tB\u001c\u0005\u0007e\u0002\u0001\u000b\u0011B8\t\u000bM\u0004A\u0011\u0001;\t\u000bU\u0004A\u0011\u0003<\t\u000b]\u0004A\u0011\u0003=\t\u000bq\u0004A\u0011\u0003=\t\u000bu\u0004A\u0011\u0003=\t\u000by\u0004A\u0011\u0003=\t\u000b}\u0004A\u0011\u0003=\t\r\u0005\u0005\u0001\u0001\"\u0005y\u0011\u001d\t\u0019\u0001\u0001C\t\u0003\u000bAq!!\u0005\u0001\t#\t\u0019\u0002\u0003\u0004\u0002>\u0001!\t\u0002\u001f\u0005\u000b\u0003\u007f\u0001\u0001R1A\u0005\u0012\u0005\u0005#aD\"p]\u001ad\u0017n\u0019;DQ\u0016\u001c7.\u001a:\u000b\u0005uq\u0012!\u00023fYR\f'BA\u0010!\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003C\t\nQa\u001d9be.T!a\t\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0013aA8sON\u0019\u0001aJ\u0017\u0011\u0005!ZS\"A\u0015\u000b\u0003)\nQa]2bY\u0006L!\u0001L\u0015\u0003\r\u0005s\u0017PU3g!\tq\u0013'D\u00010\u0015\t\u0001D$\u0001\u0005nKR,'/\u001b8h\u0013\t\u0011tF\u0001\u0007EK2$\u0018\rT8hO&twm\u0001\u0001\u0011\u0005U2T\"\u0001\u0010\n\u0005]r\"\u0001D*qCJ\\7+Z:tS>t\u0017!H5oSRL\u0017\r\\\"veJ,g\u000e\u001e+sC:\u001c\u0018m\u0019;j_:LeNZ8\u0011\u0005iZT\"\u0001\u000f\n\u0005qb\"AF\"veJ,g\u000e\u001e+sC:\u001c\u0018m\u0019;j_:LeNZ8\u0002)]LgN\\5oO\u000e{W.\\5u-\u0016\u00148/[8o!\tAs(\u0003\u0002AS\t!Aj\u001c8h\u00039I7o\u001c7bi&|g\u000eT3wK2\u0004\"AO\"\n\u0005\u0011c\"AD%t_2\fG/[8o\u0019\u00164X\r\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\u001dC\u0015JS&\u0011\u0005i\u0002\u0001\"B\u0011\u0006\u0001\u0004!\u0004\"\u0002\u001d\u0006\u0001\u0004I\u0004\"B\u001f\u0006\u0001\u0004q\u0004\"B!\u0006\u0001\u0004\u0011\u0015aC:uCJ$H+[7f\u001bN,\u0012AP\u0001\rgR\f'\u000f\u001e+j[\u0016l5\u000fI\u0001\fi&l\u0017N\\4Ti\u0006$8/F\u0001R!\u0011\u0011v+\u0017 \u000e\u0003MS!\u0001V+\u0002\u000f5,H/\u00192mK*\u0011a+K\u0001\u000bG>dG.Z2uS>t\u0017B\u0001-T\u0005\u001dA\u0015m\u001d5NCB\u0004\"AW1\u000f\u0005m{\u0006C\u0001/*\u001b\u0005i&B\u000104\u0003\u0019a$o\\8u}%\u0011\u0001-K\u0001\u0007!J,G-\u001a4\n\u0005\t\u001c'AB*ue&twM\u0003\u0002aS\u0005aA/[7j]\u001e\u001cF/\u0019;tA\u0005AA-\u001a7uC2{w-F\u0001h!\tQ\u0004.\u0003\u0002j9\tAA)\u001a7uC2{w-A\u0005eK2$\u0018\rT8hA\u000512-\u001e:sK:$HK]1og\u0006\u001cG/[8o\u0013:4w.F\u0001:\u0003Q9\u0018N\u001c8j]\u001e\u001cu.\\7jiN+X.\\1ssV\tq\u000e\u0005\u0002;a&\u0011\u0011\u000f\b\u0002\u0015/&tg.\u001b8h\u0007>lW.\u001b;Tk6l\u0017M]=\u0002+]LgN\\5oO\u000e{W.\\5u'VlW.\u0019:zA\u0005q1\r[3dW\u000e{gN\u001a7jGR\u001cH#A\u001d\u00025\r\u0014X-\u0019;f/&tg.\u001b8h\u0007>lW.\u001b;Tk6l\u0017M]=\u0015\u0003=\f!d\u00195fG.\u0004&o\u001c;pG>d7i\\7qCRL'-\u001b7jif$\u0012!\u001f\t\u0003QiL!a_\u0015\u0003\tUs\u0017\u000e^\u0001\u0017G\",7m\u001b(p\u001b\u0016$\u0018\rZ1uCV\u0003H-\u0019;fg\u0006!4\r[3dW\u001a{'/\u00113eK\u00124\u0015\u000e\\3t)\"\fGo\u00155pk2$\u0007*\u0019<f\u0005\u0016,gNU3bI\nK8)\u001e:sK:$H\u000b\u001f8\u0002]\rDWmY6G_J$U\r\\3uK\u00124\u0015\u000e\\3t\u0003\u001e\f\u0017N\\:u\u0007V\u0014(/\u001a8u)bt'+Z1e\r&dWm]\u00012G\",7m\u001b$pe\u0012+G.\u001a;fI\u001aKG.Z:BO\u0006Lgn\u001d;DkJ\u0014XM\u001c;Uq:$U\r\\3uK\u00124\u0015\u000e\\3t\u0003}\u001a\u0007.Z2l\r>\u0014X\u000b\u001d3bi\u0016$\u0017\t\u001d9mS\u000e\fG/[8o)J\fgn]1di&|g.\u00133t)\"\fGoQ;se\u0016tG\u000f\u0016=o\t\u0016\u0004XM\u001c3t\u001f:\f\u0011dZ3u!J,G\u000f^=QCJ$\u0018\u000e^5p]6+7o]1hKR\u0019\u0011,a\u0002\t\u000f\u0005%q\u00031\u0001\u0002\f\u0005y\u0001/\u0019:uSRLwN\u001c,bYV,7\u000fE\u0003[\u0003\u001bI\u0016,C\u0002\u0002\u0010\r\u00141!T1q\u0003)\u0011XmY8sIRKW.Z\u000b\u0005\u0003+\ti\u0002\u0006\u0003\u0002\u0018\u0005eB\u0003BA\r\u0003_\u0001B!a\u0007\u0002\u001e1\u0001AaBA\u00101\t\u0007\u0011\u0011\u0005\u0002\u0002)F!\u00111EA\u0015!\rA\u0013QE\u0005\u0004\u0003OI#a\u0002(pi\"Lgn\u001a\t\u0004Q\u0005-\u0012bAA\u0017S\t\u0019\u0011I\\=\t\u0011\u0005E\u0002\u0004\"a\u0001\u0003g\t\u0011A\u001a\t\u0006Q\u0005U\u0012\u0011D\u0005\u0004\u0003oI#\u0001\u0003\u001fcs:\fW.\u001a \t\r\u0005m\u0002\u00041\u0001Z\u0003\u0015\u0001\b.Y:f\u0003)awnZ'fiJL7m]\u0001\nY><\u0007K]3gSb,\u0012!\u0017")
public class ConflictChecker
implements DeltaLogging {
    private String logPrefix;
    private final SparkSession spark;
    private final CurrentTransactionInfo initialCurrentTransactionInfo;
    private final long winningCommitVersion;
    private final IsolationLevel isolationLevel;
    private final long startTimeMs;
    private final HashMap<String, Object> timingStats;
    private final DeltaLog deltaLog;
    private final WinningCommitSummary winningCommitSummary;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public long startTimeMs() {
        return this.startTimeMs;
    }

    public HashMap<String, Object> timingStats() {
        return this.timingStats;
    }

    public DeltaLog deltaLog() {
        return this.deltaLog;
    }

    public CurrentTransactionInfo currentTransactionInfo() {
        return this.initialCurrentTransactionInfo;
    }

    public WinningCommitSummary winningCommitSummary() {
        return this.winningCommitSummary;
    }

    public CurrentTransactionInfo checkConflicts() {
        this.checkProtocolCompatibility();
        this.checkNoMetadataUpdates();
        this.checkForAddedFilesThatShouldHaveBeenReadByCurrentTxn();
        this.checkForDeletedFilesAgainstCurrentTxnReadFiles();
        this.checkForDeletedFilesAgainstCurrentTxnDeletedFiles();
        this.checkForUpdatedApplicationTransactionIdsThatCurrentTxnDependsOn();
        this.logMetrics();
        return this.currentTransactionInfo();
    }

    public WinningCommitSummary createWinningCommitSummary() {
        return (WinningCommitSummary)this.recordTime("initialize-old-commit", (Function0 & Serializable & scala.Serializable)() -> {
            Seq winningCommitActions = (Seq)this.deltaLog().store().read(FileNames$.MODULE$.deltaFile(this.deltaLog().logPath(), $this.winningCommitVersion), this.deltaLog().newDeltaHadoopConf()).map((Function1 & Serializable & scala.Serializable)json -> Action$.MODULE$.fromJson((String)json), Seq$.MODULE$.canBuildFrom());
            return new WinningCommitSummary((Seq<Action>)winningCommitActions, $this.winningCommitVersion);
        });
    }

    public void checkProtocolCompatibility() {
        if (this.winningCommitSummary().protocol().nonEmpty()) {
            this.winningCommitSummary().protocol().foreach((Function1 & Serializable & scala.Serializable)p -> {
                ConflictChecker.$anonfun$checkProtocolCompatibility$1(this, p);
                return BoxedUnit.UNIT;
            });
            if (this.currentTransactionInfo().actions().exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ConflictChecker.$anonfun$checkProtocolCompatibility$2(x$4)))) {
                throw DeltaErrors$.MODULE$.protocolChangedException(this.winningCommitSummary().commitInfo());
            }
        }
    }

    public void checkNoMetadataUpdates() {
        if (this.winningCommitSummary().metadataUpdates().nonEmpty()) {
            throw DeltaErrors$.MODULE$.metadataChangedException(this.winningCommitSummary().commitInfo());
        }
    }

    public void checkForAddedFilesThatShouldHaveBeenReadByCurrentTxn() {
        this.recordTime("checked-appends", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq seq;
            IsolationLevel isolationLevel = $this.isolationLevel;
            if (WriteSerializable$.MODULE$.equals(isolationLevel) && !this.currentTransactionInfo().metadataChanged()) {
                seq = this.winningCommitSummary().changedDataAddedFiles();
            } else {
                boolean bl = Serializable$.MODULE$.equals(isolationLevel) ? true : WriteSerializable$.MODULE$.equals(isolationLevel);
                if (bl) {
                    seq = (Seq)this.winningCommitSummary().changedDataAddedFiles().$plus$plus(this.winningCommitSummary().blindAppendAddedFiles(), Seq$.MODULE$.canBuildFrom());
                } else if (SnapshotIsolation$.MODULE$.equals(isolationLevel)) {
                    seq = (Seq)Nil$.MODULE$;
                } else {
                    throw new MatchError((Object)isolationLevel);
                }
            }
            Seq addedFilesToCheckForConflicts = seq;
            Tuple2 tuple2 = this.currentTransactionInfo().readPredicates().partition((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.shouldRewriteFilter()));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq rewrites = (Seq)tuple2._1();
            Seq nonRewrites = (Seq)tuple2._2();
            ExpressionSet canonicalRewrites = ExpressionSet$.MODULE$.apply((TraversableOnce)rewrites.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.predicate(), Seq$.MODULE$.canBuildFrom()));
            ExpressionSet canonicalNonRewrites = ExpressionSet$.MODULE$.apply((TraversableOnce)nonRewrites.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.predicate(), Seq$.MODULE$.canBuildFrom()));
            Iterable iterable = (Iterable)((TraversableLike)canonicalRewrites.map((Function1 & Serializable & scala.Serializable)x$8 -> new DeltaTablePartitionReadPredicate((Expression)x$8, DeltaTablePartitionReadPredicate$.MODULE$.apply$default$2()), Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)canonicalNonRewrites.map((Function1 & Serializable & scala.Serializable)x$9 -> new DeltaTablePartitionReadPredicate((Expression)x$9, false), Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
            Iterable canonicalPredicates = iterable;
            String[] predicatesMatchingAddedFiles = (String[])canonicalPredicates.iterator().flatMap((Function1 & Serializable & scala.Serializable)readPredicate -> {
                StructType x$1 = this.currentTransactionInfo().partitionSchemaAtReadTime();
                Dataset<Row> x$2 = package$.MODULE$.RichAddFileSeq((Seq<AddFile>)addedFilesToCheckForConflicts).toDF($this.spark);
                Expression expression = readPredicate.predicate();
                List x$3 = Nil$.MODULE$.$colon$colon((Object)expression);
                boolean x$4 = readPredicate.shouldRewriteFilter();
                Seq<String> x$5 = DeltaLog$.MODULE$.filterFileList$default$4();
                AddFile[] conflictingFile = (AddFile[])DeltaLog$.MODULE$.filterFileList(x$1, x$2, (Seq<Expression>)x$3, x$5, x$4).as(package$.MODULE$.addFileEncoder()).take(1);
                return Option$.MODULE$.option2Iterable(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])conflictingFile)).headOption().map((Function1 & Serializable & scala.Serializable)f -> this.getPrettyPartitionMessage(f.partitionValues())));
            }).take(1).toArray(ClassTag$.MODULE$.apply(String.class));
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predicatesMatchingAddedFiles)).nonEmpty()) {
                IsolationLevel isolationLevel2 = $this.isolationLevel;
                WriteSerializable$ writeSerializable$ = WriteSerializable$.MODULE$;
                boolean isWriteSerializable = !(isolationLevel2 != null ? !isolationLevel2.equals(writeSerializable$) : writeSerializable$ != null);
                None$ retryMsg = isWriteSerializable && this.winningCommitSummary().onlyAddFiles() && this.winningCommitSummary().isBlindAppendOption().isEmpty() ? new Some((Object)"Upgrading all your concurrent writers to use the latest Delta Lake may avoid this error. Please upgrade and then retry this operation again.") : None$.MODULE$;
                throw DeltaErrors$.MODULE$.concurrentAppendException(this.winningCommitSummary().commitInfo(), (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predicatesMatchingAddedFiles)).head(), (Option<String>)retryMsg);
            }
        });
    }

    public void checkForDeletedFilesAgainstCurrentTxnReadFiles() {
        this.recordTime("checked-deletes", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Map readFilePaths = ((TraversableOnce)this.currentTransactionInfo().readFiles().map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.path()), f.partitionValues()), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            Option deleteReadOverlap = this.winningCommitSummary().removedFiles().find((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)readFilePaths.contains((Object)r.path())));
            if (deleteReadOverlap.nonEmpty()) {
                String filePath = ((RemoveFile)deleteReadOverlap.get()).path();
                String partition = this.getPrettyPartitionMessage((Map<String, String>)((Map)readFilePaths.apply((Object)filePath)));
                throw DeltaErrors$.MODULE$.concurrentDeleteReadException(this.winningCommitSummary().commitInfo(), new StringBuilder(4).append(filePath).append(" in ").append(partition).toString());
            }
            if (this.winningCommitSummary().removedFiles().nonEmpty() && this.currentTransactionInfo().readWholeTable()) {
                String filePath = ((RemoveFile)this.winningCommitSummary().removedFiles().head()).path();
                throw DeltaErrors$.MODULE$.concurrentDeleteReadException(this.winningCommitSummary().commitInfo(), String.valueOf(filePath));
            }
        });
    }

    public void checkForDeletedFilesAgainstCurrentTxnDeletedFiles() {
        this.recordTime("checked-2x-deletes", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Set txnDeletes = ((TraversableOnce)((TraversableLike)this.currentTransactionInfo().actions().collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Action, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof RemoveFile) {
                        RemoveFile removeFile = (RemoveFile)A1;
                        object = removeFile;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Action x1) {
                    Action action = x1;
                    boolean bl = action instanceof RemoveFile;
                    return bl;
                }
            }, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.path(), Seq$.MODULE$.canBuildFrom())).toSet();
            Set deleteOverlap = (Set)((TraversableOnce)this.winningCommitSummary().removedFiles().map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.path(), Seq$.MODULE$.canBuildFrom())).toSet().intersect((GenSet)txnDeletes);
            if (deleteOverlap.nonEmpty()) {
                throw DeltaErrors$.MODULE$.concurrentDeleteDeleteException(this.winningCommitSummary().commitInfo(), (String)deleteOverlap.head());
            }
        });
    }

    public void checkForUpdatedApplicationTransactionIdsThatCurrentTxnDependsOn() {
        Set txnOverlap = (Set)((TraversableOnce)this.winningCommitSummary().appLevelTransactions().map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.appId(), Seq$.MODULE$.canBuildFrom())).toSet().intersect(this.currentTransactionInfo().readAppIds());
        if (txnOverlap.nonEmpty()) {
            throw DeltaErrors$.MODULE$.concurrentTransactionException(this.winningCommitSummary().commitInfo());
        }
    }

    public String getPrettyPartitionMessage(Map<String, String> partitionValues) {
        String string;
        StructType partitionColumns = this.currentTransactionInfo().partitionSchemaAtReadTime();
        if (partitionColumns.isEmpty()) {
            string = "the root of the table";
        } else {
            String partition = ((TraversableOnce)partitionColumns.map((Function1 & Serializable & scala.Serializable)field -> new StringBuilder(1).append(field.name()).append("=").append(partitionValues.apply((Object)DeltaColumnMapping$.MODULE$.getPhysicalName((StructField)field))).toString(), Seq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]");
            string = new StringBuilder(10).append("partition ").append(partition).toString();
        }
        return string;
    }

    public <T> T recordTime(String phase, Function0<T> f) {
        long startTimeNs = System.nanoTime();
        Object ret = f.apply();
        long timeTakenMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeNs);
        this.timingStats().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)phase), (Object)BoxesRunTime.boxToLong((long)timeTakenMs)));
        return (T)ret;
    }

    public void logMetrics() {
        long totalTimeTakenMs = System.currentTimeMillis() - this.startTimeMs();
        String timingStr = ((TraversableOnce)((TraversableLike)this.timingStats().keys().toSeq().sorted((Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)k -> new StringBuilder(1).append((String)k).append("=").append(this.timingStats().apply(k)).toString(), Seq$.MODULE$.canBuildFrom())).mkString(",");
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("[").append(this.logPrefix()).append("] Timing stats against ").append($this.winningCommitVersion).append(" ").append("[").append(timingStr).append(", totalTimeTakenMs: ").append(totalTimeTakenMs).append("]").toString());
    }

    private String logPrefix$lzycompute() {
        ConflictChecker conflictChecker = this;
        synchronized (conflictChecker) {
            if (!this.bitmap$0) {
                this.logPrefix = new StringBuilder(18).append("[tableId=").append(ConflictChecker.truncate$1(this.initialCurrentTransactionInfo.readSnapshot().metadata().id())).append(",").append("txnId=").append(ConflictChecker.truncate$1(this.initialCurrentTransactionInfo.txnId())).append("] ").toString();
                this.bitmap$0 = true;
            }
        }
        return this.logPrefix;
    }

    public String logPrefix() {
        return !this.bitmap$0 ? this.logPrefix$lzycompute() : this.logPrefix;
    }

    public static final /* synthetic */ void $anonfun$checkProtocolCompatibility$1(ConflictChecker $this, Protocol p) {
        $this.deltaLog().protocolRead(p);
        $this.deltaLog().protocolWrite(p);
    }

    public static final /* synthetic */ boolean $anonfun$checkProtocolCompatibility$2(Action x$4) {
        return x$4 instanceof Protocol;
    }

    private static final String truncate$1(String uuid) {
        return (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])uuid.split("-"))).head();
    }

    public ConflictChecker(SparkSession spark, CurrentTransactionInfo initialCurrentTransactionInfo, long winningCommitVersion, IsolationLevel isolationLevel) {
        this.spark = spark;
        this.initialCurrentTransactionInfo = initialCurrentTransactionInfo;
        this.winningCommitVersion = winningCommitVersion;
        this.isolationLevel = isolationLevel;
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        this.startTimeMs = System.currentTimeMillis();
        this.timingStats = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.deltaLog = initialCurrentTransactionInfo.readSnapshot().deltaLog();
        this.winningCommitSummary = this.createWinningCommitSummary();
    }
}

