/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.util.UriComponentsBuilder;

public class SparkUIUtil {
    private static final HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory((HttpClient)HttpClientBuilder.create().setMaxConnPerRoute(128).setMaxConnTotal(1024).disableRedirectHandling().build());
    private static final Logger logger = LoggerFactory.getLogger(SparkUIUtil.class);
    private static final int REDIRECT_THRESHOLD = 5;
    private static final String SPARK_UI_PROXY_HEADER = "X-Kylin-Proxy-Path";

    private SparkUIUtil() {
    }

    public static void resendSparkUIRequest(HttpServletRequest servletRequest, HttpServletResponse servletResponse, String sparkUiUrl, String uriPath, String proxyLocationBase) throws IOException {
        URI target = UriComponentsBuilder.fromHttpUrl((String)sparkUiUrl).path(uriPath).query(servletRequest.getQueryString()).build(true).toUri();
        HttpMethod method = HttpMethod.resolve((String)servletRequest.getMethod());
        try (ClientHttpResponse response = SparkUIUtil.execute(target, method, proxyLocationBase);){
            SparkUIUtil.rewrite(response, servletResponse, method, servletRequest.getRequestURL().toString(), 5, proxyLocationBase);
        }
    }

    public static ClientHttpResponse execute(URI uri, HttpMethod method, String proxyLocationBase) throws IOException {
        ClientHttpRequest clientHttpRequest = factory.createRequest(uri, method);
        clientHttpRequest.getHeaders().put(SPARK_UI_PROXY_HEADER, Collections.singletonList(proxyLocationBase));
        return clientHttpRequest.execute();
    }

    private static void rewrite(ClientHttpResponse response, HttpServletResponse servletResponse, HttpMethod originMethod, String originUrlStr, int depth, String proxyLocationBase) throws IOException {
        if (depth <= 0) {
            String msg = String.format(Locale.ROOT, "redirect exceed threshold: %d, origin request: [%s %s]", 5, originMethod, originUrlStr);
            logger.warn("UNEXPECTED_THINGS_HAPPENED {}", (Object)msg);
            servletResponse.getWriter().write(msg);
            return;
        }
        HttpHeaders headers = response.getHeaders();
        if (response.getStatusCode().is3xxRedirection()) {
            try (ClientHttpResponse r = SparkUIUtil.execute(headers.getLocation(), originMethod, proxyLocationBase);){
                SparkUIUtil.rewrite(r, servletResponse, originMethod, originUrlStr, depth - 1, proxyLocationBase);
            }
            return;
        }
        servletResponse.setStatus(response.getRawStatusCode());
        if (response.getHeaders().getContentType() != null) {
            servletResponse.setHeader("Content-Type", Objects.requireNonNull(headers.getContentType()).toString());
        }
        IOUtils.copy((InputStream)response.getBody(), (OutputStream)servletResponse.getOutputStream());
    }
}

