/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.annotation.ThirdPartyDependencies;
import org.apache.kylin.common.util.CaseInsensitiveStringSet;
import org.apache.kylin.metadata.user.ManagedUser;
import org.apache.kylin.rest.request.CachedUserUpdateRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.provisioning.UserDetailsManager;

@ThirdPartyDependencies(value={@ThirdPartyDependencies.ThirdPartyDependent(repository="static-user-manager", classes={"StaticUserGroupService"})})
public interface UserService
extends UserDetailsManager {
    public static final Logger logger = LoggerFactory.getLogger(UserService.class);

    public List<ManagedUser> listUsers() throws IOException;

    default public List<ManagedUser> listUsers(boolean needSort) throws IOException {
        return this.listUsers();
    }

    public List<String> listAdminUsers() throws IOException;

    default public List<String> listSuperAdminUsers() {
        String superAdminUsername = KylinConfig.getInstanceFromEnv().getSuperAdminUsername();
        if (StringUtils.isEmpty((CharSequence)superAdminUsername)) {
            return Collections.emptyList();
        }
        List<String> superAdmins = Collections.emptyList();
        try {
            superAdmins = this.listAdminUsers().stream().filter(user -> user.equalsIgnoreCase(superAdminUsername)).collect(Collectors.toList());
        }
        catch (IOException e) {
            logger.error("listSuperAdminUsers error", (Throwable)e);
        }
        return superAdmins;
    }

    default public List<String> listNormalUsers() throws IOException {
        List<String> adminUserNames = this.listAdminUsers();
        return this.listUsers().stream().map(ManagedUser::getUsername).filter(username -> !adminUserNames.contains(username)).collect(Collectors.toList());
    }

    public void completeUserInfo(ManagedUser var1);

    default public List<ManagedUser> getManagedUsersByFuzzMatching(String userName, boolean isCaseSensitive) throws IOException {
        return this.listUsers().stream().filter(managedUser -> {
            if (StringUtils.isEmpty((CharSequence)userName)) {
                return true;
            }
            if (isCaseSensitive) {
                return managedUser.getUsername().contains(userName);
            }
            return StringUtils.containsIgnoreCase((CharSequence)managedUser.getUsername(), (CharSequence)userName);
        }).collect(Collectors.toList());
    }

    default public Set<String> getGlobalAdmin() throws IOException {
        CaseInsensitiveStringSet adminUsers = new CaseInsensitiveStringSet();
        adminUsers.addAll(this.listAdminUsers());
        return adminUsers;
    }

    default public boolean containsGlobalAdmin(Set<String> usernames) throws IOException {
        Set<String> adminUsers = this.getGlobalAdmin();
        for (String name : usernames) {
            if (!adminUsers.contains(name)) continue;
            return true;
        }
        return false;
    }

    default public boolean isGlobalAdmin(String username) throws IOException {
        try {
            UserDetails userDetails = this.loadUserByUsername(username);
            return this.isGlobalAdmin(userDetails);
        }
        catch (Exception e) {
            logger.debug("Cat not load user by username {}", (Object)username, (Object)e);
            return false;
        }
    }

    default public boolean isGlobalAdmin(UserDetails userDetails) throws IOException {
        return userDetails != null && (userDetails.getAuthorities().stream().anyMatch(grantedAuthority -> grantedAuthority.getAuthority().equals("ROLE_ADMIN")) || this.getGlobalAdmin().contains(userDetails.getUsername()));
    }

    default public Set<String> retainsNormalUser(Set<String> usernames) throws IOException {
        HashSet<String> results = new HashSet<String>(usernames);
        Set<String> globalAdmin = this.getGlobalAdmin();
        results.removeIf(globalAdmin::contains);
        return results;
    }

    default public void refresh(CachedUserUpdateRequest request) {
    }
}

