/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import org.apache.kylin.metadata.resourcegroup.ResourceGroup;
import org.apache.kylin.metadata.resourcegroup.ResourceGroupManager;
import org.apache.kylin.rest.aspect.Transaction;
import org.apache.kylin.rest.request.resourecegroup.ResourceGroupRequest;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="resourceGroupService")
public class ResourceGroupService
extends BasicService {
    @Autowired
    public AclEvaluate aclEvaluate;

    @Transaction
    public void updateResourceGroup(ResourceGroupRequest request) {
        this.aclEvaluate.checkIsGlobalAdmin();
        ResourceGroupManager manager = this.getManager(ResourceGroupManager.class);
        manager.updateResourceGroup(copyForWrite -> {
            copyForWrite.setResourceGroupEnabled(request.isResourceGroupEnabled());
            copyForWrite.setResourceGroupEntities(request.getResourceGroupEntities());
            copyForWrite.setKylinInstances(request.getKylinInstances());
            copyForWrite.setResourceGroupMappingInfoList(request.getResourceGroupMappingInfoList());
        });
    }

    public ResourceGroup getResourceGroup() {
        ResourceGroupManager manager = this.getManager(ResourceGroupManager.class);
        return manager.getResourceGroup();
    }
}

