/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.rest.security.MutableHttpServletRequest;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.GenericFilterBean;

@Component(value="fillEmptyAuthorizationFilter")
public class FillEmptyAuthorizationFilter
extends GenericFilterBean {
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean skipBasicAuthorization = KylinConfig.getInstanceFromEnv().isSkipBasicAuthorization();
        HttpServletRequest req = (HttpServletRequest)request;
        if (req.getSession(false) == null && skipBasicAuthorization) {
            MutableHttpServletRequest mutableRequest = new MutableHttpServletRequest(req);
            mutableRequest.putHeader("Authorization", "basic MDow");
            chain.doFilter((ServletRequest)mutableRequest, response);
        } else {
            chain.doFilter(request, response);
        }
    }
}

