/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.TableDesc;

public class TableDescResponse
extends TableDesc {
    @JsonProperty(value="exd")
    private Map<String, String> descExd = new HashMap<String, String>();
    @JsonProperty(value="root_fact")
    private boolean rootFact;
    @JsonProperty(value="lookup")
    private boolean lookup;
    @JsonProperty(value="primary_key")
    private Set<String> primaryKey = new HashSet<String>();
    @JsonProperty(value="foreign_key")
    private Set<String> foreignKey = new HashSet<String>();
    @JsonProperty(value="partitioned_column")
    private String partitionedColumn;
    @JsonProperty(value="partitioned_column_format")
    private String partitionedColumnFormat;
    @JsonProperty(value="segment_range")
    private SegmentRange segmentRange;
    @JsonProperty(value="storage_size")
    private long storageSize = -1L;
    @JsonProperty(value="total_records")
    private long totalRecords;
    @JsonProperty(value="sampling_rows")
    private List<String[]> samplingRows = new ArrayList<String[]>();
    @JsonProperty(value="columns")
    private ColumnDescResponse[] extColumns = new ColumnDescResponse[this.getColumns().length];
    @JsonProperty(value="last_build_job_id")
    private String jodID;
    @JsonProperty(value="excluded")
    private boolean excluded;
    @JsonProperty(value="kafka_bootstrap_servers")
    private String kafkaBootstrapServers;
    @JsonProperty(value="subscribe")
    private String subscribe;
    @JsonProperty(value="batch_table_identity")
    private String batchTable;
    @JsonProperty(value="parser_name")
    private String parserName;

    public TableDescResponse(TableDesc table) {
        super(table);
        for (int i = 0; i < this.getColumns().length; ++i) {
            this.extColumns[i] = new ColumnDescResponse(this.getColumns()[i]);
        }
    }

    @JsonProperty(value="cardinality", access=JsonProperty.Access.READ_ONLY)
    public Map<String, Long> getCardinality() {
        HashMap cardinality = Maps.newHashMapWithExpectedSize((int)this.extColumns.length);
        for (ColumnDescResponse extColumn : this.extColumns) {
            if (extColumn.getCardinality() == null) continue;
            cardinality.put(extColumn.getName(), extColumn.getCardinality());
        }
        return cardinality;
    }

    @JsonProperty(value="is_transactional", access=JsonProperty.Access.READ_ONLY)
    public boolean getTransactionalV2() {
        return super.isTransactional();
    }

    @Generated
    public void setDescExd(Map<String, String> descExd) {
        this.descExd = descExd;
    }

    @Generated
    public void setRootFact(boolean rootFact) {
        this.rootFact = rootFact;
    }

    @Generated
    public void setLookup(boolean lookup) {
        this.lookup = lookup;
    }

    @Generated
    public void setPrimaryKey(Set<String> primaryKey) {
        this.primaryKey = primaryKey;
    }

    @Generated
    public void setForeignKey(Set<String> foreignKey) {
        this.foreignKey = foreignKey;
    }

    @Generated
    public void setPartitionedColumn(String partitionedColumn) {
        this.partitionedColumn = partitionedColumn;
    }

    @Generated
    public void setPartitionedColumnFormat(String partitionedColumnFormat) {
        this.partitionedColumnFormat = partitionedColumnFormat;
    }

    @Generated
    public void setSegmentRange(SegmentRange segmentRange) {
        this.segmentRange = segmentRange;
    }

    @Generated
    public void setStorageSize(long storageSize) {
        this.storageSize = storageSize;
    }

    @Generated
    public void setTotalRecords(long totalRecords) {
        this.totalRecords = totalRecords;
    }

    @Generated
    public void setSamplingRows(List<String[]> samplingRows) {
        this.samplingRows = samplingRows;
    }

    @Generated
    public void setExtColumns(ColumnDescResponse[] extColumns) {
        this.extColumns = extColumns;
    }

    @Generated
    public void setJodID(String jodID) {
        this.jodID = jodID;
    }

    @Generated
    public void setExcluded(boolean excluded) {
        this.excluded = excluded;
    }

    @Generated
    public void setKafkaBootstrapServers(String kafkaBootstrapServers) {
        this.kafkaBootstrapServers = kafkaBootstrapServers;
    }

    @Generated
    public void setSubscribe(String subscribe) {
        this.subscribe = subscribe;
    }

    @Generated
    public void setBatchTable(String batchTable) {
        this.batchTable = batchTable;
    }

    @Generated
    public void setParserName(String parserName) {
        this.parserName = parserName;
    }

    @Generated
    public Map<String, String> getDescExd() {
        return this.descExd;
    }

    @Generated
    public boolean isRootFact() {
        return this.rootFact;
    }

    @Generated
    public boolean isLookup() {
        return this.lookup;
    }

    @Generated
    public Set<String> getPrimaryKey() {
        return this.primaryKey;
    }

    @Generated
    public Set<String> getForeignKey() {
        return this.foreignKey;
    }

    @Generated
    public String getPartitionedColumn() {
        return this.partitionedColumn;
    }

    @Generated
    public String getPartitionedColumnFormat() {
        return this.partitionedColumnFormat;
    }

    @Generated
    public SegmentRange getSegmentRange() {
        return this.segmentRange;
    }

    @Generated
    public long getStorageSize() {
        return this.storageSize;
    }

    @Generated
    public long getTotalRecords() {
        return this.totalRecords;
    }

    @Generated
    public List<String[]> getSamplingRows() {
        return this.samplingRows;
    }

    @Generated
    public ColumnDescResponse[] getExtColumns() {
        return this.extColumns;
    }

    @Generated
    public String getJodID() {
        return this.jodID;
    }

    @Generated
    public boolean isExcluded() {
        return this.excluded;
    }

    @Generated
    public String getKafkaBootstrapServers() {
        return this.kafkaBootstrapServers;
    }

    @Generated
    public String getSubscribe() {
        return this.subscribe;
    }

    @Generated
    public String getBatchTable() {
        return this.batchTable;
    }

    @Generated
    public String getParserName() {
        return this.parserName;
    }

    public static class ColumnDescResponse
    extends ColumnDesc {
        @JsonProperty(value="cardinality")
        private Long cardinality;
        @JsonProperty(value="min_value")
        private String minValue;
        @JsonProperty(value="max_value")
        private String maxValue;
        @JsonProperty(value="null_count")
        private Long nullCount;
        @JsonProperty(value="excluded")
        private boolean excluded;

        ColumnDescResponse(ColumnDesc col) {
            super(col);
        }

        @Generated
        public Long getCardinality() {
            return this.cardinality;
        }

        @Generated
        public String getMinValue() {
            return this.minValue;
        }

        @Generated
        public String getMaxValue() {
            return this.maxValue;
        }

        @Generated
        public Long getNullCount() {
            return this.nullCount;
        }

        @Generated
        public boolean isExcluded() {
            return this.excluded;
        }

        @Generated
        public void setCardinality(Long cardinality) {
            this.cardinality = cardinality;
        }

        @Generated
        public void setMinValue(String minValue) {
            this.minValue = minValue;
        }

        @Generated
        public void setMaxValue(String maxValue) {
            this.maxValue = maxValue;
        }

        @Generated
        public void setNullCount(Long nullCount) {
            this.nullCount = nullCount;
        }

        @Generated
        public void setExcluded(boolean excluded) {
            this.excluded = excluded;
        }
    }
}

