/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.handler.resourcegroup;

import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.rest.handler.resourcegroup.IResourceGroupRequestValidator;
import org.apache.kylin.rest.request.resourecegroup.ResourceGroupRequest;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=200)
@Component
public class ResourceGroupEnabledValidator
implements IResourceGroupRequestValidator {
    @Override
    public void validate(ResourceGroupRequest request) {
        if (!request.isResourceGroupEnabled()) {
            return;
        }
        if (CollectionUtils.isNotEmpty(request.getResourceGroupEntities())) {
            return;
        }
        throw new KylinException((ErrorCodeProducer)ErrorCodeServer.RESOURCE_GROUP_ENABLE_FAILED, new Object[0]);
    }
}

