/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.utils;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.apache.kylin.cluster.AvailableResource;
import org.apache.kylin.cluster.IClusterManager;
import org.apache.kylin.cluster.ResourceInfo;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.job.KylinBuildEnv$;
import org.apache.spark.SparkConf;
import org.apache.spark.application.NoRetryException;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class ResourceUtils$
implements Logging {
    public static ResourceUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ResourceUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String caculateRequiredCores(Map<String, String> detectItems) throws Exception {
        String string;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            ObjectRef pNum;
            block0: {
                Iterator it = detectItems.entrySet().iterator();
                pNum = ObjectRef.create((Object)"1");
                if (!it.hasNext()) break block0;
                Map.Entry item = it.next();
                pNum.elem = (String)item.getValue();
                MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Require core num is ").append((String)pNum$1.elem).toString());
            }
            return (String)pNum.elem;
        });
        if (try_ instanceof Success) {
            String partitionNum;
            Success success = (Success)try_;
            string = partitionNum = (String)success.value();
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable throwable = failure.exception();
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("caculate required cores failed ").append(MODULE$.getClass().getName()).toString(), throwable);
            string = "1";
        } else {
            throw new MatchError((Object)try_);
        }
        return string;
    }

    public boolean checkResource(SparkConf sparkConf, IClusterManager clusterManager, boolean skipCheckResource) throws Exception {
        if (skipCheckResource) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "skip check resource.");
            return true;
        }
        this.verifyClusterResource(clusterManager.fetchMaximumResourceAllocation(), sparkConf);
        String queue = sparkConf.get("spark.yarn.queue", "default");
        int driverMemory = (int)(Utils$.MODULE$.byteStringAsMb(sparkConf.get("spark.driver.memory")) + Utils$.MODULE$.byteStringAsMb(sparkConf.get("spark.driver.memoryOverhead")));
        int driverCores = new StringOps(Predef$.MODULE$.augmentString(sparkConf.get("spark.driver.cores"))).toInt();
        AvailableResource queueAvailable = this.minusDriverResource(clusterManager.fetchQueueAvailableResource(queue), driverMemory, driverCores);
        int instances = new StringOps(Predef$.MODULE$.augmentString(sparkConf.get("spark.executor.instances"))).toInt();
        long executorMemory = (Utils$.MODULE$.byteStringAsMb(sparkConf.get("spark.executor.memory")) + Utils$.MODULE$.byteStringAsMb(sparkConf.get("spark.executor.memoryOverhead"))) * (long)instances;
        int executorCores = new StringOps(Predef$.MODULE$.augmentString(sparkConf.get("spark.executor.cores"))).toInt() * instances;
        if (!this.verify(queueAvailable.max(), executorMemory, executorCores, instances)) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Require resource (").append(executorMemory).append(" MB, ").append(executorCores).append(" vCores),").append(" queue max resource (").append(queueAvailable.max().memory()).append(" MB, ").append(queueAvailable.max().vCores()).append(" vCores)").toString());
            throw new NoRetryException("Total queue resource does not meet requirement");
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Require resource (").append(executorMemory).append(" MB, ").append(executorCores).append(" vCores),").append(" available resource (").append(queueAvailable.available().memory()).append(" MB, ").append(queueAvailable.available().vCores()).append(" vCores)").toString());
        return this.verify(queueAvailable.available(), executorMemory, executorCores, instances);
    }

    public boolean checkResource$default$3() {
        return false;
    }

    private boolean verify(ResourceInfo resource, long memory, long vCores, int instances) {
        return instances == 1 ? (long)resource.memory() >= memory && (long)resource.vCores() >= vCores : (double)resource.memory() * 1.0 / (double)memory >= 0.5 && (double)resource.vCores() * 1.0 / (double)vCores >= 0.5;
    }

    private AvailableResource minusDriverResource(AvailableResource queueAvailable, int memory, int vCores) {
        int am = queueAvailable.available().memory() - memory;
        int av = queueAvailable.available().vCores() - vCores;
        int mm = queueAvailable.max().memory() - memory;
        int mv = queueAvailable.max().vCores() - vCores;
        return new AvailableResource(new ResourceInfo(am, av), new ResourceInfo(mm, mv));
    }

    private void verifyClusterResource(ResourceInfo maxResource, SparkConf sparkConf) {
        Double mp = KylinBuildEnv$.MODULE$.get().kylinConfig().getMaxAllocationResourceProportion();
        Double olp = KylinBuildEnv$.MODULE$.get().kylinConfig().getSparkEngineResourceRequestOverLimitProportion();
        double maxMem = (double)maxResource.memory() * Predef$.MODULE$.Double2double(mp);
        int executorMem = (int)(Utils$.MODULE$.byteStringAsMb(sparkConf.get("spark.executor.memory")) + Utils$.MODULE$.byteStringAsMb(sparkConf.get("spark.executor.memoryOverhead")));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(149).append("Verifying our application has not requested s(").append(executorMem).append(" MB per executor) more than the maximum allocation ").append("memory capability of the cluster (").append(maxMem).append(" MB per container)").toString());
        if (maxMem < (double)executorMem) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Use kylin.engine.resource-request-over-limit-proportion ").append(olp).toString());
            if (maxMem * Predef$.MODULE$.Double2double(olp) > (double)executorMem) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("The maximum memory capability tolerate maximum requested ").append(maxMem * Predef$.MODULE$.Double2double(olp)).append(" MB per executor").toString());
                double rp = maxMem * 1.0 / (double)executorMem;
                int executorOverhead = (int)((double)Utils$.MODULE$.byteStringAsMb(sparkConf.get("spark.executor.memoryOverhead")) * rp);
                int executorMemory = (int)((double)Utils$.MODULE$.byteStringAsMb(sparkConf.get("spark.executor.memory")) * rp);
                sparkConf.set("spark.executor.memoryOverhead", new StringBuilder(2).append(executorOverhead).append("MB").toString());
                sparkConf.set("spark.executor.memory", new StringBuilder(2).append(executorMemory).append("MB").toString());
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Set spark.executor.memoryOverhead to ").append(executorOverhead).append("MB").toString());
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Set spark.executor.memory to ").append(executorMemory).append("MB").toString());
            } else {
                throw new NoRetryException(new StringBuilder(133).append("Our application has requested s(").append(executorMem).append(" MB per executor) more than the maximum allocation ").append("memory capability of the cluster ").append(maxMem).append(" MB per container").toString());
            }
        }
    }

    public int getAllCores(SparkConf conf, KylinConfig config) {
        return this.isCluster(conf) ? this.getExecutorCores(conf, config) + this.getDriverCores(conf, config) : this.getExecutorCores(conf, config);
    }

    /*
     * WARNING - void declaration
     */
    public String getQueueName(SparkConf conf) {
        void var2_2;
        block0: {
            String queue = conf.get("spark.kubernetes.scheduler.volcano.podGroup.spec.queue", null);
            if (queue != null) break block0;
            queue = conf.get("spark.yarn.queue", "default");
        }
        return var2_2;
    }

    public long getAllMemory(SparkConf conf, KylinConfig config) {
        return this.isCluster(conf) ? this.getExecutorMemory(conf, config) + this.getDriverMemory(conf, config) : this.getExecutorMemory(conf, config);
    }

    private boolean isCluster(SparkConf conf) {
        return ((String)conf.get(org.apache.spark.internal.config.package$.MODULE$.SUBMIT_DEPLOY_MODE())).equals("cluster");
    }

    private int getDriverCores(SparkConf conf, KylinConfig config) {
        return package$.MODULE$.max(BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DRIVER_CORES())), config.getContainerMinCore());
    }

    private long getDriverMemory(SparkConf conf, KylinConfig config) {
        long driverMemory = BoxesRunTime.unboxToLong((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY()));
        int driverMemoryOverhead = (int)BoxesRunTime.unboxToLong((Object)((Option)conf.get((ConfigEntry)org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY_OVERHEAD())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> package$.MODULE$.max((long)(BoxesRunTime.unboxToDouble((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY_OVERHEAD_FACTOR())) * (double)driverMemory), ResourceProfile$.MODULE$.MEMORY_OVERHEAD_MIN_MIB())));
        return package$.MODULE$.max(driverMemory + (long)driverMemoryOverhead, config.getContainerMinMB());
    }

    private int getExecutorCores(SparkConf conf, KylinConfig config) {
        int executorCores = BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_CORES()));
        return package$.MODULE$.max(executorCores, config.getContainerMinCore()) * this.getExecutors(conf);
    }

    private long getExecutorMemory(SparkConf conf, KylinConfig config) {
        long executorMemory = BoxesRunTime.unboxToLong((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY()));
        int executorOffHeapMemory = Utils$.MODULE$.executorOffHeapMemorySizeAsMb(conf);
        int executorMemoryOverhead = (int)BoxesRunTime.unboxToLong((Object)((Option)conf.get((ConfigEntry)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY_OVERHEAD())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> package$.MODULE$.max((long)(BoxesRunTime.unboxToDouble((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY_OVERHEAD_FACTOR())) * (double)executorMemory), ResourceProfile$.MODULE$.MEMORY_OVERHEAD_MIN_MIB())));
        return package$.MODULE$.max(executorMemory + (long)executorMemoryOverhead + (long)executorOffHeapMemory, config.getContainerMinMB()) * (long)this.getExecutors(conf);
    }

    private int getExecutors(SparkConf conf) {
        return BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_INSTANCES())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    private ResourceUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

