/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.source;

import java.io.IOException;
import java.util.Locale;
import org.apache.kylin.engine.spark.source.NSparkTableReader;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.source.IReadableTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSparkTable
implements IReadableTable {
    private static final Logger logger = LoggerFactory.getLogger(NSparkTable.class);
    private final String database;
    private final String tableName;

    public NSparkTable(TableDesc tableDesc) {
        this.database = tableDesc.getDatabase();
        this.tableName = tableDesc.getName();
    }

    public IReadableTable.TableReader getReader() throws IOException {
        return new NSparkTableReader(this.database, this.tableName);
    }

    public IReadableTable.TableSignature getSignature() throws IOException {
        String path = String.format(Locale.ROOT, "%s.%s", this.database, this.tableName);
        long lastModified = System.currentTimeMillis();
        int size = 0;
        return new IReadableTable.TableSignature(path, (long)size, lastModified);
    }

    public boolean exists() {
        return true;
    }

    public String toString() {
        return "spark: database=[" + this.database + "], table=[" + this.tableName + "]";
    }
}

