/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.merger;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.engine.spark.ExecutableUtils;
import org.apache.kylin.engine.spark.merger.MetadataMerger;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.execution.MergerInfo;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NDataflowUpdate;
import org.apache.kylin.metadata.cube.model.PartitionStatusEnum;
import org.apache.kylin.metadata.model.SegmentStatusEnum;

public class AfterMergeOrRefreshResourceMerger
extends MetadataMerger {
    public AfterMergeOrRefreshResourceMerger(KylinConfig config, String project) {
        super(config, project);
    }

    public NDataLayout[] mergeMultiPartitionModel(String dataflowId, Set<String> segmentIds, Set<Long> layoutIds, ResourceStore remoteResourceStore, JobTypeEnum jobType, Set<Long> partitions) {
        NDataSegment mergedSegment;
        NDataflowManager mgr = NDataflowManager.getInstance((KylinConfig)this.getConfig(), (String)this.getProject());
        NDataflowUpdate update = new NDataflowUpdate(dataflowId);
        NDataflowManager localDataflowManager = NDataflowManager.getInstance((KylinConfig)this.getConfig(), (String)this.getProject());
        NDataflow localDataflow = localDataflowManager.getDataflow(dataflowId);
        NDataflowManager distMgr = NDataflowManager.getInstance((KylinConfig)remoteResourceStore.getConfig(), (String)this.getProject());
        NDataflow distDataflow = distMgr.getDataflow(update.getDataflowId());
        ArrayList toUpdateSegments = Lists.newArrayList();
        ArrayList toUpdateCuboids = Lists.newArrayList();
        NDataSegment remoteSegment = distDataflow.getSegment(segmentIds.iterator().next()).copy();
        NDataSegment localSegment = localDataflow.getSegment(segmentIds.iterator().next()).copy();
        Set<Long> availableLayoutIds = this.getAvailableLayoutIds(localDataflow, layoutIds);
        List toRemoveSegments = Lists.newArrayList();
        if (JobTypeEnum.SUB_PARTITION_REFRESH != jobType) {
            toRemoveSegments = distMgr.getToRemoveSegs(distDataflow, remoteSegment);
        }
        if (JobTypeEnum.INDEX_MERGE == jobType) {
            mergedSegment = remoteSegment;
            long lastBuildTime = System.currentTimeMillis();
            mergedSegment.getMultiPartitions().forEach(partition -> {
                partition.setStatus(PartitionStatusEnum.READY);
                partition.setLastBuildTime(lastBuildTime);
            });
            mergedSegment.setLastBuildTime(lastBuildTime);
            toUpdateCuboids.addAll(new ArrayList(mergedSegment.getSegDetails().getEffectiveLayouts()));
        } else {
            mergedSegment = this.upsertSegmentPartition(localSegment, remoteSegment, partitions);
            for (String segId : segmentIds) {
                NDataSegment remoteSeg = distDataflow.getSegment(segId).copy();
                NDataSegment localSeg = localDataflow.getSegment(segId).copy();
                for (long layoutId : availableLayoutIds) {
                    NDataLayout remoteLayout = remoteSeg.getLayout(layoutId);
                    NDataLayout localLayout = localSeg.getLayout(layoutId);
                    NDataLayout upsertLayout = this.upsertLayoutPartition(localLayout, remoteLayout, partitions);
                    toUpdateCuboids.add(upsertLayout);
                }
            }
        }
        if (mergedSegment.getStatus() == SegmentStatusEnum.NEW) {
            mergedSegment.setStatus(SegmentStatusEnum.READY);
        }
        mergedSegment.setDictReady(false);
        mergedSegment.setMvcc(localSegment.getMvcc());
        toUpdateSegments.add(mergedSegment);
        if (JobTypeEnum.INDEX_MERGE == jobType) {
            Optional<Long> reduce = toRemoveSegments.stream().map(NDataSegment::getSourceBytesSize).filter(size -> size != -1L).reduce(Long::sum);
            if (reduce.isPresent()) {
                long totalSourceSize = reduce.get();
                mergedSegment.setSourceBytesSize(totalSourceSize);
                mergedSegment.setLastBuildTime(System.currentTimeMillis());
            }
            if (toRemoveSegments.stream().anyMatch(seg -> seg.getStatus() == SegmentStatusEnum.WARNING)) {
                mergedSegment.setStatus(SegmentStatusEnum.WARNING);
            }
        }
        update.setToAddOrUpdateLayouts(toUpdateCuboids.toArray(new NDataLayout[0]));
        update.setToRemoveSegs(toRemoveSegments.toArray(new NDataSegment[0]));
        update.setToUpdateSegs(toUpdateSegments.toArray(new NDataSegment[0]));
        mgr.updateDataflow(update);
        this.updateIndexPlan(dataflowId, remoteResourceStore);
        return update.getToAddOrUpdateLayouts();
    }

    public NDataLayout[] mergeNormalModel(String dataflowId, Set<String> segmentIds, Set<Long> layoutIds, ResourceStore remoteResourceStore, JobTypeEnum jobType) {
        NDataflowManager mgr = NDataflowManager.getInstance((KylinConfig)this.getConfig(), (String)this.getProject());
        NDataflowUpdate update = new NDataflowUpdate(dataflowId);
        NDataflowManager distMgr = NDataflowManager.getInstance((KylinConfig)remoteResourceStore.getConfig(), (String)this.getProject());
        NDataflow distDataflow = distMgr.getDataflow(update.getDataflowId());
        ArrayList toUpdateSegments = Lists.newArrayList();
        ArrayList toUpdateCuboids = Lists.newArrayList();
        NDataSegment mergedSegment = distDataflow.getSegment(segmentIds.iterator().next()).copy();
        if (mergedSegment.getStatus() == SegmentStatusEnum.NEW) {
            mergedSegment.setStatus(SegmentStatusEnum.READY);
        }
        mergedSegment.setLastBuildTime(mergedSegment.getSegDetails().getLastModified());
        mergedSegment.setDictReady(false);
        mergedSegment.setMvcc(mgr.getDataflow(dataflowId).getSegment(mergedSegment.getUuid()).getMvcc());
        toUpdateSegments.add(mergedSegment);
        List toRemoveSegments = distMgr.getToRemoveSegs(distDataflow, mergedSegment);
        if (JobTypeEnum.INDEX_MERGE == jobType) {
            Optional<Long> reduce = toRemoveSegments.stream().map(NDataSegment::getSourceBytesSize).filter(size -> size != -1L).reduce(Long::sum);
            if (reduce.isPresent()) {
                long totalSourceSize = reduce.get();
                mergedSegment.setSourceBytesSize(totalSourceSize);
                mergedSegment.setLastBuildTime(System.currentTimeMillis());
            }
            if (toRemoveSegments.stream().anyMatch(seg -> seg.getStatus() == SegmentStatusEnum.WARNING)) {
                mergedSegment.setStatus(SegmentStatusEnum.WARNING);
            }
        }
        toUpdateCuboids.addAll(new ArrayList(mergedSegment.getSegDetails().getEffectiveLayouts()));
        update.setToAddOrUpdateLayouts(toUpdateCuboids.toArray(new NDataLayout[0]));
        update.setToRemoveSegs(toRemoveSegments.toArray(new NDataSegment[0]));
        update.setToUpdateSegs(toUpdateSegments.toArray(new NDataSegment[0]));
        if (distDataflow.getModel().getStorageType().isV3Storage()) {
            this.mergeLayoutDetails(this.getProject(), distDataflow.getModel().getId(), layoutIds, mergedSegment, toRemoveSegments, remoteResourceStore.getConfig());
        }
        mgr.updateDataflow(update);
        this.updateIndexPlan(dataflowId, remoteResourceStore);
        return update.getToAddOrUpdateLayouts();
    }

    public NDataLayout[] merge(String dataflowId, Set<String> segmentIds, Set<Long> layoutIds, ResourceStore remoteResourceStore, JobTypeEnum jobType, Set<Long> partitions) {
        if (CollectionUtils.isNotEmpty(partitions)) {
            return this.mergeMultiPartitionModel(dataflowId, segmentIds, layoutIds, remoteResourceStore, jobType, partitions);
        }
        return this.mergeNormalModel(dataflowId, segmentIds, layoutIds, remoteResourceStore, jobType);
    }

    public NDataLayout[] merge(MergerInfo.TaskMergeInfo info) {
        try (ResourceStore buildResourceStore = ExecutableUtils.getRemoteStore((KylinConfig)this.getConfig(), (String)info.getOutputMetaUrl());){
            String dataFlowId = info.getDataFlowId();
            Set segmentIds = info.getSegmentIds();
            Set layoutIds = info.getLayoutIds();
            Set partitionIds = info.getPartitionIds();
            JobTypeEnum jobType = info.getJobType();
            boolean needBuildSnapshots = info.isNeedBuildSnapshots();
            NDataLayout[] nDataLayouts = this.merge(dataFlowId, segmentIds, layoutIds, buildResourceStore, jobType, partitionIds);
            NDataflow dataflow = NDataflowManager.getInstance((KylinConfig)this.getConfig(), (String)this.getProject()).getDataflow(dataFlowId);
            if (needBuildSnapshots) {
                this.mergeSnapshotMeta(dataflow, buildResourceStore);
            }
            this.mergeTableExtMeta(dataflow, buildResourceStore);
            NDataLayout[] nDataLayoutArray = nDataLayouts;
            return nDataLayoutArray;
        }
    }
}

