/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job.stage.optimize;

import io.delta.tables.DeltaTable$;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.kylin.engine.spark.application.SparkApplication;
import org.apache.kylin.engine.spark.job.LayoutDataOptimizeJob;
import org.apache.kylin.engine.spark.job.SegmentExec;
import org.apache.kylin.engine.spark.job.stage.optimize.LayoutOptimizeExec;
import org.apache.kylin.engine.spark.job.stage.optimize.OptimizeExecutionContext$;
import org.apache.kylin.engine.spark.job.step.StageExec;
import org.apache.kylin.guava30.shaded.common.util.concurrent.RateLimiter;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.metadata.cube.model.NDataLayoutDetails;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000194A\u0001C\u0005\u00015!AQ\u0005\u0001B\u0001B\u0003%a\u0005C\u0003+\u0001\u0011\u00051\u0006C\u0003/\u0001\u0011\u0005s\u0006C\u0003<\u0001\u0011\u0005C\bC\u0003D\u0001\u0011\u0005C\tC\u0003I\u0001\u0011%\u0011\nC\u0003j\u0001\u0011\u0005#N\u0001\u000fMCf|W\u000f\u001e#bi\u0006\u001cu.\u001c9bGRLwN\\(qi&l\u0017N_3\u000b\u0005)Y\u0011\u0001C8qi&l\u0017N_3\u000b\u00051i\u0011!B:uC\u001e,'B\u0001\b\u0010\u0003\rQwN\u0019\u0006\u0003!E\tQa\u001d9be.T!AE\n\u0002\r\u0015tw-\u001b8f\u0015\t!R#A\u0003ls2LgN\u0003\u0002\u0017/\u00051\u0011\r]1dQ\u0016T\u0011\u0001G\u0001\u0004_J<7\u0001A\n\u0004\u0001m\t\u0003C\u0001\u000f \u001b\u0005i\"\"\u0001\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001j\"AB!osJ+g\r\u0005\u0002#G5\t\u0011\"\u0003\u0002%\u0013\t\u0011B*Y=pkR|\u0005\u000f^5nSj,W\t_3d\u0003Ua\u0017-_8vi\u0012\u000bG/Y(qi&l\u0017N_3K_\n\u0004\"a\n\u0015\u000e\u00035I!!K\u0007\u0003+1\u000b\u0017p\\;u\t\u0006$\u0018m\u00149uS6L'0\u001a&pE\u00061A(\u001b8jiz\"\"\u0001L\u0017\u0011\u0005\t\u0002\u0001\"B\u0013\u0003\u0001\u00041\u0013\u0001D4fiN#\u0018mZ3OC6,W#\u0001\u0019\u0011\u0005EBdB\u0001\u001a7!\t\u0019T$D\u00015\u0015\t)\u0014$\u0001\u0004=e>|GOP\u0005\u0003ou\ta\u0001\u0015:fI\u00164\u0017BA\u001d;\u0005\u0019\u0019FO]5oO*\u0011q'H\u0001\u000eO\u0016$(j\u001c2D_:$X\r\u001f;\u0016\u0003u\u0002\"AP!\u000e\u0003}R!\u0001Q\b\u0002\u0017\u0005\u0004\b\u000f\\5dCRLwN\\\u0005\u0003\u0005~\u0012\u0001c\u00159be.\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8\u0002\u000f\u0015DXmY;uKR\tQ\t\u0005\u0002\u001d\r&\u0011q)\b\u0002\u0005+:LG/\u0001\td_6\u0004\u0018m\u0019;j_:d\u0015-_8viR\u0011!*\u0018\t\u0003\u0017js!\u0001\u0014-\u000f\u00055;fB\u0001(W\u001d\tyUK\u0004\u0002Q):\u0011\u0011k\u0015\b\u0003gIK\u0011\u0001G\u0005\u0003-]I!\u0001F\u000b\n\u0005I\u0019\u0012B\u0001\t\u0012\u0013\tqq\"\u0003\u0002Z\u001b\u0005Y1+Z4nK:$X\t_3d\u0013\tYFL\u0001\rD_6\u0004\u0018m\u0019;j_:|\u0005\u000f^5nSj,'+Z:vYRT!!W\u0007\t\u000by3\u0001\u0019A0\u0002\u00191\f\u0017p\\;u\t\u0016$\u0018-\u001b7\u0011\u0005\u0001<W\"A1\u000b\u0005\t\u001c\u0017!B7pI\u0016d'B\u00013f\u0003\u0011\u0019WOY3\u000b\u0005\u0019\u001c\u0012\u0001C7fi\u0006$\u0017\r^1\n\u0005!\f'A\u0005(ECR\fG*Y=pkR$U\r^1jYN\fqaY1o'.L\u0007/F\u0001l!\taB.\u0003\u0002n;\t9!i\\8mK\u0006t\u0007")
public class LayoutDataCompactionOptimize
implements LayoutOptimizeExec {
    private final LayoutDataOptimizeJob layoutDataOptimizeJob;
    private LinkedBlockingQueue<Future<SegmentExec.ResultType>> pipe;
    private String stageId;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    @Override
    public <T> void drain(long timeout, TimeUnit unit) {
        LayoutOptimizeExec.drain$(this, timeout, unit);
    }

    @Override
    public <T> long drain$default$1() {
        return LayoutOptimizeExec.drain$default$1$(this);
    }

    @Override
    public <T> TimeUnit drain$default$2() {
        return LayoutOptimizeExec.drain$default$2$(this);
    }

    @Override
    public String getSegmentId() {
        return StageExec.getSegmentId$(this);
    }

    @Override
    public RateLimiter createRateLimiter(double permitsPerSecond) {
        return StageExec.createRateLimiter$(this, permitsPerSecond);
    }

    @Override
    public double createRateLimiter$default$1() {
        return StageExec.createRateLimiter$default$1$(this);
    }

    @Override
    public void onStageStart() {
        StageExec.onStageStart$(this);
    }

    @Override
    public void onStageFinished(ExecutableState state) {
        StageExec.onStageFinished$(this, state);
    }

    @Override
    public ExecutableState onStageFinished$default$1() {
        return StageExec.onStageFinished$default$1$(this);
    }

    @Override
    public void onStageSkipped() {
        StageExec.onStageSkipped$(this);
    }

    @Override
    public void updateStageInfo(String status, String errMsg, Map<String, String> updateInfo) {
        StageExec.updateStageInfo$(this, status, errMsg, updateInfo);
    }

    @Override
    public String getStageId() {
        return StageExec.getStageId$(this);
    }

    @Override
    public void setStageId(String stageId) {
        StageExec.setStageId$(this, stageId);
    }

    @Override
    public void doExecute() {
        StageExec.doExecute$(this);
    }

    @Override
    public void doExecuteWithoutFinally() {
        StageExec.doExecuteWithoutFinally$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    private LinkedBlockingQueue<Future<SegmentExec.ResultType>> pipe$lzycompute() {
        LayoutDataCompactionOptimize layoutDataCompactionOptimize = this;
        synchronized (layoutDataCompactionOptimize) {
            if (!this.bitmap$0) {
                this.pipe = LayoutOptimizeExec.pipe$(this);
                this.bitmap$0 = true;
            }
        }
        return this.pipe;
    }

    @Override
    public final LinkedBlockingQueue<Future<SegmentExec.ResultType>> pipe() {
        return !this.bitmap$0 ? this.pipe$lzycompute() : this.pipe;
    }

    @Override
    public String stageId() {
        return this.stageId;
    }

    @Override
    public void stageId_$eq(String x$1) {
        this.stageId = x$1;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String getStageName() {
        return "layout data compaction";
    }

    @Override
    public SparkApplication getJobContext() {
        return this.layoutDataOptimizeJob;
    }

    @Override
    public void execute() {
        if (!this.canSkip()) {
            ((List)this.layoutDataOptimizeJob.getLayoutDetails().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isCompactionAfterUpdate()))).foreach((Function1 & Serializable & scala.Serializable)layoutDetail -> BoxesRunTime.boxToBoolean((boolean)LayoutDataCompactionOptimize.$anonfun$execute$2(this, layoutDetail)));
            this.drain(this.drain$default$1(), this.drain$default$2());
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Skip stage layout compaction optimize ").append($this.layoutDataOptimizeJob.dataFlow().getModel().getId()).toString());
        }
    }

    private SegmentExec.CompactionOptimizeResult compactionLayout(NDataLayoutDetails layoutDetail) {
        String layoutTablePath = layoutDetail.getLocation();
        if (layoutDetail.getMaxCompactionFileSizeInBytes() > 0L) {
            this.getJobContext().getSparkSession().sessionState().conf().setLocalProperty("spark.databricks.delta.optimize.maxFileSize", Long.toString(layoutDetail.getMaxCompactionFileSizeInBytes()));
        }
        if (layoutDetail.getMinCompactionFileSizeInBytes() > 0L) {
            this.getJobContext().getSparkSession().sessionState().conf().setLocalProperty("spark.databricks.delta.optimize.minFileSize", Long.toString(layoutDetail.getMinCompactionFileSizeInBytes()));
        }
        String desc = new StringBuilder(33).append("Optimize compaction for layout {").append(layoutDetail.getLayoutId()).append("}").toString();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> desc);
        OptimizeExecutionContext$.MODULE$.setJobDesc(this.getJobContext().getSparkSession(), desc);
        DeltaTable$.MODULE$.forPath(layoutTablePath).optimize().executeCompaction();
        OptimizeExecutionContext$.MODULE$.cancelJobDesc(this.getJobContext().getSparkSession());
        return new SegmentExec.CompactionOptimizeResult(Predef$.MODULE$.long2Long(layoutDetail.getLayoutId()));
    }

    @Override
    public boolean canSkip() {
        return this.layoutDataOptimizeJob.getConfig().isV3SkipCompactionOptimize();
    }

    public static final /* synthetic */ boolean $anonfun$execute$2(LayoutDataCompactionOptimize $this, NDataLayoutDetails layoutDetail) {
        Future repartitionFuture = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> $this.compactionLayout(layoutDetail), (ExecutionContext)OptimizeExecutionContext$.MODULE$.futureExecutionContext());
        return $this.pipe().offer((Future<SegmentExec.ResultType>)repartitionFuture);
    }

    public LayoutDataCompactionOptimize(LayoutDataOptimizeJob layoutDataOptimizeJob) {
        this.layoutDataOptimizeJob = layoutDataOptimizeJob;
        Logging.$init$((Logging)this);
        StageExec.$init$(this);
        LayoutOptimizeExec.$init$(this);
    }
}

