/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.job.LogJobInfoUtils;
import org.apache.kylin.engine.spark.job.SegmentJob;
import org.apache.kylin.engine.spark.job.StageEnum;
import org.apache.kylin.engine.spark.job.StepExec;
import org.apache.kylin.engine.spark.job.step.StageExec;
import org.apache.kylin.guava30.shaded.common.base.Throwables;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.spark.tracker.AppStatusContext;

public class SegmentMergeJob
extends SegmentJob {
    @Override
    protected String generateInfo() {
        return LogJobInfoUtils.dfMergeJobInfo();
    }

    @Override
    protected final void doExecute() throws Exception {
        this.appStatusContext = new AppStatusContext(this.getSparkSession().sparkContext(), this.config);
        this.appStatusContext.appStatusTracker().startMonitorBuildResourceState();
        this.merge();
    }

    private void merge() throws IOException {
        Stream segmentStream = this.config.isSegmentParallelBuildEnabled() ? this.readOnlySegments.parallelStream() : this.readOnlySegments.stream();
        AtomicLong finishedSegmentCount = new AtomicLong(0L);
        int segmentsCount = this.readOnlySegments.size();
        segmentStream.forEach(seg -> {
            try (KylinConfig.SetAndUnsetThreadLocalConfig autoCloseConfig = KylinConfig.setAndUnsetThreadLocalConfig((KylinConfig)this.config);){
                String stepId = StringUtils.replace((String)this.infos.getJobStepId(), (String)"job_step_", (String)"");
                StepExec step = new StepExec(stepId);
                step.addStage(StageEnum.MERGE_FLAT_TABLE.createExec(this, (NDataSegment)seg));
                step.addStage(StageEnum.MERGE_INDICES.createExec(this, (NDataSegment)seg));
                step.doExecute();
                StageExec mergeColumnBytes = StageEnum.MERGE_COLUMN_BYTES.createExec(this, (NDataSegment)seg);
                step.addStage(mergeColumnBytes);
                mergeColumnBytes.doExecuteWithoutFinally();
                if (finishedSegmentCount.incrementAndGet() < (long)segmentsCount) {
                    mergeColumnBytes.onStageFinished(ExecutableState.SUCCEED);
                }
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
            }
        });
    }

    public static void main(String[] args) {
        SegmentMergeJob segmentMergeJob = new SegmentMergeJob();
        segmentMergeJob.execute(args);
    }
}

