/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.engine.spark.builder.SnapshotBuilder;
import org.apache.kylin.engine.spark.job.KylinBuildEnv;
import org.apache.kylin.engine.spark.job.LogJobInfoUtils;
import org.apache.kylin.engine.spark.job.SegmentJob;
import org.apache.kylin.engine.spark.job.StageEnum;
import org.apache.kylin.engine.spark.job.step.ParamPropagation;
import org.apache.kylin.engine.spark.job.step.StageExec;
import org.apache.kylin.engine.spark.job.step.build.BuildStepExec;
import org.apache.kylin.fileseg.FileSegments;
import org.apache.kylin.guava30.shaded.common.base.Throwables;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NDataflowUpdate;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.hive.utils.ResourceDetectUtils;
import org.apache.spark.tracker.AppStatusContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentBuildJob
extends SegmentJob {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SegmentBuildJob.class);
    private boolean usePlanner = false;

    public static void main(String[] args) {
        SegmentBuildJob segmentBuildJob = new SegmentBuildJob();
        segmentBuildJob.execute(args);
    }

    @Override
    protected String generateInfo() {
        return LogJobInfoUtils.dfBuildJobInfo();
    }

    @Override
    protected void waitForResourceSuccess() throws Exception {
        if (this.config.isBuildCheckPartitionColEnabled()) {
            this.checkDateFormatIfExist(this.project, this.dataflowId);
        }
        StageExec waitForResource = StageEnum.WAIT_FOR_RESOURCE.createExec(this);
        waitForResource.onStageFinished(ExecutableState.SUCCEED);
        this.infos.recordStageId("");
    }

    @Override
    protected final void extraInit() {
        super.extraInit();
        String enablePlanner = StringUtils.trim((String)this.getParam("enablePlanner"));
        if (StringUtils.equalsIgnoreCase((CharSequence)enablePlanner, (CharSequence)"true")) {
            this.usePlanner = true;
        }
    }

    @Override
    protected final void doExecute() throws Exception {
        StageEnum.REFRESH_SNAPSHOT.createThenExecute(this);
        this.appStatusContext = new AppStatusContext(this.getSparkSession().sparkContext(), this.config);
        this.appStatusContext.appStatusTracker().startMonitorBuildResourceState();
        Stream segmentStream = this.config.isSegmentParallelBuildEnabled() ? this.readOnlySegments.parallelStream() : this.readOnlySegments.stream();
        segmentStream.forEach(segment -> {
            try (KylinConfig.SetAndUnsetThreadLocalConfig autoCloseConfig = KylinConfig.setAndUnsetThreadLocalConfig((KylinConfig)this.config);){
                this.infos.clearCuboidsNumPerLayer(segment.getId());
                String stepId = StringUtils.replace((String)this.infos.getJobStepId(), (String)"job_step_", (String)"");
                BuildStepExec step = new BuildStepExec(stepId);
                ParamPropagation params = new ParamPropagation();
                step.addStage(StageEnum.MATERIALIZE_FACT_VIEW.createExec(this, (NDataSegment)segment, params));
                step.addStage(StageEnum.BUILD_GLOBAL_DICT.createExec(this, (NDataSegment)segment, params));
                step.addStage(StageEnum.MATERIALIZE_FLAT_TABLE.createExec(this, (NDataSegment)segment, params));
                if (this.usePlanner) {
                    step.addStage(StageEnum.COST_BASED_PLANNER.createExec(this, (NDataSegment)segment, params));
                }
                step.addStage(StageEnum.BUILD_FLAT_TABLE_STATS.createExec(this, (NDataSegment)segment, params));
                step.addStage(StageEnum.BUILD_LAYER.createExec(this, (NDataSegment)segment, params));
                step.addStage(StageEnum.REFRESH_COLUMN_BYTES.createExec(this, (NDataSegment)segment, params));
                if (StringUtils.equals((CharSequence)KylinBuildEnv.get().buildJobInfos().getSegmentId(), (CharSequence)segment.getId())) {
                    log.info("Segment[{}] build failed, rebuild with new parms", (Object)segment.getId());
                    segment.setExtraBuildOptions(KylinBuildEnv.get().buildJobInfos().getJobRetryInfosForSegmentParam());
                }
                step.doExecute();
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
            }
            finally {
                FileSegments.clearFileSegFilterLocally();
            }
        });
        this.updateSegmentSourceBytesSize();
    }

    @Override
    protected final String calculateRequiredCores() throws Exception {
        if (this.config.isSparkEngineTaskImpactInstanceEnabled()) {
            String maxLeafTasksNums = this.maxLeafTasksNums();
            int factor = this.config.getSparkEngineTaskCoreFactor();
            int requiredCore = (int)Double.parseDouble(maxLeafTasksNums) / factor;
            log.info("The maximum number of tasks required to run the job is {}, require cores: {}", (Object)maxLeafTasksNums, (Object)requiredCore);
            return String.valueOf(requiredCore);
        }
        return "1";
    }

    private String maxLeafTasksNums() throws IOException {
        if (Objects.isNull(this.rdSharedPath)) {
            this.rdSharedPath = this.config.getJobTmpShareDir(this.project, this.jobId);
        }
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        FileStatus[] fileStatuses = fs.listStatus(this.rdSharedPath, path -> path.toString().endsWith(ResourceDetectUtils.cubingDetectItemFileSuffix()));
        return ResourceDetectUtils.selectMaxValueInFiles((FileStatus[])fileStatuses);
    }

    public void refreshSnapshot(StageExec stageExec) throws Exception {
        SnapshotBuilder snapshotBuilder = new SnapshotBuilder(this.getJobId());
        if (this.config.isSnapshotManualManagementEnabled()) {
            log.info("Skip snapshot build in snapshot manual mode, dataflow: {}, only calculate total rows", (Object)this.dataflowId);
            snapshotBuilder.calculateTotalRows(this.getSparkSession(), this.getDataflow(this.dataflowId).getModel(), this.getIgnoredSnapshotTables());
            stageExec.onStageSkipped();
            return;
        }
        if (!this.needBuildSnapshots()) {
            log.info("Skip snapshot build, dataflow {}, only calculate total rows", (Object)this.dataflowId);
            snapshotBuilder.calculateTotalRows(this.getSparkSession(), this.getDataflow(this.dataflowId).getModel(), this.getIgnoredSnapshotTables());
            stageExec.onStageSkipped();
            return;
        }
        log.info("Refresh snapshot start.");
        snapshotBuilder.buildSnapshot(this.getSparkSession(), this.getDataflow(this.dataflowId).getModel(), this.getIgnoredSnapshotTables());
        if (this.config.isSnapshotSpecifiedSparkConf()) {
            log.info("exchange sparkSession using maintained sparkConf");
            this.exchangeSparkSession();
        }
        log.info("Refresh snapshot complete.");
    }

    private void updateSegmentSourceBytesSize() {
        Map segmentSourceSize = ResourceDetectUtils.getSegmentSourceSize((Path)this.rdSharedPath);
        UnitOfWork.doInTransactionWithRetry(() -> {
            NDataflowManager dataflowManager = NDataflowManager.getInstance((KylinConfig)this.config, (String)this.project);
            NDataflow dataflow = dataflowManager.getDataflow(this.dataflowId);
            NDataflowUpdate update = new NDataflowUpdate(dataflow.getUuid());
            ArrayList nDataSegments = Lists.newArrayList();
            for (Map.Entry entry : segmentSourceSize.entrySet()) {
                NDataSegment segment = dataflow.getSegment((String)entry.getKey()).copy();
                segment.setSourceBytesSize(((Long)entry.getValue()).longValue());
                nDataSegments.add(segment);
            }
            update.setToUpdateSegs(nDataSegments.toArray(new NDataSegment[0]));
            dataflowManager.updateDataflow(update);
            NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)this.config, (String)this.project);
            indexPlanManager.updateIndexPlan(this.dataflowId, copyForWrite -> copyForWrite.setLayoutBucketNumMapping(indexPlanManager.getIndexPlan(this.dataflowId).getLayoutBucketNumMapping()));
            return null;
        }, (String)this.project);
    }

    @Override
    protected void addConcreteJobSparkConf(SparkConf sparkConf) throws JsonProcessingException {
        this.appendSparkConfOfIndexPlanner(sparkConf);
    }
}

