/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import io.delta.tables.ClickhouseTable;
import io.delta.tables.DeltaTable;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.engine.spark.builder.InternalTableLoader;
import org.apache.kylin.engine.spark.job.InternalTableLoadJob;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.job.JobContext;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultExecutableOnTable;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.table.InternalTableDesc;
import org.apache.kylin.metadata.table.InternalTableManager;
import org.apache.kylin.metadata.table.InternalTablePartition;
import org.apache.kylin.metadata.table.InternalTablePartitionDetail;
import org.apache.kylin.util.DataRangeUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalTableUpdateMetadataStep
extends AbstractExecutable {
    private static final Logger logger = LoggerFactory.getLogger(InternalTableUpdateMetadataStep.class);

    public InternalTableUpdateMetadataStep() {
        this.setName("Update Metadata");
    }

    public InternalTableUpdateMetadataStep(Object notSetId) {
        super(notSetId);
    }

    protected ExecuteResult doWork(JobContext context) throws ExecuteException {
        AbstractExecutable parent = this.getParent();
        Preconditions.checkArgument((boolean)(parent instanceof DefaultExecutableOnTable));
        try {
            this.updateInternalTableMetadata();
            return ExecuteResult.createSucceed();
        }
        catch (Throwable throwable) {
            logger.warn("update internal table metadata failed.", throwable);
            return ExecuteResult.createError((Throwable)throwable);
        }
    }

    private void updateInternalTableMetadata() {
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            long startTime = System.currentTimeMillis();
            KylinConfig config = this.getConfig();
            SparkSession ss = (SparkSession)SparkSession.getDefaultSession().get();
            String tableName = this.getParam("table");
            String project = this.getParam("project");
            String startDate = this.getParam("startTime");
            String endDate = this.getParam("endTime");
            InternalTableManager internalTableManager = InternalTableManager.getInstance((KylinConfig)config, (String)project);
            InternalTableDesc internalTable = internalTableManager.getInternalTableDesc(tableName);
            this.extractPartitionDetails(ss, internalTable);
            InternalTablePartition tablePartition = internalTable.getTablePartition();
            InternalTableLoadJob.InternalTableMetaUpdateInfo info = this.extractUpdateInfo(project, tableName, config, ss);
            if (tablePartition != null) {
                tablePartition.setPartitionValues(info.getPartitionValues());
                tablePartition.setPartitionDetails(info.getPartitionDetails());
            }
            internalTable.setRowCount(info.getFinalCount());
            logger.info("starting merging delta partitions");
            if (null != tablePartition && StringUtils.isNotEmpty((CharSequence)tablePartition.getDatePartitionFormat())) {
                List partitionRange = DataRangeUtils.mergeTimeRange((List)tablePartition.getPartitionValues(), (String)tablePartition.getDatePartitionFormat());
                internalTable.setPartitionRange(partitionRange);
            }
            String[] curJobRange = new String[]{"0", "0"};
            if (null != tablePartition && StringUtils.isNotEmpty((CharSequence)tablePartition.getDatePartitionFormat()) && StringUtils.isNotEmpty((CharSequence)startDate)) {
                SimpleDateFormat fmt = new SimpleDateFormat(tablePartition.getDatePartitionFormat(), Locale.ROOT);
                curJobRange = new String[]{fmt.format(Long.parseLong(startDate)), fmt.format(Long.parseLong(endDate))};
            }
            List jobRange = internalTable.getJobRange();
            String[] finalCurJobRange = curJobRange;
            jobRange.removeIf(rang -> rang[0].equals(finalCurJobRange[0]) && rang[1].equals(finalCurJobRange[1]));
            internalTable.setJobRange(jobRange);
            logger.info("trying to release job_range for internal table {} , range {}.", (Object)internalTable.getTableDesc().getTableAlias(), (Object)jobRange);
            internalTableManager.saveOrUpdateInternalTable(internalTable);
            logger.info("update metadata for internal table {} cost: {} ms.", (Object)internalTable.getTableDesc().getTableAlias(), (Object)(System.currentTimeMillis() - startTime));
            return true;
        }, (String)this.project);
    }

    public InternalTableLoadJob.InternalTableMetaUpdateInfo extractUpdateInfo(String project, String tableName, KylinConfig config, SparkSession ss) {
        InternalTableManager internalTableManager = InternalTableManager.getInstance((KylinConfig)config, (String)project);
        InternalTableDesc internalTable = internalTableManager.getInternalTableDesc(tableName);
        long count = this.getInternalTableCount(internalTable, ss);
        List<Object> partitionDetails = internalTable.getTablePartition() != null ? this.extractPartitionDetails(ss, internalTable) : Collections.emptyList();
        if (!partitionDetails.isEmpty()) {
            partitionDetails.sort(Comparator.comparing(InternalTablePartitionDetail::getPartitionValue));
        }
        logger.info("update internal table meta data : row count:{}, partition size:{}", (Object)count, (Object)partitionDetails.size());
        List<String> finalPartitionValues = partitionDetails.stream().map(InternalTablePartitionDetail::getPartitionValue).collect(Collectors.toList());
        return new InternalTableLoadJob.InternalTableMetaUpdateInfo(count, finalPartitionValues, partitionDetails);
    }

    @VisibleForTesting
    public long getInternalTableCount(InternalTableDesc internalTable, SparkSession ss) {
        switch (internalTable.getStorageType()) {
            case PARQUET: {
                return ss.read().format(internalTable.getStorageType().getFormat()).load(internalTable.getLocation()).count();
            }
            case GLUTEN: {
                return ClickhouseTable.forPath((SparkSession)ss, (String)internalTable.getLocation()).toDF().count();
            }
            case DELTALAKE: {
                return DeltaTable.forPath((SparkSession)ss, (String)internalTable.getLocation()).toDF().count();
            }
        }
        return 0L;
    }

    public List<InternalTablePartitionDetail> extractPartitionDetails(SparkSession ss, InternalTableDesc internalTable) {
        long startTime = System.currentTimeMillis();
        if (Objects.isNull(internalTable.getTablePartition())) {
            return Collections.emptyList();
        }
        String partitionCol = internalTable.getTablePartition().getPartitionColumns()[0];
        ArrayList<InternalTablePartitionDetail> partitionDetails = new ArrayList<InternalTablePartitionDetail>();
        if (internalTable.getStorageType() == InternalTableDesc.StorageType.PARQUET) {
            try {
                Dataset internalTableDs = ss.read().format(internalTable.getStorageType().getFormat()).load(internalTable.getLocation());
                Dataset partitionInfo = internalTableDs.select(partitionCol, new String[0]).distinct();
                List partitionValues = partitionInfo.collectAsList().stream().map(row -> row.get(0)).map(Object::toString).collect(Collectors.toList());
                FileSystem fs = HadoopUtil.getWorkingFileSystem();
                for (String partitionValue : partitionValues) {
                    String subPath = partitionCol + "=" + partitionValue;
                    Path partitionsPath = new Path(internalTable.getLocation(), subPath);
                    long storageSize = this.getStorageSizeWithoutException(fs, partitionsPath, subPath);
                    InternalTablePartitionDetail detail = new InternalTablePartitionDetail();
                    detail.setSizeInBytes(storageSize);
                    detail.setStoragePath(partitionsPath.toString());
                    detail.setPartitionValue(partitionValue);
                    partitionDetails.add(detail);
                }
            }
            catch (Exception e) {
                logger.warn("Can not get parquet info from internal table path {} caused by:", (Object)internalTable.getLocation(), (Object)e);
            }
        } else {
            Row[] partitionInfos;
            ArrayList<String> partitionValues = new ArrayList<String>();
            InternalTableLoader loader = new InternalTableLoader();
            for (Row row2 : partitionInfos = loader.getPartitionInfos(ss, internalTable)) {
                InternalTablePartitionDetail detail = new InternalTablePartitionDetail();
                String partitionValue = row2.getString(0);
                long partitionStorageSize = row2.getLong(1);
                long fileSize = row2.getLong(2);
                String subPath = partitionCol + "=" + partitionValue;
                Path partitionsPath = new Path(internalTable.getLocation(), subPath);
                partitionValues.add(partitionValue);
                detail.setSizeInBytes(partitionStorageSize);
                detail.setStoragePath(partitionsPath.toString());
                detail.setFileCount(fileSize);
                detail.setPartitionValue(partitionValue);
                partitionDetails.add(detail);
            }
        }
        logger.info("[ UPDATE_INTERNAL_TABLE] extract partitions from delta table cost {} ms", (Object)(System.currentTimeMillis() - startTime));
        return partitionDetails;
    }

    private long getStorageSizeWithoutException(FileSystem fs, Path partitionsPath, String subPath) {
        try {
            return HadoopUtil.getContentSummary((FileSystem)fs, (Path)partitionsPath).getLength();
        }
        catch (IOException e) {
            logger.warn("failed to get size of path {}", (Object)subPath, (Object)e);
            return -1L;
        }
    }
}

