/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.builder;

import java.util.Set;

public interface TreeNode<T extends TreeNode> {
    public T getRootNode();

    public Set<T> getParents(boolean var1);

    public Set<T> getChildren(boolean var1);

    public int getDepth();

    public void addAsChild(T var1, boolean var2);

    public void removeChild(T var1, boolean var2);

    public boolean isChildOf(T var1);

    public boolean isParentOf(T var1);

    public String getSimpleString();

    public String getDetailString();

    default public void getTreePrint(int depth, StringBuilder builder, String prefix, boolean simple, int indent) {
        for (int countIndent = 0; depth * indent > countIndent; ++countIndent) {
            builder.append(' ');
        }
        if (prefix != null) {
            builder.append(prefix);
        }
        if (simple) {
            builder.append(this.getSimpleString());
        } else {
            builder.append(this.getDetailString());
        }
        builder.append('\n');
        if (this.getChildren(false) != null) {
            this.getChildren(false).stream().forEach(child -> child.getTreePrint(depth + 1, builder, prefix, simple, indent));
        }
    }
}

