/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.TaskContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.shuffle.MergedBlockMeta;
import org.apache.spark.shuffle.BaseShuffleHandle;
import org.apache.spark.shuffle.ShuffleBlockResolver;
import org.apache.spark.shuffle.ShuffleHandle;
import org.apache.spark.shuffle.ShuffleManager;
import org.apache.spark.shuffle.ShuffleManagerLookup;
import org.apache.spark.shuffle.ShuffleReadMetricsReporter;
import org.apache.spark.shuffle.ShuffleReader;
import org.apache.spark.shuffle.ShuffleWriteMetricsReporter;
import org.apache.spark.shuffle.ShuffleWriter;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.ShuffleBlockBatchId;
import org.apache.spark.storage.ShuffleBlockId;
import org.apache.spark.storage.ShuffleMergedBlockId;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\teb\u0001\u0002\u0012$\t1B\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\u0006\u0003\u0002!\tA\u0011\u0005\b\u000b\u0002\u0011\r\u0011\"\u0003G\u0011\u0019q\u0006\u0001)A\u0005\u000f\"I\u0011q\u0010\u0001C\u0002\u0013%\u0011\u0011\u0011\u0005\t\u0003\u000b\u0003\u0001\u0015!\u0003\u0002\u0004\"9\u0011q\u0011\u0001\u0005B\u0005%\u0005bBAb\u0001\u0011\u0005\u0013Q\u0019\u0005\b\u0003s\u0004A\u0011IA~\u0011\u001d\u0011I\u0003\u0001C!\u0005WAqAa\f\u0001\t\u0003\u0012\t\u0004\u0003\u0004\u0002~\u0001!\t\u0005\u001e\u0005\b\u0005g\u0001A\u0011\u0002B\u001b\u000f\u0015I5\u0005#\u0003K\r\u0015\u00113\u0005#\u0003L\u0011\u0015\tu\u0002\"\u0001M\r\u0011iu\u0002\u0002(\t\u000b\u0005\u000bB\u0011A(\t\u000f\u0015\u000b\"\u0019!C\u0005%\"1a,\u0005Q\u0001\nMCQaX\t\u0005\u0002\u0001DQAZ\t\u0005\u0002\u001dDQa[\t\u0005\u00021DQA\\\t\u0005\u0002=DQ!]\t\u0005\u0002IDQa]\t\u0005\u0002Q4A\u0001_\b\u0005s\"AQi\u0007B\u0001B\u0003%\u0001\u000bC\u0003B7\u0011\u0005Q\u0010C\u0004\u0002\u0002m!\t%a\u0001\t\u000f\u0005-3\u0004\"\u0011\u0002N!9\u00111N\u000e\u0005B\u00055\u0004BBA?7\u0011\u0005CO\u0001\u000bTQV4g\r\\3NC:\fw-\u001a:S_V$XM\u001d\u0006\u0003I\u0015\nqa\u001d5vM\u001adWM\u0003\u0002'O\u0005)1\u000f]1sW*\u0011\u0001&K\u0001\u0007CB\f7\r[3\u000b\u0003)\n1a\u001c:h\u0007\u0001\u0019B\u0001A\u00174oA\u0011a&M\u0007\u0002_)\t\u0001'A\u0003tG\u0006d\u0017-\u0003\u00023_\t1\u0011I\\=SK\u001a\u0004\"\u0001N\u001b\u000e\u0003\rJ!AN\u0012\u0003\u001dMCWO\u001a4mK6\u000bg.Y4feB\u0011\u0001hO\u0007\u0002s)\u0011!(J\u0001\tS:$XM\u001d8bY&\u0011A(\u000f\u0002\b\u0019><w-\u001b8h\u0003\u0019awn\\6vaB\u0011AgP\u0005\u0003\u0001\u000e\u0012Ac\u00155vM\u001adW-T1oC\u001e,'\u000fT8pWV\u0004\u0018A\u0002\u001fj]&$h\b\u0006\u0002D\tB\u0011A\u0007\u0001\u0005\u0006{\t\u0001\rAP\u0001\u0006G\u0006\u001c\u0007.Z\u000b\u0002\u000fB\u0011\u0001*\u0005\b\u0003i9\tAc\u00155vM\u001adW-T1oC\u001e,'OU8vi\u0016\u0014\bC\u0001\u001b\u0010'\tyQ\u0006F\u0001K\u0005\u0015\u0019\u0015m\u00195f'\t\tR\u0006F\u0001Q!\t\t\u0016#D\u0001\u0010+\u0005\u0019\u0006\u0003\u0002+Z7Nj\u0011!\u0016\u0006\u0003-^\u000bA!\u001e;jY*\t\u0001,\u0001\u0003kCZ\f\u0017B\u0001.V\u0005\ri\u0015\r\u001d\t\u0003]qK!!X\u0018\u0003\u0007%sG/\u0001\u0004dC\u000eDW\rI\u0001\u0004Q\u0006\u001cHCA1e!\tq#-\u0003\u0002d_\t9!i\\8mK\u0006t\u0007\"B3\u0016\u0001\u0004Y\u0016!C:ik\u001a4G.Z%e\u0003\u0015\u0019Ho\u001c:f)\r\u0019\u0004.\u001b\u0005\u0006KZ\u0001\ra\u0017\u0005\u0006UZ\u0001\raM\u0001\b[\u0006t\u0017mZ3s\u0003\r9W\r\u001e\u000b\u0003g5DQ!Z\fA\u0002m\u000baA]3n_Z,GCA\u001aq\u0011\u0015)\u0007\u00041\u0001\\\u0003\u0011\u0019\u0018N_3\u0015\u0003m\u000bQa\u00197fCJ$\u0012!\u001e\t\u0003]YL!a^\u0018\u0003\tUs\u0017\u000e\u001e\u0002\u000e\u00052|7m\u001b*fg>dg/\u001a:\u0014\u0007mi#\u0010\u0005\u00025w&\u0011Ap\t\u0002\u0015'\",hM\u001a7f\u00052|7m\u001b*fg>dg/\u001a:\u0015\u0005y|\bCA)\u001c\u0011\u0015)U\u00041\u0001Q\u000319W\r\u001e\"m_\u000e\\G)\u0019;b)\u0019\t)!!\u0006\u0002&A!\u0011qAA\t\u001b\t\tIA\u0003\u0003\u0002\f\u00055\u0011A\u00022vM\u001a,'OC\u0002\u0002\u0010\u0015\nqA\\3uo>\u00148.\u0003\u0003\u0002\u0014\u0005%!!D'b]\u0006<W\r\u001a\"vM\u001a,'\u000fC\u0004\u0002\u0018y\u0001\r!!\u0007\u0002\u000f\tdwnY6JIB!\u00111DA\u0011\u001b\t\tiBC\u0002\u0002 \u0015\nqa\u001d;pe\u0006<W-\u0003\u0003\u0002$\u0005u!a\u0002\"m_\u000e\\\u0017\n\u001a\u0005\n\u0003Oq\u0002\u0013!a\u0001\u0003S\tA\u0001Z5sgB)a&a\u000b\u00020%\u0019\u0011QF\u0018\u0003\r=\u0003H/[8o!\u0015q\u0013\u0011GA\u001b\u0013\r\t\u0019d\f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0003o\t)E\u0004\u0003\u0002:\u0005\u0005\u0003cAA\u001e_5\u0011\u0011Q\b\u0006\u0004\u0003\u007fY\u0013A\u0002\u001fs_>$h(C\u0002\u0002D=\na\u0001\u0015:fI\u00164\u0017\u0002BA$\u0003\u0013\u0012aa\u0015;sS:<'bAA\"_\u0005\u0011r-\u001a;NKJ<W\r\u001a\"m_\u000e\\G)\u0019;b)\u0019\ty%!\u0019\u0002jA1\u0011\u0011KA.\u0003\u000bqA!a\u0015\u0002X9!\u00111HA+\u0013\u0005\u0001\u0014bAA-_\u00059\u0001/Y2lC\u001e,\u0017\u0002BA/\u0003?\u00121aU3r\u0015\r\tIf\f\u0005\b\u0003/y\u0002\u0019AA2!\u0011\tY\"!\u001a\n\t\u0005\u001d\u0014Q\u0004\u0002\u0015'\",hM\u001a7f\u001b\u0016\u0014x-\u001a3CY>\u001c7.\u00133\t\u000f\u0005\u001dr\u00041\u0001\u0002*\u0005\u0011r-\u001a;NKJ<W\r\u001a\"m_\u000e\\W*\u001a;b)\u0019\ty'!\u001f\u0002|A!\u0011\u0011OA;\u001b\t\t\u0019HC\u0002%\u0003\u001bIA!a\u001e\u0002t\tyQ*\u001a:hK\u0012\u0014En\\2l\u001b\u0016$\u0018\rC\u0004\u0002\u0018\u0001\u0002\r!a\u0019\t\u000f\u0005\u001d\u0002\u00051\u0001\u0002*\u0005!1\u000f^8q\u0003!\u0011Xm]8mm\u0016\u0014XCAAB!\tA5$A\u0005sKN|GN^3sA\u0005y!/Z4jgR,'o\u00155vM\u001adW-\u0006\u0005\u0002\f\u0006\u0015\u0016\u0011XA`)\u0019\ti)a%\u0002\u0016B\u0019A'a$\n\u0007\u0005E5EA\u0007TQV4g\r\\3IC:$G.\u001a\u0005\u0006K\u001e\u0001\ra\u0017\u0005\b\u0003/;\u0001\u0019AAM\u0003)!W\r]3oI\u0016t7-\u001f\t\u000b\u00037\u000bi*!)\u00028\u0006uV\"A\u0013\n\u0007\u0005}UEA\tTQV4g\r\\3EKB,g\u000eZ3oGf\u0004B!a)\u0002&2\u0001AaBAT\u000f\t\u0007\u0011\u0011\u0016\u0002\u0002\u0017F!\u00111VAY!\rq\u0013QV\u0005\u0004\u0003_{#a\u0002(pi\"Lgn\u001a\t\u0004]\u0005M\u0016bAA[_\t\u0019\u0011I\\=\u0011\t\u0005\r\u0016\u0011\u0018\u0003\b\u0003w;!\u0019AAU\u0005\u00051\u0006\u0003BAR\u0003\u007f#q!!1\b\u0005\u0004\tIKA\u0001D\u0003%9W\r^,sSR,'/\u0006\u0004\u0002H\u0006E\u0017Q\u001b\u000b\u000b\u0003\u0013\f9.a7\u0002f\u0006=\bc\u0002\u001b\u0002L\u0006=\u00171[\u0005\u0004\u0003\u001b\u001c#!D*ik\u001a4G.Z,sSR,'\u000f\u0005\u0003\u0002$\u0006EGaBAT\u0011\t\u0007\u0011\u0011\u0016\t\u0005\u0003G\u000b)\u000eB\u0004\u0002<\"\u0011\r!!+\t\u000f\u0005e\u0007\u00021\u0001\u0002\u000e\u00061\u0001.\u00198eY\u0016Dq!!8\t\u0001\u0004\ty.A\u0003nCBLE\rE\u0002/\u0003CL1!a90\u0005\u0011auN\\4\t\u000f\u0005\u001d\b\u00021\u0001\u0002j\u000691m\u001c8uKb$\b\u0003BAN\u0003WL1!!<&\u0005-!\u0016m]6D_:$X\r\u001f;\t\u000f\u0005E\b\u00021\u0001\u0002t\u00069Q.\u001a;sS\u000e\u001c\bc\u0001\u001b\u0002v&\u0019\u0011q_\u0012\u00037MCWO\u001a4mK^\u0013\u0018\u000e^3NKR\u0014\u0018nY:SKB|'\u000f^3s\u0003%9W\r\u001e*fC\u0012,'/\u0006\u0004\u0002~\n\u001d!1\u0002\u000b\u0011\u0003\u007f\u0014iAa\u0004\u0003\u0014\t]!1\u0004B\u0010\u0005C\u0001r\u0001\u000eB\u0001\u0005\u000b\u0011I!C\u0002\u0003\u0004\r\u0012Qb\u00155vM\u001adWMU3bI\u0016\u0014\b\u0003BAR\u0005\u000f!q!a*\n\u0005\u0004\tI\u000b\u0005\u0003\u0002$\n-AaBAa\u0013\t\u0007\u0011\u0011\u0016\u0005\b\u00033L\u0001\u0019AAG\u0011\u0019\u0011\t\"\u0003a\u00017\u0006i1\u000f^1si6\u000b\u0007/\u00138eKbDaA!\u0006\n\u0001\u0004Y\u0016aC3oI6\u000b\u0007/\u00138eKbDaA!\u0007\n\u0001\u0004Y\u0016AD:uCJ$\b+\u0019:uSRLwN\u001c\u0005\u0007\u0005;I\u0001\u0019A.\u0002\u0019\u0015tG\rU1si&$\u0018n\u001c8\t\u000f\u0005\u001d\u0018\u00021\u0001\u0002j\"9\u0011\u0011_\u0005A\u0002\t\r\u0002c\u0001\u001b\u0003&%\u0019!qE\u0012\u00035MCWO\u001a4mKJ+\u0017\rZ'fiJL7m\u001d*fa>\u0014H/\u001a:\u0002#Ut'/Z4jgR,'o\u00155vM\u001adW\rF\u0002b\u0005[AQ!\u001a\u0006A\u0002m\u000bAc\u001d5vM\u001adWM\u00117pG.\u0014Vm]8mm\u0016\u0014X#\u0001>\u0002=\u0015t7/\u001e:f'\",hM\u001a7f\u001b\u0006t\u0017mZ3s%\u0016<\u0017n\u001d;fe\u0016$GcA;\u00038!9\u0011\u0011\\\u0007A\u0002\u00055\u0005")
public class ShuffleManagerRouter
implements ShuffleManager,
Logging {
    private final ShuffleManagerLookup lookup;
    private final Cache cache;
    private final BlockResolver resolver;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public final <K, C> ShuffleReader<K, C> getReader(ShuffleHandle handle, int startPartition, int endPartition, TaskContext context, ShuffleReadMetricsReporter metrics) {
        return ShuffleManager.getReader$((ShuffleManager)this, (ShuffleHandle)handle, (int)startPartition, (int)endPartition, (TaskContext)context, (ShuffleReadMetricsReporter)metrics);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Cache cache() {
        return this.cache;
    }

    private BlockResolver resolver() {
        return this.resolver;
    }

    public <K, V, C> ShuffleHandle registerShuffle(int shuffleId, ShuffleDependency<K, V, C> dependency) {
        ShuffleManager manager = this.lookup.findShuffleManager(dependency);
        return this.cache().store(shuffleId, manager).registerShuffle(shuffleId, dependency);
    }

    public <K, V> ShuffleWriter<K, V> getWriter(ShuffleHandle handle, long mapId, TaskContext context, ShuffleWriteMetricsReporter metrics) {
        this.ensureShuffleManagerRegistered(handle);
        return this.cache().get(handle.shuffleId()).getWriter(handle, mapId, context, metrics);
    }

    public <K, C> ShuffleReader<K, C> getReader(ShuffleHandle handle, int startMapIndex, int endMapIndex, int startPartition, int endPartition, TaskContext context, ShuffleReadMetricsReporter metrics) {
        this.ensureShuffleManagerRegistered(handle);
        return this.cache().get(handle.shuffleId()).getReader(handle, startMapIndex, endMapIndex, startPartition, endPartition, context, metrics);
    }

    public boolean unregisterShuffle(int shuffleId) {
        return this.cache().remove(shuffleId).unregisterShuffle(shuffleId);
    }

    public ShuffleBlockResolver shuffleBlockResolver() {
        return this.resolver();
    }

    public void stop() {
        if (this.cache().size() != 0) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(108).append("Shuffle router cache is not empty when being stopped. This might be because the ").append("shuffle is not unregistered.").toString());
        }
        this.lookup.all().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.stop();
            return BoxedUnit.UNIT;
        });
    }

    private void ensureShuffleManagerRegistered(ShuffleHandle handle) {
        BaseShuffleHandle baseShuffleHandle;
        ShuffleHandle shuffleHandle = handle;
        if (!(shuffleHandle instanceof BaseShuffleHandle)) {
            throw new UnsupportedOperationException(new StringBuilder(71).append(handle.getClass()).append(" is not a BaseShuffleHandle so is not supported by ").append("GlutenShuffleManager").toString());
        }
        BaseShuffleHandle baseShuffleHandle2 = baseShuffleHandle = (BaseShuffleHandle)shuffleHandle;
        BaseShuffleHandle baseShuffleHandle3 = baseShuffleHandle2;
        int shuffleId = baseShuffleHandle3.shuffleId();
        if (this.cache().has(shuffleId)) {
            return;
        }
        ShuffleDependency dependency = baseShuffleHandle3.dependency();
        ShuffleManager manager = this.lookup.findShuffleManager(dependency);
        this.cache().store(shuffleId, manager);
    }

    public ShuffleManagerRouter(ShuffleManagerLookup lookup) {
        this.lookup = lookup;
        ShuffleManager.$init$((ShuffleManager)this);
        Logging.$init$((Logging)this);
        this.cache = new Cache();
        this.resolver = new BlockResolver(this.cache());
    }

    private static class BlockResolver
    implements ShuffleBlockResolver {
        private final Cache cache;

        public Option<String[]> getBlockData$default$2() {
            return ShuffleBlockResolver.getBlockData$default$2$((ShuffleBlockResolver)this);
        }

        public Seq<BlockId> getBlocksForShuffle(int shuffleId, long mapId) {
            return ShuffleBlockResolver.getBlocksForShuffle$((ShuffleBlockResolver)this, (int)shuffleId, (long)mapId);
        }

        public ManagedBuffer getBlockData(BlockId blockId, Option<String[]> dirs) {
            int n;
            BlockId blockId2 = blockId;
            if (blockId2 instanceof ShuffleBlockId) {
                ShuffleBlockId shuffleBlockId = (ShuffleBlockId)blockId2;
                n = shuffleBlockId.shuffleId();
            } else if (blockId2 instanceof ShuffleBlockBatchId) {
                ShuffleBlockBatchId shuffleBlockBatchId = (ShuffleBlockBatchId)blockId2;
                n = shuffleBlockBatchId.shuffleId();
            } else {
                throw new IllegalArgumentException(new StringBuilder(52).append("GlutenShuffleManager: Unsupported shuffle block id: ").append(blockId).toString());
            }
            int shuffleId = n;
            return this.cache.get(shuffleId).shuffleBlockResolver().getBlockData(blockId, dirs);
        }

        public Seq<ManagedBuffer> getMergedBlockData(ShuffleMergedBlockId blockId, Option<String[]> dirs) {
            int shuffleId = blockId.shuffleId();
            return this.cache.get(shuffleId).shuffleBlockResolver().getMergedBlockData(blockId, dirs);
        }

        public MergedBlockMeta getMergedBlockMeta(ShuffleMergedBlockId blockId, Option<String[]> dirs) {
            int shuffleId = blockId.shuffleId();
            return this.cache.get(shuffleId).shuffleBlockResolver().getMergedBlockMeta(blockId, dirs);
        }

        public void stop() {
            throw new UnsupportedOperationException(new StringBuilder(52).append("BlockResolver ").append(this.getClass().getSimpleName()).append(" doesn't need to be explicitly stopped").toString());
        }

        public BlockResolver(Cache cache) {
            this.cache = cache;
            ShuffleBlockResolver.$init$((ShuffleBlockResolver)this);
        }
    }

    private static class Cache {
        private final Map<Object, ShuffleManager> cache = new ConcurrentHashMap<Object, ShuffleManager>();

        private Map<Object, ShuffleManager> cache() {
            return this.cache;
        }

        public boolean has(int shuffleId) {
            return this.cache().containsKey(BoxesRunTime.boxToInteger((int)shuffleId));
        }

        public ShuffleManager store(int shuffleId, ShuffleManager manager) {
            return this.cache().compute(BoxesRunTime.boxToInteger((int)shuffleId), (id, m) -> Cache.$anonfun$store$1(manager, BoxesRunTime.unboxToInt((Object)id), m));
        }

        /*
         * WARNING - void declaration
         */
        public ShuffleManager get(int shuffleId) {
            void var2_2;
            ShuffleManager manager = this.cache().get(BoxesRunTime.boxToInteger((int)shuffleId));
            Predef$.MODULE$.assert(manager != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Shuffle manager not registered for shuffle id: ").append(shuffleId).toString());
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public ShuffleManager remove(int shuffleId) {
            void var2_2;
            ShuffleManager manager = this.cache().remove(BoxesRunTime.boxToInteger((int)shuffleId));
            Predef$.MODULE$.assert(manager != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Shuffle manager not registered for shuffle id: ").append(shuffleId).toString());
            return var2_2;
        }

        public int size() {
            return this.cache().size();
        }

        public void clear() {
            this.cache().clear();
        }

        public static final /* synthetic */ ShuffleManager $anonfun$store$1(ShuffleManager manager$1, int id, ShuffleManager m) {
            Predef$.MODULE$.assert(m == null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Shuffle manager was already cached for shuffle id: ").append(id).toString());
            return manager$1;
        }
    }
}

