/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.memory.memtarget.spark;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.gluten.config.GlutenConfig;
import org.apache.gluten.memory.memtarget.Spillers;
import org.apache.gluten.memory.memtarget.TreeMemoryTarget;
import org.apache.gluten.memory.memtarget.spark.TreeMemoryConsumer;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.util.Utils;

public final class TreeMemoryConsumers {
    private static final ReferenceMap FACTORIES = new ReferenceMap();

    private TreeMemoryConsumers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Factory factory(TaskMemoryManager tmm) {
        ReferenceMap referenceMap = FACTORIES;
        synchronized (referenceMap) {
            return (Factory)FACTORIES.computeIfAbsent((Object)tmm, m -> new Factory((TaskMemoryManager)m));
        }
    }

    public static class Factory {
        private final TreeMemoryConsumer sparkConsumer;
        private final Map<Long, TreeMemoryTarget> roots = new ConcurrentHashMap<Long, TreeMemoryTarget>();

        private Factory(TaskMemoryManager tmm) {
            this.sparkConsumer = new TreeMemoryConsumer(tmm);
        }

        private TreeMemoryTarget ofCapacity(long capacity) {
            return this.roots.computeIfAbsent(capacity, cap -> this.sparkConsumer.newChild(String.format("Capacity[%s]", Utils.bytesToString((long)cap)), (long)cap, Spillers.NOOP, Collections.emptyMap()));
        }

        public TreeMemoryTarget legacyRoot() {
            return this.ofCapacity(Long.MAX_VALUE);
        }

        public TreeMemoryTarget isolatedRoot() {
            return this.ofCapacity(GlutenConfig.get().conservativeTaskOffHeapMemorySize());
        }
    }
}

