/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller.v2;

import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.exception.CommonErrorCode;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.fileseg.FileSegments;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.model.TimeRange;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.request.CubeRebuildRequest;
import org.apache.kylin.rest.request.SegmentMgmtRequest;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.JobInfoResponse;
import org.apache.kylin.rest.response.JobInfoResponseV2;
import org.apache.kylin.rest.response.NDataModelResponse;
import org.apache.kylin.rest.response.NDataModelResponse3X;
import org.apache.kylin.rest.response.NDataSegmentResponse;
import org.apache.kylin.rest.service.ModelBuildService;
import org.apache.kylin.rest.service.ModelService;
import org.apache.kylin.rest.service.params.MergeSegmentParams;
import org.apache.kylin.rest.service.params.RefreshSegmentParams;
import org.apache.kylin.util.DataRangeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cubes"}, produces={"application/vnd.apache.kylin-v2+json"})
public class SegmentControllerV2
extends NBasicController {
    private static final String ENABLE_FILE_SEGMENTS = "ENABLE_FILE_SEGMENTS";
    @Autowired
    @Qualifier(value="modelService")
    private ModelService modelService;
    @Autowired
    @Qualifier(value="modelBuildService")
    private ModelBuildService modelBuildService;

    @ApiOperation(value="getCubes", tags={"AI"})
    @GetMapping(value={""})
    @ResponseBody
    public EnvelopeResponse<Map<String, Object>> getCubes(@RequestParam(value="projectName") String project, @RequestParam(value="modelName", required=false) String modelAlias, @RequestParam(value="pageOffset", required=false, defaultValue="0") Integer offset, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer limit) {
        this.checkProjectName(project);
        ArrayList modelsResponse = new ArrayList(this.modelService.getCubes(modelAlias, project));
        ArrayList<NDataModelResponse3X> result = new ArrayList<NDataModelResponse3X>();
        try {
            for (NDataModelResponse response : modelsResponse) {
                result.add(NDataModelResponse3X.convert((NDataModelResponse)response));
            }
        }
        catch (Exception e) {
            throw new KylinException((ErrorCodeSupplier)CommonErrorCode.FAILED_PARSE_JSON, (Throwable)e);
        }
        Map modelResponse = this.getDataResponse("cubes", result, offset, limit);
        return new EnvelopeResponse("000", (Object)modelResponse, "");
    }

    @ApiOperation(value="getCube", tags={"AI"})
    @GetMapping(value={"/{cubeName}"})
    @ResponseBody
    public EnvelopeResponse<NDataModelResponse3X> getCube(@PathVariable(value="cubeName") String modelAlias, @RequestParam(value="project", required=false) String project) {
        NDataModelResponse3X result;
        NDataModelResponse dataModelResponse = this.modelService.getCube(modelAlias, project);
        if (Objects.isNull(dataModelResponse)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.CUBE_NOT_EXIST, new Object[0]);
        }
        try {
            result = NDataModelResponse3X.convert((NDataModelResponse)dataModelResponse);
        }
        catch (Exception e) {
            throw new KylinException((ErrorCodeSupplier)CommonErrorCode.FAILED_PARSE_JSON, (Throwable)e);
        }
        return new EnvelopeResponse("000", (Object)result, "");
    }

    @ApiOperation(value="rebuild", tags={"DW"})
    @PutMapping(value={"/{cubeName}/rebuild"})
    @ResponseBody
    public EnvelopeResponse<JobInfoResponseV2> rebuild(@PathVariable(value="cubeName") String modelAlias, @RequestParam(value="project", required=false) String project, @RequestBody CubeRebuildRequest request) throws Exception {
        String startTime = String.valueOf(request.getStartTime());
        String endTime = String.valueOf(request.getEndTime());
        NDataModelResponse dataModelResponse = this.modelService.getCube(modelAlias, project);
        if (Objects.isNull(dataModelResponse)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.CUBE_NOT_EXIST, new Object[0]);
        }
        String partitionColumnFormat = this.modelService.getPartitionColumnFormatByAlias(dataModelResponse.getProject(), modelAlias);
        DataRangeUtils.validateDataRange((String)startTime, (String)endTime, (String)partitionColumnFormat);
        JobInfoResponseV2 result = null;
        switch (request.getBuildType()) {
            case "BUILD": {
                JobInfoResponse buildResponse = this.modelBuildService.buildSegmentsManually(dataModelResponse.getProject(), dataModelResponse.getId(), startTime, endTime);
                if (!CollectionUtils.isNotEmpty((Collection)buildResponse.getJobs())) break;
                result = JobInfoResponseV2.convert((JobInfoResponse.JobInfo)buildResponse.getJobs().stream().filter(job -> JobTypeEnum.INC_BUILD.name().equals(job.getJobName()) || JobTypeEnum.INDEX_REFRESH.name().equals(job.getJobName())).findFirst().orElse(null));
                break;
            }
            case "REFRESH": {
                List<String> idList = dataModelResponse.getSegments().stream().filter(segment -> segment.getStartTime() >= request.getStartTime() && segment.getEndTime() <= request.getEndTime()).map(NDataSegmentResponse::getId).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(idList)) {
                    throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SEGMENT_REFRESH_SELECT_EMPTY, new Object[0]);
                }
                if (idList.size() > 1) {
                    throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SEGMENT_REFRESH_MORE_THAN_ONE, new Object[0]);
                }
                List refreshResponse = this.modelBuildService.refreshSegmentById(new RefreshSegmentParams(dataModelResponse.getProject(), dataModelResponse.getId(), idList.toArray(new String[0])));
                if (!CollectionUtils.isNotEmpty((Collection)refreshResponse)) break;
                result = JobInfoResponseV2.convert((JobInfoResponse.JobInfo)refreshResponse.stream().filter(job -> JobTypeEnum.INDEX_REFRESH.name().equals(job.getJobName())).findFirst().orElse(null));
                break;
            }
            default: {
                return new EnvelopeResponse("999", null, "Invalid build type.");
            }
        }
        return new EnvelopeResponse("000", result, "");
    }

    @ApiOperation(value="getFileSegments", tags={"DW"})
    @GetMapping(value={"/{cubeName}/file_segments"})
    @ResponseBody
    public EnvelopeResponse<?> getFileSegmentsStatus(@PathVariable(value="cubeName") String modelAlias, @RequestParam(value="project") String project) {
        String projectChecked = this.checkProjectName(project);
        FileSegments.ModelFileSegments ret = this.modelService.getModelFileSegments(projectChecked, modelAlias);
        return new EnvelopeResponse("000", (Object)ret, "done");
    }

    @ApiOperation(value="manageSegments", tags={"DW"})
    @PutMapping(value={"/{cubeName}/segments"})
    @ResponseBody
    public EnvelopeResponse<?> manageSegments(@PathVariable(value="cubeName") String modelAlias, @RequestParam(value="project", required=false) String project, @RequestBody SegmentMgmtRequest request) {
        NDataModelResponse dataModelResponse = this.modelService.getCube(modelAlias, project);
        if (Objects.isNull(dataModelResponse)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.CUBE_NOT_EXIST, new Object[0]);
        }
        if (ENABLE_FILE_SEGMENTS.equals(request.getBuildType())) {
            Optional fileHashs = request.isForce() ? Optional.of(request.getSegments()) : Optional.empty();
            this.modelService.forceFileSegments(request.getProject(), dataModelResponse.getId(), request.getMpValues(), fileHashs, SegmentStatusEnum.NEW);
            return new EnvelopeResponse("000", (Object)"", "Enabled file segments successfully");
        }
        if (CollectionUtils.isEmpty((Collection)request.getSegments())) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SEGMENT_SELECT_EMPTY, new Object[0]);
        }
        List segList = dataModelResponse.getSegments().stream().filter(segment -> request.getSegments().contains(segment.getName())).collect(Collectors.toList());
        Set segNameSet = segList.stream().map(NDataSegment::getName).collect(Collectors.toSet());
        Set notExistSegList = request.getSegments().stream().filter(name -> !segNameSet.contains(name)).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(notExistSegList)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SEGMENT_NOT_EXIST_NAME, new Object[]{StringUtils.join(notExistSegList.iterator(), (String)",")});
        }
        Set<String> idList = segList.stream().map(NDataSegmentResponse::getId).collect(Collectors.toSet());
        switch (request.getBuildType()) {
            case "MERGE": {
                if (idList.size() < 2) {
                    throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SEGMENT_MERGE_LESS_THAN_TWO, new Object[0]);
                }
                JobInfoResponse.JobInfo mergeResponse = this.modelBuildService.mergeSegmentsManually(new MergeSegmentParams(dataModelResponse.getProject(), dataModelResponse.getId(), idList.toArray(new String[0])));
                return new EnvelopeResponse("000", (Object)JobInfoResponseV2.convert((JobInfoResponse.JobInfo)mergeResponse), "");
            }
            case "REFRESH": {
                if (CollectionUtils.isEmpty(idList)) {
                    throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SEGMENT_REFRESH_SELECT_EMPTY, new Object[0]);
                }
                List refreshResponse = this.modelBuildService.refreshSegmentById(new RefreshSegmentParams(dataModelResponse.getProject(), dataModelResponse.getId(), idList.toArray(new String[0]), request.isForce()));
                return new EnvelopeResponse("000", (Object)JobInfoResponseV2.convert((List)refreshResponse), "");
            }
            case "DROP": {
                if (CollectionUtils.isEmpty(idList)) {
                    throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SEGMENT_DELETE_SELECT_EMPTY, new Object[0]);
                }
                this.modelService.deleteSegmentById(dataModelResponse.getId(), dataModelResponse.getProject(), idList.toArray(new String[0]), true);
                return new EnvelopeResponse("000", (Object)"", "Drop segments successfully");
            }
        }
        return new EnvelopeResponse("999", (Object)"", "Invalid build type.");
    }

    @ApiOperation(value="getHoles", tags={"DW"})
    @GetMapping(value={"/{cubeName}/holes"})
    @ResponseBody
    public EnvelopeResponse<List<NDataSegment>> getHoles(@PathVariable(value="cubeName") String modelAlias, @RequestParam(value="project", required=false) String project) {
        NDataModelResponse dataModelResponse = this.modelService.getCube(modelAlias, project);
        if (Objects.isNull(dataModelResponse)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.CUBE_NOT_EXIST, new Object[0]);
        }
        ArrayList<NDataSegmentResponse> holes = new ArrayList<NDataSegmentResponse>();
        List segments = dataModelResponse.getSegments();
        Collections.sort(segments);
        for (int i = 0; i < segments.size() - 1; ++i) {
            NDataSegment first = (NDataSegment)segments.get(i);
            NDataSegment second = (NDataSegment)segments.get(i + 1);
            if (first.getSegRange().connects(second.getSegRange()) || !first.getSegRange().apartBefore(second.getSegRange())) continue;
            NDataSegmentResponse hole = new NDataSegmentResponse();
            hole.setSegmentRange(first.getSegRange().gapTill(second.getSegRange()));
            hole.setTimeRange(new TimeRange(Long.valueOf(first.getTSRange().getEnd()), Long.valueOf(second.getTSRange().getStart())));
            hole.setName(Segments.makeSegmentName((SegmentRange)hole.getSegRange()));
            holes.add(hole);
        }
        return new EnvelopeResponse("000", holes, "");
    }

    @ApiOperation(value="getSql", tags={"AI"})
    @GetMapping(value={"/{cubeName}/sql"})
    @ResponseBody
    public EnvelopeResponse<Properties> getSql(@PathVariable(value="cubeName") String modelAlias, @RequestParam(value="project", required=false) String project) {
        NDataModelResponse dataModelResponse = this.modelService.getCube(modelAlias, project);
        if (Objects.isNull(dataModelResponse)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.CUBE_NOT_EXIST, new Object[0]);
        }
        String sql = this.modelService.getModelSql(dataModelResponse.getId(), dataModelResponse.getProject());
        Properties response = new Properties();
        response.setProperty("sql", sql);
        return new EnvelopeResponse("000", (Object)response, "");
    }
}

