/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller.v2;

import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.service.ProjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/projects"})
public class NProjectControllerV2
extends NBasicController {
    @Autowired
    @Qualifier(value="projectService")
    private ProjectService projectService;

    @ApiOperation(value="getProjects", tags={"SM"})
    @GetMapping(value={""}, produces={"application/vnd.apache.kylin-v2+json"})
    @ResponseBody
    public EnvelopeResponse getProjects(@RequestParam(value="projectName", required=false) String project, @RequestParam(value="pageOffset", required=false, defaultValue="0") Integer offset, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer size, @RequestParam(value="exact", required=false, defaultValue="true") boolean exactMatch) {
        List readableProjects = this.projectService.getReadableProjects(project, exactMatch);
        Map projects = this.getDataResponse("projects", readableProjects, offset, size);
        return new EnvelopeResponse("000", (Object)projects, "");
    }
}

