/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.util.Base64;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCode;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.AddressUtil;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.RouteService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.rest.util.SparderUIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component(value="sparderUIService")
public class SparderUIService
extends BasicService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SparderUIService.class);
    private static final String ROUTED = "routed";
    private static final String SERVER = "server";
    private static final String TRUE = "true";
    @Autowired
    private RouteService routeService;
    @Autowired
    @Qualifier(value="sparderUIUtil")
    private SparderUIUtil sparderUIUtil;
    @Autowired
    @Qualifier(value="normalRestTemplate")
    private RestTemplate restTemplate;
    @Autowired
    private AclEvaluate aclEvaluate;

    private void checkAcl() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        if (config.isSparkUIAclEnabled()) {
            this.aclEvaluate.checkIsGlobalAdmin();
        }
    }

    public void proxy(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        this.checkAcl();
        String server = SparderUIService.getServer(servletRequest);
        if (StringUtils.isNotBlank((CharSequence)server) && !TRUE.equalsIgnoreCase(servletRequest.getHeader(ROUTED)) && this.routeService.needRoute()) {
            AddressUtil.validateHost((String)server);
            log.info("proxy sparder UI to server : [{}]", (Object)server);
            String queryString = servletRequest.getQueryString();
            this.proxyToServer(server, queryString, this.restTemplate, servletRequest, servletResponse);
            return;
        }
        this.sparderUIUtil.proxy(servletRequest, servletResponse);
    }

    private static String getServer(HttpServletRequest servletRequest) {
        AtomicReference<String> serverAtomic = new AtomicReference<String>("");
        if (Objects.isNull(servletRequest.getCookies())) {
            return null;
        }
        Arrays.stream(servletRequest.getCookies()).filter(cookie -> cookie.getName().equals(SERVER)).findFirst().ifPresent(cookie -> serverAtomic.set(cookie.getValue()));
        byte[] serverBytes = Base64.decodeBase64((byte[])serverAtomic.get().getBytes(Charset.defaultCharset()));
        return new String(serverBytes, Charset.defaultCharset());
    }

    public void proxy(String id, String queryId, String server, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        this.checkAcl();
        String realServer = server;
        if (StringUtils.isBlank((CharSequence)server)) {
            realServer = SparderUIService.getServer(servletRequest);
        }
        if (StringUtils.isNotBlank((CharSequence)realServer) && !TRUE.equalsIgnoreCase(servletRequest.getHeader(ROUTED)) && this.routeService.needRoute()) {
            AddressUtil.validateHost((String)realServer);
            log.info("proxy sparder UI to server : [{}] queryId : [{}] Id : [{}]", new Object[]{realServer, queryId, id});
            String queryString = "id=" + id;
            this.proxyToServer(realServer, queryString, this.restTemplate, servletRequest, servletResponse);
            return;
        }
        this.sparderUIUtil.proxy(servletRequest, servletResponse);
    }

    private void proxyToServer(String server, String queryString, RestTemplate restTemplate, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        ServletRequestAttributes attributes = new ServletRequestAttributes(httpServletRequest);
        RequestContextHolder.setRequestAttributes((RequestAttributes)attributes);
        HttpHeaders headers = new HttpHeaders();
        Collections.list(httpServletRequest.getHeaderNames()).forEach(k -> headers.put(k, Collections.list(httpServletRequest.getHeaders(k))));
        headers.add(ROUTED, TRUE);
        MsgPicker.setMsg((String)httpServletRequest.getHeader("Accept-Language"));
        ErrorCode.setMsg((String)httpServletRequest.getHeader("Accept-Language"));
        String realQueryString = StringUtils.isBlank((CharSequence)queryString) ? "" : "?" + queryString;
        ResponseEntity exchange = restTemplate.exchange(httpServletRequest.getScheme() + "://" + server + httpServletRequest.getRequestURI() + realQueryString, HttpMethod.valueOf((String)httpServletRequest.getMethod()), new HttpEntity((Object)new byte[0], (MultiValueMap)headers), byte[].class, new Object[0]);
        HttpHeaders responseHeaders = exchange.getHeaders();
        byte[] responseBody = (byte[])Optional.ofNullable(exchange.getBody()).orElse(new byte[0]);
        int responseStatus = exchange.getStatusCodeValue();
        httpServletResponse.setStatus(responseStatus);
        this.setResponseHeaders(responseHeaders, httpServletResponse);
        byte[] serverBytes = server.getBytes(Charset.defaultCharset());
        String serverCookie = new String(Base64.encodeBase64((byte[])serverBytes), Charset.defaultCharset());
        Cookie cookie = new Cookie(SERVER, serverCookie);
        cookie.setPath("/kylin/sparder");
        httpServletResponse.addCookie(cookie);
        httpServletResponse.getOutputStream().write(responseBody);
    }

    protected void setResponseHeaders(HttpHeaders responseHeaders, HttpServletResponse servletResponse) {
        responseHeaders.forEach((k, v) -> {
            if (k.equals("Transfer-Encoding")) {
                return;
            }
            for (String headerValue : v) {
                servletResponse.setHeader(k, headerValue);
            }
        });
    }
}

