/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.NativeQueryRealization;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.util.CheckUtil;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.querymeta.TableMeta;
import org.apache.kylin.metadata.querymeta.TableMetaWithType;
import org.apache.kylin.query.util.QueryUtil;
import org.apache.kylin.rest.cache.KylinCache;
import org.apache.kylin.rest.cache.KylinEhCache;
import org.apache.kylin.rest.cache.RedisCache;
import org.apache.kylin.rest.cache.RedisCacheV2;
import org.apache.kylin.rest.cache.memcached.CompositeMemcachedCache;
import org.apache.kylin.rest.request.SQLRequest;
import org.apache.kylin.rest.response.SQLResponse;
import org.apache.kylin.rest.response.TableMetaCacheResult;
import org.apache.kylin.rest.response.TableMetaCacheResultV2;
import org.apache.kylin.rest.service.CommonQueryCacheSupporter;
import org.apache.kylin.rest.util.QueryCacheSignatureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="queryCacheManager")
public class QueryCacheManager
implements CommonQueryCacheSupporter {
    private static final Logger logger = LoggerFactory.getLogger((String)"query");
    private KylinCache kylinCache;

    @PostConstruct
    public void init() {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        if (kylinConfig.isRedisEnabled()) {
            this.kylinCache = kylinConfig.isRedisSentinelEnabled() ? RedisCacheV2.getInstance() : RedisCache.getInstance();
        } else if (kylinConfig.isMemcachedEnabled()) {
            this.kylinCache = CompositeMemcachedCache.getInstance();
        }
        if (this.kylinCache == null) {
            this.kylinCache = KylinEhCache.getInstance();
        }
        if (this.kylinCache instanceof RedisCache && RedisCache.checkRedisClient()) {
            logger.info("Redis cache connect successfully!");
        }
    }

    private boolean cacheable(SQLRequest sqlRequest, SQLResponse sqlResponse) {
        long responseSize;
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        long durationThreshold = kylinConfig.getQueryDurationCacheThreshold();
        long scanCountThreshold = kylinConfig.getQueryScanCountCacheThreshold();
        long scanBytesThreshold = kylinConfig.getQueryScanBytesCacheThreshold();
        long l = responseSize = sqlResponse.getResultRowCount() > 0L ? sqlResponse.getResultRowCount() * (long)sqlResponse.getColumnMetas().size() : 0L;
        return CheckUtil.checkCondition((boolean)QueryUtil.isSelectStatement((String)sqlRequest.getSql()), (String)"query is non-select", (Object[])new Object[0]) && CheckUtil.checkCondition((!sqlResponse.isException() ? 1 : 0) != 0, (String)"query has exception", (Object[])new Object[0]) && CheckUtil.checkCondition((!sqlResponse.isQueryPushDown() || kylinConfig.isPushdownQueryCacheEnabled() ? 1 : 0) != 0, (String)"query is executed with pushdown, or the cache for pushdown is disabled", (Object[])new Object[0]) && CheckUtil.checkCondition((sqlResponse.getDuration() > durationThreshold || sqlResponse.getTotalScanRows() > scanCountThreshold || sqlResponse.getTotalScanBytes() > scanBytesThreshold ? 1 : 0) != 0, (String)"query is too lightweight with duration: {} (threshold {}), scan count: {} (threshold {}), scan bytes: {} (threshold {})", (Object[])new Object[]{sqlResponse.getDuration(), durationThreshold, sqlResponse.getTotalScanRows(), scanCountThreshold, sqlResponse.getTotalScanBytes(), scanBytesThreshold}) && CheckUtil.checkCondition((responseSize < kylinConfig.getLargeQueryThreshold() ? 1 : 0) != 0, (String)"query response is too large: {} ({})", (Object[])new Object[]{responseSize, kylinConfig.getLargeQueryThreshold()});
    }

    public void doCacheSuccessQuery(SQLRequest sqlRequest, SQLResponse sqlResponse) {
        try {
            sqlResponse.readAllRows();
            this.kylinCache.put(CommonQueryCacheSupporter.Type.SUCCESS_QUERY_CACHE.rootCacheName, sqlRequest.getProject(), sqlRequest.getCacheKey(), (Object)sqlResponse);
        }
        catch (Exception e) {
            logger.error("[query cache log] Error caching result of success query {}", (Object)sqlRequest.getSql(), (Object)e);
        }
    }

    public void cacheSuccessQuery(SQLRequest sqlRequest, SQLResponse sqlResponse) {
        if (QueryContext.current().getQueryTagInfo().isAsyncQuery()) {
            return;
        }
        if (this.cacheable(sqlRequest, sqlResponse)) {
            this.doCacheSuccessQuery(sqlRequest, sqlResponse);
        }
    }

    public void cacheFailedQuery(SQLRequest sqlRequest, SQLResponse sqlResponse) {
        if (QueryContext.current().getQueryTagInfo().isAsyncQuery()) {
            return;
        }
        try {
            this.kylinCache.put(CommonQueryCacheSupporter.Type.EXCEPTION_QUERY_CACHE.rootCacheName, sqlRequest.getProject(), sqlRequest.getCacheKey(), (Object)sqlResponse);
        }
        catch (Exception e) {
            logger.error("[query cache log] Error caching result of failed query {}", (Object)sqlRequest.getSql(), (Object)e);
        }
    }

    public void putIntoExceptionCache(SQLRequest req, SQLResponse resp) {
        try {
            this.kylinCache.put(CommonQueryCacheSupporter.Type.EXCEPTION_QUERY_CACHE.rootCacheName, req.getProject(), req.getCacheKey(), (Object)resp);
        }
        catch (Exception e) {
            logger.error("ignore cache error", (Throwable)e);
        }
    }

    public void updateIntoExceptionCache(SQLRequest req, SQLResponse resp) {
        try {
            this.kylinCache.update(CommonQueryCacheSupporter.Type.EXCEPTION_QUERY_CACHE.rootCacheName, req.getProject(), req.getCacheKey(), (Object)resp);
        }
        catch (Exception e) {
            logger.error("ignore cache error", (Throwable)e);
        }
    }

    public SQLResponse getFromExceptionCache(SQLRequest req) {
        return this.searchFailedCache(req);
    }

    public SQLResponse doSearchQuery(CommonQueryCacheSupporter.Type type, SQLRequest sqlRequest) {
        Object response = this.getCache(type.rootCacheName, sqlRequest.getProject(), sqlRequest.getCacheKey());
        logger.debug("[query cache log] The cache key is: {}", sqlRequest.getCacheKey());
        if (response == null) {
            return null;
        }
        return (SQLResponse)response;
    }

    public SQLResponse searchSuccessCache(SQLRequest sqlRequest) {
        SQLResponse cached = this.doSearchQuery(CommonQueryCacheSupporter.Type.SUCCESS_QUERY_CACHE, sqlRequest);
        if (cached == null) {
            logger.info("[query cache log] No success cache searched");
            return null;
        }
        if (QueryCacheSignatureUtil.checkCacheExpired(cached, sqlRequest.getProject())) {
            logger.debug("[query cache log] cache has expired, cache key is {}", sqlRequest.getCacheKey());
            this.clearQueryCache(sqlRequest);
            return null;
        }
        cached.setStorageCacheUsed(true);
        QueryContext.current().getQueryTagInfo().setStorageCacheUsed(true);
        String cacheType = this.getCacheType();
        cached.setStorageCacheType(cacheType);
        QueryContext.current().getQueryTagInfo().setStorageCacheType(cacheType);
        List<NativeQueryRealization> realizations = cached.getNativeRealizations();
        String project = sqlRequest.getProject();
        for (NativeQueryRealization nativeQueryRealization : realizations) {
            if (!nativeQueryRealization.getType().equals("Agg Index") && !nativeQueryRealization.getType().equals("Table Index")) continue;
            String modelId = nativeQueryRealization.getModelId();
            NDataflow dataflow = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).getDataflow(modelId);
            nativeQueryRealization.setModelAlias(dataflow.getModelAlias());
        }
        return cached;
    }

    private String getCacheType() {
        if (KylinConfig.getInstanceFromEnv().isRedisEnabled()) {
            return "Redis";
        }
        if (KylinConfig.getInstanceFromEnv().isMemcachedEnabled()) {
            return "Memcached";
        }
        return "Ehcache";
    }

    public SQLResponse searchFailedCache(SQLRequest sqlRequest) {
        SQLResponse cached = this.doSearchQuery(CommonQueryCacheSupporter.Type.EXCEPTION_QUERY_CACHE, sqlRequest);
        if (cached == null) {
            logger.info("[query cache log] No failed cache searched");
            return null;
        }
        cached.setHitExceptionCache(true);
        QueryContext.current().getQueryTagInfo().setHitExceptionCache(true);
        return cached;
    }

    public SQLResponse searchQuery(SQLRequest sqlRequest) {
        SQLResponse cached = this.searchSuccessCache(sqlRequest);
        if (cached != null) {
            return cached;
        }
        return this.searchFailedCache(sqlRequest);
    }

    public List<TableMeta> getSchemaCache(String project, String userName) {
        TableMetaCacheResult cacheResult = this.doGetSchemaCache(project, userName);
        if (cacheResult == null) {
            return null;
        }
        if (QueryCacheSignatureUtil.checkCacheExpired(cacheResult.getTables(), cacheResult.getSignature(), project, null)) {
            logger.info("[schema cache log] cache has expired, cache key is {}", (Object)userName);
            this.clearSchemaCache(project, userName);
            return null;
        }
        return cacheResult.getTableMetaList();
    }

    public TableMetaCacheResult doGetSchemaCache(String project, String userName) {
        Object metaList = this.getCache(CommonQueryCacheSupporter.Type.SCHEMA_CACHE.rootCacheName, project, userName);
        if (metaList == null) {
            return null;
        }
        return (TableMetaCacheResult)metaList;
    }

    public void putSchemaCache(String project, String userName, TableMetaCacheResult schemas) {
        this.kylinCache.put(CommonQueryCacheSupporter.Type.SCHEMA_CACHE.rootCacheName, project, (Object)userName, (Object)schemas);
    }

    public List<TableMetaWithType> getSchemaV2Cache(String project, String modelName, String userName) {
        TableMetaCacheResultV2 cacheResult = this.doGetSchemaCacheV2(project, modelName, userName);
        if (cacheResult == null) {
            return null;
        }
        if (QueryCacheSignatureUtil.checkCacheExpired(cacheResult.getTables(), cacheResult.getSignature(), project, modelName)) {
            logger.info("[schema cache log] cache has expired, cache key is {}", (Object)userName);
            this.clearSchemaCacheV2(project, userName);
            return null;
        }
        return cacheResult.getTableMetaList();
    }

    public TableMetaCacheResultV2 doGetSchemaCacheV2(String project, String modelName, String userName) {
        Object metaList;
        String cacheKey = userName + "v2";
        if (modelName != null) {
            cacheKey = cacheKey + modelName;
        }
        if ((metaList = this.getCache(CommonQueryCacheSupporter.Type.SCHEMA_CACHE.rootCacheName, project, cacheKey)) == null) {
            return null;
        }
        return (TableMetaCacheResultV2)metaList;
    }

    public void putSchemaV2Cache(String project, String modelName, String userName, TableMetaCacheResultV2 schemas) {
        String cacheKey = userName + "v2";
        if (modelName != null) {
            cacheKey = cacheKey + modelName;
        }
        this.putCache(CommonQueryCacheSupporter.Type.SCHEMA_CACHE.rootCacheName, project, cacheKey, schemas);
    }

    public void clearSchemaCacheV2(String project, String userName) {
        this.removeCache(CommonQueryCacheSupporter.Type.SCHEMA_CACHE.rootCacheName, project, userName + "v2");
    }

    public void clearSchemaCache(String project, String userName) {
        this.removeCache(CommonQueryCacheSupporter.Type.SCHEMA_CACHE.rootCacheName, project, userName);
    }

    public void onClearSchemaCache(String project) {
        this.clearSchemaCache(project);
    }

    public void clearSchemaCache(String project) {
        this.clearCacheByType(CommonQueryCacheSupporter.Type.SCHEMA_CACHE.rootCacheName, project);
    }

    public void clearQueryCache(SQLRequest request) {
        this.removeCache(CommonQueryCacheSupporter.Type.SUCCESS_QUERY_CACHE.rootCacheName, request.getProject(), request.getCacheKey());
        this.removeCache(CommonQueryCacheSupporter.Type.EXCEPTION_QUERY_CACHE.rootCacheName, request.getProject(), request.getCacheKey());
    }

    public void onClearProjectCache(String project) {
        this.clearProjectCache(project);
    }

    public void clearProjectCache(String project) {
        if (project == null) {
            logger.info("[query cache log] clear query cache for all projects.");
            this.clearAllCache();
        } else {
            logger.info("[query cache log] clear query cache for {}", (Object)project);
            this.clearCacheByType(CommonQueryCacheSupporter.Type.SUCCESS_QUERY_CACHE.rootCacheName, project);
            this.clearCacheByType(CommonQueryCacheSupporter.Type.EXCEPTION_QUERY_CACHE.rootCacheName, project);
            this.clearCacheByType(CommonQueryCacheSupporter.Type.SCHEMA_CACHE.rootCacheName, project);
        }
    }

    public boolean recoverCache() {
        logger.info("Redis client recovery start.");
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        if (!kylinConfig.isRedisEnabled()) {
            logger.info("No need to recover Redis client, isRedisEnabled:{}", (Object)kylinConfig.isRedisEnabled());
            return false;
        }
        this.kylinCache = !kylinConfig.isRedisSentinelEnabled() ? RedisCache.recoverInstance() : (this.kylinCache instanceof RedisCacheV2 ? ((RedisCacheV2)this.kylinCache).recoverInstance() : RedisCacheV2.getInstance());
        if (this.kylinCache == null) {
            logger.info("Redis client recover failed, use ehcache instead.");
            this.kylinCache = KylinEhCache.getInstance();
            return false;
        }
        logger.info("Redis client recover successfully.");
        return true;
    }

    public KylinCache getCache() {
        return this.kylinCache;
    }

    public Object getCache(String type, String project, Object key) {
        try {
            return this.kylinCache.get(type, project, key);
        }
        catch (Exception e) {
            logger.error("Get cache failed, type:{}, project:{}, key:{}, exception:{}", new Object[]{type, project, key, e});
            return null;
        }
    }

    public void putCache(String type, String project, Object key, Object value) {
        try {
            this.kylinCache.put(type, project, key, value);
        }
        catch (Exception e) {
            logger.error("Put cache failed, type:{}, project:{}, key:{}, value:{}, exception:{}", new Object[]{type, project, key, value, e});
        }
    }

    public boolean removeCache(String type, String project, Object key) {
        try {
            return this.kylinCache.remove(type, project, key);
        }
        catch (Exception e) {
            logger.error("Remove cache failed, type:{}, project:{}, key:{}, exception:{}", new Object[]{type, project, key, e});
            return false;
        }
    }

    public void clearAllCache() {
        try {
            this.kylinCache.clearAll();
        }
        catch (Exception e) {
            logger.error("Clear all cache failed, exception:", (Throwable)e);
        }
    }

    public void clearCacheByType(String type, String project) {
        try {
            this.kylinCache.clearByType(type, project);
        }
        catch (Exception e) {
            logger.error("Clear cache by type failed, type:{}, project:{}, exception:{}", new Object[]{type, project, e});
        }
    }
}

