/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.test;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.gluten.config.GlutenConfig;
import org.apache.gluten.test.CaseInfo;

public class TestStats {
    private static final String HEADER_FORMAT = "<tr><th>%s</th><th colspan=5>%s</th></tr>";
    private static final String ROW_FORMAT = "<tr><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td></tr>";
    private static final Map<String, CaseInfo> caseInfos = new HashMap<String, CaseInfo>();
    private static String currentCase;
    public static int offloadGlutenUnitNumber;
    public static int testUnitNumber;
    public static boolean offloadGluten;
    public static int suiteTestNumber;
    public static int offloadGlutenTestNumber;
    private static int totalSuiteTestNumber;
    public static int totalOffloadGlutenTestNumber;
    public static int totalTestUnitNumber;
    public static int totalOffloadGlutenCaseNumber;

    private static boolean enabled() {
        return GlutenConfig.get().collectUtStats();
    }

    public static void reset() {
        offloadGluten = false;
        suiteTestNumber = 0;
        offloadGlutenTestNumber = 0;
        testUnitNumber = 0;
        offloadGlutenUnitNumber = 0;
        TestStats.resetCase();
        caseInfos.clear();
    }

    public static void printMarkdown(String suitName) {
        if (!TestStats.enabled()) {
            return;
        }
        String title = "print_markdown_" + suitName;
        String info = "Case Count: %d, OffloadGluten Case Count: %d, Unit Count %d, OffloadGluten Unit Count %d";
        System.out.println(String.format(HEADER_FORMAT, title, String.format(info, suiteTestNumber, offloadGlutenTestNumber, testUnitNumber, offloadGlutenUnitNumber)));
        caseInfos.forEach((key, value) -> System.out.println(String.format(ROW_FORMAT, title, key, value.status, value.type, String.join((CharSequence)"<br/>", value.fallbackExpressionName), String.join((CharSequence)"<br/>", value.fallbackClassName))));
        System.out.println("total_markdown_ totalCaseNum:" + (totalSuiteTestNumber += suiteTestNumber) + " offloadGluten: " + (totalOffloadGlutenTestNumber += offloadGlutenTestNumber) + " total unit: " + (totalTestUnitNumber += testUnitNumber) + " offload unit: " + (totalOffloadGlutenCaseNumber += offloadGlutenUnitNumber));
    }

    public static void addFallBackClassName(String className) {
        if (!TestStats.enabled()) {
            return;
        }
        if (caseInfos.containsKey(currentCase) && !TestStats.caseInfos.get((Object)TestStats.currentCase).stack.isEmpty()) {
            CaseInfo info = caseInfos.get(currentCase);
            TestStats.caseInfos.get((Object)TestStats.currentCase).fallbackExpressionName.add(info.stack.pop());
            TestStats.caseInfos.get((Object)TestStats.currentCase).fallbackClassName.add(className);
        }
    }

    public static void addFallBackCase() {
        if (!TestStats.enabled()) {
            return;
        }
        if (caseInfos.containsKey(currentCase)) {
            TestStats.caseInfos.get((Object)TestStats.currentCase).type = "fallback";
        }
    }

    public static void addExpressionClassName(String className) {
        if (!TestStats.enabled()) {
            return;
        }
        if (caseInfos.containsKey(currentCase)) {
            CaseInfo info = caseInfos.get(currentCase);
            info.stack.add(className);
        }
    }

    public static Set<String> getFallBackClassName() {
        if (!TestStats.enabled()) {
            return Collections.emptySet();
        }
        if (caseInfos.containsKey(currentCase)) {
            return Collections.unmodifiableSet(TestStats.caseInfos.get((Object)TestStats.currentCase).fallbackExpressionName);
        }
        return Collections.emptySet();
    }

    public static void addIgnoreCaseName(String caseName) {
        if (!TestStats.enabled()) {
            return;
        }
        if (caseInfos.containsKey(caseName)) {
            TestStats.caseInfos.get((Object)caseName).type = "fatal";
        }
    }

    public static void resetCase() {
        if (!TestStats.enabled()) {
            return;
        }
        if (caseInfos.containsKey(currentCase)) {
            TestStats.caseInfos.get((Object)TestStats.currentCase).stack.clear();
        }
        currentCase = "";
    }

    public static void startCase(String caseName) {
        if (!TestStats.enabled()) {
            return;
        }
        caseInfos.putIfAbsent(caseName, new CaseInfo());
        currentCase = caseName;
    }

    public static void endCase(boolean status) {
        if (!TestStats.enabled()) {
            return;
        }
        if (caseInfos.containsKey(currentCase)) {
            TestStats.caseInfos.get((Object)TestStats.currentCase).status = status ? "success" : "error";
        }
        TestStats.resetCase();
    }

    static {
        offloadGlutenUnitNumber = 0;
        testUnitNumber = 0;
        offloadGluten = true;
        suiteTestNumber = 0;
        offloadGlutenTestNumber = 0;
        totalSuiteTestNumber = 0;
        totalOffloadGlutenTestNumber = 0;
        totalTestUnitNumber = 0;
        totalOffloadGlutenCaseNumber = 0;
    }
}

