/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.substrait.rel;

import io.substrait.proto.ExpandRel;
import io.substrait.proto.Rel;
import io.substrait.proto.RelCommon;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.gluten.substrait.expression.ExpressionNode;
import org.apache.gluten.substrait.extensions.AdvancedExtensionNode;
import org.apache.gluten.substrait.rel.RelNode;

public class ExpandRelNode
implements RelNode,
Serializable {
    private final RelNode input;
    private final List<List<ExpressionNode>> projections = new ArrayList<List<ExpressionNode>>();
    private final AdvancedExtensionNode extensionNode;

    public ExpandRelNode(RelNode input, List<List<ExpressionNode>> projections, AdvancedExtensionNode extensionNode) {
        this.input = input;
        this.projections.addAll(projections);
        this.extensionNode = extensionNode;
    }

    public ExpandRelNode(RelNode input, List<List<ExpressionNode>> projections) {
        this.input = input;
        this.projections.addAll(projections);
        this.extensionNode = null;
    }

    @Override
    public Rel toProtobuf() {
        RelCommon.Builder relCommonBuilder = RelCommon.newBuilder();
        relCommonBuilder.setDirect(RelCommon.Direct.newBuilder());
        ExpandRel.Builder expandBuilder = ExpandRel.newBuilder();
        expandBuilder.setCommon(relCommonBuilder.build());
        if (this.input != null) {
            expandBuilder.setInput(this.input.toProtobuf());
        }
        for (List<ExpressionNode> projectList : this.projections) {
            ExpandRel.ExpandField.Builder expandFieldBuilder = ExpandRel.ExpandField.newBuilder();
            ExpandRel.SwitchingField.Builder switchingField = ExpandRel.SwitchingField.newBuilder();
            for (ExpressionNode exprNode : projectList) {
                switchingField.addDuplicates(exprNode.toProtobuf());
            }
            expandFieldBuilder.setSwitchingField(switchingField.build());
            expandBuilder.addFields(expandFieldBuilder.build());
        }
        if (this.extensionNode != null) {
            expandBuilder.setAdvancedExtension(this.extensionNode.toProtobuf());
        }
        Rel.Builder builder = Rel.newBuilder();
        builder.setExpand(expandBuilder.build());
        return builder.build();
    }
}

