/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.sdk.datasource.framework.conv;

import java.util.Collection;
import java.util.Locale;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlWith;
import org.apache.calcite.sql.SqlWithItem;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.pretty.SqlPrettyWriter;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.sdk.datasource.framework.conv.SqlConverter;

public class ConvSqlWriter
extends SqlPrettyWriter {
    private static final SqlOrderBy DUMMY_ORDER_BY_NODE = new SqlOrderBy(SqlParserPos.ZERO, (SqlNode)new DummySqlNode(SqlParserPos.ZERO), new SqlNodeList((Collection)Lists.newArrayList((Object[])new SqlNode[]{SqlLiteral.createExactNumeric((String)"1", (SqlParserPos)SqlParserPos.ZERO)}), SqlParserPos.ZERO), null, null);
    private final SqlConverter.IConfigurer configurer;
    private SqlPrettyWriter.FrameImpl lastFrame;

    ConvSqlWriter(SqlConverter.IConfigurer configurer) {
        super(configurer.getSqlDialect());
        this.configurer = configurer;
    }

    public void endList(SqlWriter.Frame frame) {
        super.endList(frame);
        this.lastFrame = frame instanceof SqlPrettyWriter.FrameImpl ? (SqlPrettyWriter.FrameImpl)frame : null;
    }

    public void fetchOffset(SqlNode fetch, SqlNode offset) {
        if (fetch == null && offset == null) {
            return;
        }
        switch (this.configurer.getPagingType().toUpperCase(Locale.ROOT)) {
            case "ROWNUM": {
                this.doWriteRowNum(fetch, offset);
                break;
            }
            case "FETCH_NEXT": {
                this.doWriteFetchNext(fetch, offset);
                break;
            }
            case "LIMIT_OFFSET": {
                this.doWriteLimitOffset(fetch, offset);
                break;
            }
            default: {
                if (this.getDialect().supportsOffsetFetch()) {
                    this.doWriteFetchNext(fetch, offset);
                    break;
                }
                this.doWriteLimitOffset(fetch, offset);
            }
        }
    }

    protected void doWriteRowNum(SqlNode fetch, SqlNode offset) {
    }

    private void doWriteFetchNext(SqlNode fetch, SqlNode offset) {
        if (offset == null && !this.configurer.allowNoOffset()) {
            offset = SqlLiteral.createExactNumeric((String)"0", (SqlParserPos)SqlParserPos.ZERO);
        }
        if (fetch != null && !this.configurer.allowNoOrderByWithFetch() && this.lastFrame != null && this.lastFrame.frameType != SqlWriter.FrameTypeEnum.ORDER_BY_LIST) {
            DUMMY_ORDER_BY_NODE.unparse((SqlWriter)this, 0, 0);
        }
        if (offset != null) {
            this.newlineAndIndent();
            SqlWriter.Frame offsetFrame = this.startList(SqlWriter.FrameTypeEnum.OFFSET);
            this.keyword("OFFSET");
            offset.unparse((SqlWriter)this, -1, -1);
            this.keyword("ROWS");
            this.endList(offsetFrame);
        }
        if (fetch != null) {
            if (!this.configurer.allowFetchNoRows() && fetch instanceof SqlNumericLiteral && ((SqlNumericLiteral)fetch).toValue().equals("0")) {
                fetch = SqlLiteral.createExactNumeric((String)"1", (SqlParserPos)SqlParserPos.ZERO);
            }
            this.newlineAndIndent();
            SqlWriter.Frame fetchFrame = this.startList(SqlWriter.FrameTypeEnum.FETCH);
            this.keyword("FETCH");
            this.keyword("NEXT");
            fetch.unparse((SqlWriter)this, -1, -1);
            this.keyword("ROWS");
            this.keyword("ONLY");
            this.endList(fetchFrame);
        }
    }

    private void doWriteLimitOffset(SqlNode fetch, SqlNode offset) {
        if (fetch != null) {
            this.newlineAndIndent();
            SqlWriter.Frame fetchFrame = this.startList(SqlWriter.FrameTypeEnum.FETCH);
            this.keyword("LIMIT");
            fetch.unparse((SqlWriter)this, -1, -1);
            this.endList(fetchFrame);
        }
        if (offset != null) {
            this.newlineAndIndent();
            SqlWriter.Frame offsetFrame = this.startList(SqlWriter.FrameTypeEnum.OFFSET);
            this.keyword("OFFSET");
            offset.unparse((SqlWriter)this, -1, -1);
            this.endList(offsetFrame);
        }
    }

    public void identifier(String name, boolean isQuoted) {
        String convertName = name;
        if (this.configurer.isCaseSensitive()) {
            convertName = this.configurer.fixIdentifierCaseSensitive(name);
        }
        if (this.configurer.enableQuote() || isQuoted) {
            String quoted = this.getDialect().quoteIdentifier(convertName);
            this.print(quoted);
            this.setNeedWhitespace(true);
        } else if (!this.configurer.skipHandleDefault() && convertName.trim().equalsIgnoreCase("default")) {
            String quoted = this.getDialect().quoteIdentifier(convertName);
            this.print(quoted);
            this.setNeedWhitespace(true);
        } else {
            super.identifier(convertName, this.configurer.enableQuote());
        }
    }

    public boolean inQuery() {
        return this.frame == null || this.frame.frameType == SqlWriter.FrameTypeEnum.ORDER_BY || this.frame.frameType == SqlWriter.FrameTypeEnum.WITH || this.frame.frameType == SqlWriter.FrameTypeEnum.SETOP || this.frame.frameType == SqlWriter.FrameTypeEnum.WITH_ITEM;
    }

    public boolean isQuoteAllIdentifiers() {
        return super.isQuoteAllIdentifiers();
    }

    public void writeWith(SqlCall call, int leftPrec, int rightPrec) {
        SqlWith with = (SqlWith)call;
        SqlWriter.Frame frame = this.startList((SqlWriter.FrameType)SqlWriter.FrameTypeEnum.WITH, "WITH", "");
        for (SqlNode node : with.withList) {
            this.sep(",");
            node.unparse((SqlWriter)this, 0, 0);
        }
        this.outputBetweenWithListAndWithbody();
        with.body.unparse((SqlWriter)this, 100, 100);
        this.endList(frame);
    }

    public void writeWithItem(SqlCall call, SqlWithItem.SqlWithItemOperator sqlWithItemOperator, int leftPrec, int rightPrec) {
        SqlWithItem withItem = (SqlWithItem)call;
        int newLeftPrec = sqlWithItemOperator.getLeftPrec();
        int newRightPrec = sqlWithItemOperator.getRightPrec();
        withItem.name.unparse((SqlWriter)this, newLeftPrec, newRightPrec);
        if (withItem.columnList != null) {
            withItem.columnList.unparse((SqlWriter)this, newLeftPrec, newRightPrec);
        }
        this.keyword("AS");
        SqlWriter.Frame frame = this.startList((SqlWriter.FrameType)SqlWriter.FrameTypeEnum.WITH_ITEM, "(", ")");
        withItem.query.unparse((SqlWriter)this, 10, 10);
        this.endList(frame);
    }

    protected void outputBetweenWithListAndWithbody() {
    }

    private static class DummySqlNode
    extends SqlNodeList {
        private DummySqlNode(SqlParserPos pos) {
            super(pos);
        }

        public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
            writer.sep("");
        }
    }
}

