/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Function;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StaticDataTask;
import org.apache.iceberg.StaticTableScan;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.SnapshotUtil;

public class HistoryTable
extends BaseMetadataTable {
    private static final Schema HISTORY_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"made_current_at", (Type)Types.TimestampType.withZone()), Types.NestedField.required((int)2, (String)"snapshot_id", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"parent_id", (Type)Types.LongType.get()), Types.NestedField.required((int)4, (String)"is_current_ancestor", (Type)Types.BooleanType.get())});

    HistoryTable(Table table) {
        this(table, table.name() + ".history");
    }

    HistoryTable(Table table, String name) {
        super(table, name);
    }

    public TableScan newScan() {
        return new HistoryScan(this.table());
    }

    public Schema schema() {
        return HISTORY_SCHEMA;
    }

    @Override
    MetadataTableType metadataTableType() {
        return MetadataTableType.HISTORY;
    }

    private DataTask task(TableScan scan) {
        return StaticDataTask.of(this.table().io().newInputFile(this.table().operations().current().metadataFileLocation()), this.schema(), scan.schema(), this.table().history(), HistoryTable.convertHistoryEntryFunc(this.table()));
    }

    private static Function<HistoryEntry, StaticDataTask.Row> convertHistoryEntryFunc(Table table) {
        HashMap snapshots = Maps.newHashMap();
        for (Snapshot snap : table.snapshots()) {
            snapshots.put(snap.snapshotId(), snap);
        }
        HashSet ancestorIds = Sets.newHashSet(SnapshotUtil.currentAncestorIds(table));
        return historyEntry -> {
            long snapshotId = historyEntry.snapshotId();
            Snapshot snap = (Snapshot)snapshots.get(snapshotId);
            return StaticDataTask.Row.of(historyEntry.timestampMillis() * 1000L, historyEntry.snapshotId(), snap != null ? snap.parentId() : null, ancestorIds.contains(snapshotId));
        };
    }

    private class HistoryScan
    extends StaticTableScan {
        HistoryScan(Table table) {
            super(table, HISTORY_SCHEMA, MetadataTableType.HISTORY, (StaticTableScan x$0) -> HistoryTable.this.task(x$0));
        }

        HistoryScan(Table table, TableScanContext context) {
            super(table, HISTORY_SCHEMA, MetadataTableType.HISTORY, x$0 -> HistoryTable.this.task(x$0), context);
        }

        @Override
        protected TableScan newRefinedScan(Table table, Schema schema, TableScanContext context) {
            return new HistoryScan(table, context);
        }

        @Override
        public CloseableIterable<FileScanTask> planFiles() {
            return CloseableIterable.withNoopClose((Object)HistoryTable.this.task(this));
        }
    }
}

