/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.RandomAccess;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Litmus;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlNodeList
extends SqlNode
implements List<SqlNode>,
RandomAccess {
    public static final SqlNodeList EMPTY = new SqlNodeList((Collection<? extends SqlNode>)ImmutableList.of(), SqlParserPos.ZERO);
    public static final SqlNodeList SINGLETON_EMPTY = new SqlNodeList((Collection<? extends SqlNode>)ImmutableList.of((Object)EMPTY), SqlParserPos.ZERO);
    public static final SqlNodeList SINGLETON_STAR = new SqlNodeList((Collection<? extends SqlNode>)ImmutableList.of((Object)SqlIdentifier.STAR), SqlParserPos.ZERO);
    private final List<@Nullable SqlNode> list;

    private SqlNodeList(SqlParserPos pos, List<@Nullable SqlNode> list) {
        super(pos);
        this.list = Objects.requireNonNull(list, "list");
    }

    public SqlNodeList(SqlParserPos pos) {
        this(pos, new ArrayList<SqlNode>());
    }

    public SqlNodeList(Collection<? extends @Nullable SqlNode> collection, SqlParserPos pos) {
        this(pos, new ArrayList<SqlNode>(collection));
    }

    public static SqlNodeList of(SqlParserPos pos, List<@Nullable SqlNode> list) {
        return new SqlNodeList(pos, list);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        return this == o || o instanceof SqlNodeList && this.list.equals(((SqlNodeList)o).list) || o instanceof List && this.list.equals(o);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Iterator<SqlNode> iterator() {
        return this.list.iterator();
    }

    @Override
    public ListIterator<SqlNode> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<SqlNode> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public List<SqlNode> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public SqlNode get(int n) {
        return this.list.get(n);
    }

    @Override
    public SqlNode set(int n, @Nullable SqlNode node) {
        return (SqlNode)Nullness.castNonNull((Object)this.list.set(n, node));
    }

    @Override
    public boolean contains(@Nullable Object o) {
        return this.list.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public int indexOf(@Nullable Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(@Nullable Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> @Nullable T[] toArray(T @Nullable [] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(@Nullable SqlNode node) {
        return this.list.add(node);
    }

    @Override
    public void add(int index, @Nullable SqlNode element) {
        this.list.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends @Nullable SqlNode> c) {
        return this.list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends @Nullable SqlNode> c) {
        return this.list.addAll(index, c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean remove(@Nullable Object o) {
        return this.list.remove(o);
    }

    @Override
    public SqlNode remove(int index) {
        return (SqlNode)Nullness.castNonNull((Object)this.list.remove(index));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    public List<@Nullable SqlNode> getList() {
        return this.list;
    }

    @Override
    public SqlNodeList clone(SqlParserPos pos) {
        return new SqlNodeList(this.list, pos);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        SqlWriter.FrameTypeEnum frameType = leftPrec > 0 || rightPrec > 0 ? SqlWriter.FrameTypeEnum.PARENTHESES : SqlWriter.FrameTypeEnum.SIMPLE;
        writer.list(frameType, SqlWriter.COMMA, this);
    }

    @Deprecated
    void commaList(SqlWriter writer) {
        this.unparse(writer, 0, 0);
    }

    @Deprecated
    void andOrList(SqlWriter writer, SqlBinaryOperator sepOp) {
        writer.list(SqlWriter.FrameTypeEnum.WHERE_LIST, sepOp, this);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        for (SqlNode child : this.list) {
            if (child == null) continue;
            child.validate(validator, scope);
        }
    }

    @Override
    public <R> R accept(SqlVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equalsDeep(@Nullable SqlNode node, Litmus litmus) {
        if (!(node instanceof SqlNodeList)) {
            return litmus.fail("{} != {}", this, node);
        }
        SqlNodeList that = (SqlNodeList)node;
        if (this.size() != that.size()) {
            return litmus.fail("{} != {}", this, node);
        }
        for (int i = 0; i < this.list.size(); ++i) {
            SqlNode thisChild = this.list.get(i);
            SqlNode thatChild = that.list.get(i);
            if (thisChild == null) {
                if (thatChild == null) continue;
                return litmus.fail(null, new Object[0]);
            }
            if (thisChild.equalsDeep(thatChild, litmus)) continue;
            return litmus.fail(null, new Object[0]);
        }
        return litmus.succeed();
    }

    public static boolean isEmptyList(SqlNode node) {
        return node instanceof SqlNodeList && ((SqlNodeList)node).isEmpty();
    }

    public static SqlNodeList of(SqlNode node1) {
        ArrayList<@Nullable SqlNode> list = new ArrayList<SqlNode>(1);
        list.add(node1);
        return new SqlNodeList(SqlParserPos.ZERO, list);
    }

    public static SqlNodeList of(SqlNode node1, SqlNode node2) {
        ArrayList<@Nullable SqlNode> list = new ArrayList<SqlNode>(2);
        list.add(node1);
        list.add(node2);
        return new SqlNodeList(SqlParserPos.ZERO, list);
    }

    public static SqlNodeList of(SqlNode node1, SqlNode node2, SqlNode ... nodes) {
        ArrayList<@Nullable SqlNode> list = new ArrayList<SqlNode>(nodes.length + 2);
        list.add(node1);
        list.add(node2);
        Collections.addAll(list, nodes);
        return new SqlNodeList(SqlParserPos.ZERO, list);
    }

    @Override
    public void validateExpr(SqlValidator validator, SqlValidatorScope scope) {
        for (SqlNode node : this.list) {
            if (node == null) continue;
            node.validateExpr(validator, scope);
        }
    }
}

