/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.rules.AggregateExpandWithinDistinctRule;
import org.apache.calcite.tools.RelBuilderFactory;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="AggregateExpandWithinDistinctRule", generator="Immutables")
final class ImmutableAggregateExpandWithinDistinctRule {
    private ImmutableAggregateExpandWithinDistinctRule() {
    }

    @CheckReturnValue
    @Generated(from="AggregateExpandWithinDistinctRule.Config", generator="Immutables")
    @Immutable
    static final class Config
    implements AggregateExpandWithinDistinctRule.Config {
        private final RelBuilderFactory relBuilderFactory;
        @Nullable
        private final @org.checkerframework.checker.nullness.qual.Nullable String description;
        private final RelRule.OperandTransform operandSupplier;
        private final boolean throwIfNotUnique;
        private static final byte STAGE_INITIALIZING = -1;
        private static final byte STAGE_UNINITIALIZED = 0;
        private static final byte STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();
        private static final Config INSTANCE = Config.validate(new Config());

        private Config() {
            this.description = null;
            this.relBuilderFactory = this.initShim.relBuilderFactory();
            this.operandSupplier = this.initShim.operandSupplier();
            this.throwIfNotUnique = this.initShim.throwIfNotUnique();
            this.initShim = null;
        }

        private Config(Builder builder) {
            this.description = builder.description;
            if (builder.relBuilderFactory != null) {
                this.initShim.withRelBuilderFactory(builder.relBuilderFactory);
            }
            if (builder.operandSupplier != null) {
                this.initShim.withOperandSupplier(builder.operandSupplier);
            }
            if (builder.throwIfNotUniqueIsSet()) {
                this.initShim.withThrowIfNotUnique(builder.throwIfNotUnique);
            }
            this.relBuilderFactory = this.initShim.relBuilderFactory();
            this.operandSupplier = this.initShim.operandSupplier();
            this.throwIfNotUnique = this.initShim.throwIfNotUnique();
            this.initShim = null;
        }

        private Config(RelBuilderFactory relBuilderFactory, @Nullable @org.checkerframework.checker.nullness.qual.Nullable String description, RelRule.OperandTransform operandSupplier, boolean throwIfNotUnique) {
            this.relBuilderFactory = relBuilderFactory;
            this.description = description;
            this.operandSupplier = operandSupplier;
            this.throwIfNotUnique = throwIfNotUnique;
            this.initShim = null;
        }

        private RelBuilderFactory relBuilderFactoryInitialize() {
            return AggregateExpandWithinDistinctRule.Config.super.relBuilderFactory();
        }

        private RelRule.OperandTransform operandSupplierInitialize() {
            return AggregateExpandWithinDistinctRule.Config.super.operandSupplier();
        }

        private boolean throwIfNotUniqueInitialize() {
            return AggregateExpandWithinDistinctRule.Config.super.throwIfNotUnique();
        }

        @Override
        public RelBuilderFactory relBuilderFactory() {
            InitShim shim = this.initShim;
            return shim != null ? shim.relBuilderFactory() : this.relBuilderFactory;
        }

        @Override
        @Nullable
        public @org.checkerframework.checker.nullness.qual.Nullable String description() {
            return this.description;
        }

        @Override
        public RelRule.OperandTransform operandSupplier() {
            InitShim shim = this.initShim;
            return shim != null ? shim.operandSupplier() : this.operandSupplier;
        }

        @Override
        public boolean throwIfNotUnique() {
            InitShim shim = this.initShim;
            return shim != null ? shim.throwIfNotUnique() : this.throwIfNotUnique;
        }

        @Override
        public final Config withRelBuilderFactory(RelBuilderFactory value) {
            if (this.relBuilderFactory == value) {
                return this;
            }
            RelBuilderFactory newValue = Objects.requireNonNull(value, "relBuilderFactory");
            return Config.validate(new Config(newValue, this.description, this.operandSupplier, this.throwIfNotUnique));
        }

        @Override
        public final Config withDescription(@Nullable @org.checkerframework.checker.nullness.qual.Nullable String value) {
            if (Objects.equals(this.description, value)) {
                return this;
            }
            return Config.validate(new Config(this.relBuilderFactory, value, this.operandSupplier, this.throwIfNotUnique));
        }

        @Override
        public final Config withOperandSupplier(RelRule.OperandTransform value) {
            if (this.operandSupplier == value) {
                return this;
            }
            RelRule.OperandTransform newValue = Objects.requireNonNull(value, "operandSupplier");
            return Config.validate(new Config(this.relBuilderFactory, this.description, newValue, this.throwIfNotUnique));
        }

        @Override
        public final Config withThrowIfNotUnique(boolean value) {
            if (this.throwIfNotUnique == value) {
                return this;
            }
            return Config.validate(new Config(this.relBuilderFactory, this.description, this.operandSupplier, value));
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Config && this.equalTo((Config)another);
        }

        private boolean equalTo(Config another) {
            return this.relBuilderFactory.equals(another.relBuilderFactory) && Objects.equals(this.description, another.description) && this.operandSupplier.equals(another.operandSupplier) && this.throwIfNotUnique == another.throwIfNotUnique;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.relBuilderFactory.hashCode();
            h += (h << 5) + Objects.hashCode(this.description);
            h += (h << 5) + this.operandSupplier.hashCode();
            h += (h << 5) + Booleans.hashCode((boolean)this.throwIfNotUnique);
            return h;
        }

        public String toString() {
            return com.google.common.base.Objects.toStringHelper((String)"Config").omitNullValues().add("relBuilderFactory", (Object)this.relBuilderFactory).add("description", (Object)this.description).add("operandSupplier", (Object)this.operandSupplier).add("throwIfNotUnique", this.throwIfNotUnique).toString();
        }

        public static Config of() {
            return INSTANCE;
        }

        private static Config validate(Config instance) {
            return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
        }

        public static Config copyOf(AggregateExpandWithinDistinctRule.Config instance) {
            if (instance instanceof Config) {
                return (Config)instance;
            }
            return Config.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="AggregateExpandWithinDistinctRule.Config", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long OPT_BIT_THROW_IF_NOT_UNIQUE = 1L;
            private long optBits;
            @Nullable
            private RelBuilderFactory relBuilderFactory;
            @Nullable
            private @org.checkerframework.checker.nullness.qual.Nullable String description;
            @Nullable
            private RelRule.OperandTransform operandSupplier;
            private boolean throwIfNotUnique;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(AggregateExpandWithinDistinctRule.Config instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(RelRule.Config instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                RelRule.Config instance;
                if (object instanceof AggregateExpandWithinDistinctRule.Config) {
                    instance = (AggregateExpandWithinDistinctRule.Config)object;
                    this.withThrowIfNotUnique(instance.throwIfNotUnique());
                }
                if (object instanceof RelRule.Config) {
                    instance = (RelRule.Config)object;
                    this.withRelBuilderFactory(instance.relBuilderFactory());
                    this.withOperandSupplier(instance.operandSupplier());
                    @org.checkerframework.checker.nullness.qual.Nullable String descriptionValue = instance.description();
                    if (descriptionValue != null) {
                        this.withDescription(descriptionValue);
                    }
                }
            }

            @CanIgnoreReturnValue
            public final Builder withRelBuilderFactory(RelBuilderFactory relBuilderFactory) {
                this.relBuilderFactory = Objects.requireNonNull(relBuilderFactory, "relBuilderFactory");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withDescription(@Nullable @org.checkerframework.checker.nullness.qual.Nullable String description) {
                this.description = description;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withOperandSupplier(RelRule.OperandTransform operandSupplier) {
                this.operandSupplier = Objects.requireNonNull(operandSupplier, "operandSupplier");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withThrowIfNotUnique(boolean throwIfNotUnique) {
                this.throwIfNotUnique = throwIfNotUnique;
                this.optBits |= 1L;
                return this;
            }

            public Config build() {
                return Config.validate(new Config(this));
            }

            private boolean throwIfNotUniqueIsSet() {
                return (this.optBits & 1L) != 0L;
            }
        }

        @Generated(from="AggregateExpandWithinDistinctRule.Config", generator="Immutables")
        private final class InitShim {
            private byte relBuilderFactoryBuildStage = 0;
            private RelBuilderFactory relBuilderFactory;
            private byte operandSupplierBuildStage = 0;
            private RelRule.OperandTransform operandSupplier;
            private byte throwIfNotUniqueBuildStage = 0;
            private boolean throwIfNotUnique;

            private InitShim() {
            }

            RelBuilderFactory relBuilderFactory() {
                if (this.relBuilderFactoryBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.relBuilderFactoryBuildStage == 0) {
                    this.relBuilderFactoryBuildStage = (byte)-1;
                    this.relBuilderFactory = Objects.requireNonNull(Config.this.relBuilderFactoryInitialize(), "relBuilderFactory");
                    this.relBuilderFactoryBuildStage = 1;
                }
                return this.relBuilderFactory;
            }

            void withRelBuilderFactory(RelBuilderFactory relBuilderFactory) {
                this.relBuilderFactory = relBuilderFactory;
                this.relBuilderFactoryBuildStage = 1;
            }

            RelRule.OperandTransform operandSupplier() {
                if (this.operandSupplierBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.operandSupplierBuildStage == 0) {
                    this.operandSupplierBuildStage = (byte)-1;
                    this.operandSupplier = Objects.requireNonNull(Config.this.operandSupplierInitialize(), "operandSupplier");
                    this.operandSupplierBuildStage = 1;
                }
                return this.operandSupplier;
            }

            void withOperandSupplier(RelRule.OperandTransform operandSupplier) {
                this.operandSupplier = operandSupplier;
                this.operandSupplierBuildStage = 1;
            }

            boolean throwIfNotUnique() {
                if (this.throwIfNotUniqueBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.throwIfNotUniqueBuildStage == 0) {
                    this.throwIfNotUniqueBuildStage = (byte)-1;
                    this.throwIfNotUnique = Config.this.throwIfNotUniqueInitialize();
                    this.throwIfNotUniqueBuildStage = 1;
                }
                return this.throwIfNotUnique;
            }

            void withThrowIfNotUnique(boolean throwIfNotUnique) {
                this.throwIfNotUnique = throwIfNotUnique;
                this.throwIfNotUniqueBuildStage = 1;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (this.relBuilderFactoryBuildStage == -1) {
                    attributes.add("relBuilderFactory");
                }
                if (this.operandSupplierBuildStage == -1) {
                    attributes.add("operandSupplier");
                }
                if (this.throwIfNotUniqueBuildStage == -1) {
                    attributes.add("throwIfNotUnique");
                }
                return "Cannot build Config, attribute initializers form cycle " + attributes;
            }
        }
    }
}

