/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.core;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexDigestIncludeType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.Pair;
import org.apache.kylin.guava30.shaded.common.base.Predicate;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class Values
extends AbstractRelNode {
    public static final java.util.function.Predicate<? super Values> IS_EMPTY_J = Values::isEmpty;
    @Deprecated
    public static final Predicate<? super Values> IS_EMPTY = Values::isEmpty;
    @Deprecated
    public static final Predicate<? super Values> IS_NOT_EMPTY = Values::isNotEmpty;
    public final ImmutableList<ImmutableList<RexLiteral>> tuples;

    protected Values(RelOptCluster cluster, RelDataType rowType, ImmutableList<ImmutableList<RexLiteral>> tuples, RelTraitSet traits) {
        super(cluster, traits);
        this.rowType = rowType;
        this.tuples = tuples;
        assert (this.assertRowType());
    }

    protected Values(RelInput input) {
        this(input.getCluster(), input.getRowType("type"), input.getTuples("tuples"), input.getTraitSet());
    }

    public static boolean isEmpty(Values values) {
        return values.getTuples().isEmpty();
    }

    public static boolean isNotEmpty(Values values) {
        return !Values.isEmpty(values);
    }

    public ImmutableList<ImmutableList<RexLiteral>> getTuples(RelInput input) {
        return input.getTuples("tuples");
    }

    public ImmutableList<ImmutableList<RexLiteral>> getTuples() {
        return this.tuples;
    }

    private boolean assertRowType() {
        RelDataType rowType = this.getRowType();
        for (List tuple : this.tuples) {
            assert (tuple.size() == rowType.getFieldCount());
            for (Pair pair : Pair.zip(tuple, rowType.getFieldList())) {
                RexLiteral literal = (RexLiteral)pair.left;
                RelDataType fieldType = ((RelDataTypeField)pair.right).getType();
                if (!RexLiteral.isNullLiteral(literal)) assert (SqlTypeUtil.canAssignFrom(fieldType, literal.getType())) : "to " + fieldType + " from " + literal;
            }
        }
        return true;
    }

    @Override
    protected RelDataType deriveRowType() {
        assert (this.rowType != null) : "rowType must not be null for " + this;
        return this.rowType;
    }

    @Override
    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double dRows = mq.getRowCount(this);
        double dCpu = 1.0;
        double dIo = 0.0;
        return planner.getCostFactory().makeCost(dRows, dCpu, dIo);
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        return this.tuples.size();
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        RelDataType rowType = this.getRowType();
        RelWriter relWriter = super.explainTerms(pw).itemIf("type", rowType, pw.getDetailLevel() == SqlExplainLevel.DIGEST_ATTRIBUTES).itemIf("type", rowType.getFieldList(), pw.nest());
        if (pw.nest()) {
            pw.item("tuples", this.tuples);
        } else {
            pw.item("tuples", this.tuples.stream().map(row -> row.stream().map(lit -> lit.computeDigest(RexDigestIncludeType.NO_TYPE)).collect(Collectors.joining(", ", "{ ", " }"))).collect(Collectors.joining(", ", "[", "]")));
        }
        return relWriter;
    }
}

