/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationImpl;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;

public class RelCollations {
    public static final RelCollation EMPTY = RelCollationTraitDef.INSTANCE.canonize(new RelCollationImpl((ImmutableList<RelFieldCollation>)ImmutableList.of()));
    @Deprecated
    public static final RelCollation PRESERVE = RelCollationTraitDef.INSTANCE.canonize(new RelCollationImpl(ImmutableList.of((Object)new RelFieldCollation(-1))){

        @Override
        public String toString() {
            return "PRESERVE";
        }
    });

    private RelCollations() {
    }

    public static RelCollation of(RelFieldCollation ... fieldCollations) {
        return RelCollations.of((List<RelFieldCollation>)ImmutableList.copyOf((Object[])fieldCollations));
    }

    public static RelCollation of(List<RelFieldCollation> fieldCollations) {
        RelCollationImpl collation;
        if (Util.isDistinct(RelCollations.ordinals(fieldCollations))) {
            collation = new RelCollationImpl((ImmutableList<RelFieldCollation>)ImmutableList.copyOf(fieldCollations));
        } else {
            ImmutableList.Builder builder = ImmutableList.builder();
            HashSet<Integer> set = new HashSet<Integer>();
            for (RelFieldCollation fieldCollation : fieldCollations) {
                if (!set.add(fieldCollation.getFieldIndex())) continue;
                builder.add((Object)fieldCollation);
            }
            collation = new RelCollationImpl((ImmutableList<RelFieldCollation>)builder.build());
        }
        return RelCollationTraitDef.INSTANCE.canonize(collation);
    }

    public static RelCollation of(int fieldIndex) {
        return RelCollations.of(new RelFieldCollation(fieldIndex));
    }

    public static RelCollation of(ImmutableIntList keys) {
        List<RelFieldCollation> cols = keys.stream().map(k -> new RelFieldCollation((int)k)).collect(Collectors.toList());
        return RelCollations.of(cols);
    }

    public static List<RelCollation> createSingleton(int fieldIndex) {
        return ImmutableList.of((Object)RelCollations.of(fieldIndex));
    }

    public static boolean isValid(RelDataType rowType, List<RelCollation> collationList, boolean fail) {
        int fieldCount = rowType.getFieldCount();
        for (RelCollation collation : collationList) {
            for (RelFieldCollation fieldCollation : collation.getFieldCollations()) {
                int index = fieldCollation.getFieldIndex();
                if (index >= 0 && index < fieldCount) continue;
                assert (!fail);
                return false;
            }
        }
        return true;
    }

    public static boolean equal(List<RelCollation> collationList1, List<RelCollation> collationList2) {
        return collationList1.equals(collationList2);
    }

    public static List<Integer> ordinals(RelCollation collation) {
        return RelCollations.ordinals(collation.getFieldCollations());
    }

    public static List<Integer> ordinals(List<RelFieldCollation> fieldCollations) {
        return Util.transform(fieldCollations, RelFieldCollation::getFieldIndex);
    }

    public static boolean contains(RelCollation collation, Iterable<Integer> keys) {
        return RelCollations.contains(collation, Util.distinctList(keys));
    }

    private static boolean contains(RelCollation collation, List<Integer> keys) {
        int n = collation.getFieldCollations().size();
        Iterator<Integer> iterator = keys.iterator();
        for (int i = 0; i < n; ++i) {
            RelFieldCollation fieldCollation = collation.getFieldCollations().get(i);
            if (!iterator.hasNext()) {
                return true;
            }
            if (fieldCollation.getFieldIndex() == iterator.next().intValue()) continue;
            return false;
        }
        return !iterator.hasNext();
    }

    public static boolean contains(List<RelCollation> collations, ImmutableIntList keys) {
        List<Integer> distinctKeys = Util.distinctList(keys);
        for (RelCollation collation : collations) {
            if (!RelCollations.contains(collation, distinctKeys)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsOrderless(RelCollation collation, List<Integer> keys) {
        List<Integer> distinctKeys = Util.distinctList(keys);
        ImmutableBitSet keysBitSet = ImmutableBitSet.of(distinctKeys);
        List<Integer> colKeys = Util.distinctList(collation.getKeys());
        if (colKeys.size() < distinctKeys.size()) {
            return false;
        }
        ImmutableBitSet bitset = ImmutableBitSet.of(colKeys.subList(0, distinctKeys.size()));
        return bitset.equals(keysBitSet);
    }

    public static boolean containsOrderless(List<Integer> keys, RelCollation collation) {
        List<Integer> distinctKeys = Util.distinctList(keys);
        List<Integer> colKeys = Util.distinctList(collation.getKeys());
        if (colKeys.size() > distinctKeys.size()) {
            return false;
        }
        return colKeys.stream().allMatch(i -> distinctKeys.contains(i));
    }

    public static boolean collationsContainKeysOrderless(List<RelCollation> collations, List<Integer> keys) {
        for (RelCollation collation : collations) {
            if (!RelCollations.containsOrderless(collation, keys)) continue;
            return true;
        }
        return false;
    }

    public static boolean keysContainCollationsOrderless(List<Integer> keys, List<RelCollation> collations) {
        for (RelCollation collation : collations) {
            if (!RelCollations.containsOrderless(keys, collation)) continue;
            return true;
        }
        return false;
    }

    public static RelCollation shift(RelCollation collation, int offset) {
        if (offset == 0) {
            return collation;
        }
        ImmutableList.Builder fieldCollations = ImmutableList.builder();
        for (RelFieldCollation fc : collation.getFieldCollations()) {
            fieldCollations.add((Object)fc.shift(offset));
        }
        return new RelCollationImpl((ImmutableList<RelFieldCollation>)fieldCollations.build());
    }

    public static RelCollation permute(RelCollation collation, Map<Integer, Integer> mapping) {
        return RelCollations.of(Util.transform(collation.getFieldCollations(), fc -> fc.withFieldIndex((Integer)Objects.requireNonNull(mapping.get(fc.getFieldIndex()), () -> "no entry for " + fc.getFieldIndex() + " in " + mapping))));
    }

    public static RelCollation permute(RelCollation collation, Mappings.TargetMapping mapping) {
        return RelCollations.of(Util.transform(collation.getFieldCollations(), fc -> fc.withFieldIndex(mapping.getTarget(fc.getFieldIndex()))));
    }
}

