/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.grpc.GetConfigHashPResponse;
import alluxio.shaded.client.com.google.common.base.Objects;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ConfigHash {
    private final String mClusterConfigHash;
    private final String mPathConfigHash;

    public ConfigHash(String clusterConfigHash, String pathConfigHash) {
        Preconditions.checkNotNull(clusterConfigHash, "clusterConfigHash");
        Preconditions.checkNotNull(pathConfigHash, "pathConfigHash");
        this.mClusterConfigHash = clusterConfigHash;
        this.mPathConfigHash = pathConfigHash;
    }

    private ConfigHash(GetConfigHashPResponse response) {
        this.mClusterConfigHash = response.getClusterConfigHash();
        this.mPathConfigHash = response.getPathConfigHash();
    }

    public static ConfigHash fromProto(GetConfigHashPResponse response) {
        return new ConfigHash(response);
    }

    public GetConfigHashPResponse toProto() {
        GetConfigHashPResponse.Builder response = GetConfigHashPResponse.newBuilder();
        if (this.mClusterConfigHash != null) {
            response.setClusterConfigHash(this.mClusterConfigHash);
        }
        if (this.mPathConfigHash != null) {
            response.setPathConfigHash(this.mPathConfigHash);
        }
        return response.build();
    }

    public String getClusterConfigHash() {
        return this.mClusterConfigHash;
    }

    public String getPathConfigHash() {
        return this.mPathConfigHash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigHash)) {
            return false;
        }
        ConfigHash that = (ConfigHash)o;
        return this.mClusterConfigHash.equals(that.mClusterConfigHash) && this.mPathConfigHash.equals(that.mPathConfigHash);
    }

    public int hashCode() {
        return Objects.hashCode(this.mClusterConfigHash, this.mPathConfigHash);
    }
}

