/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.query.util.RawSql;
import org.apache.kylin.query.util.RawSqlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryModelPriorities {
    private static final Logger log = LoggerFactory.getLogger(QueryModelPriorities.class);
    private static final Pattern MODEL_PRIORITY_PATTERN = Pattern.compile("MODEL_PRIORITY\\([^()]*\\)");
    private static final Pattern CUBE_PRIORITY_PATTERN = Pattern.compile("(?<=--(\\s){0,2}CubePriority\\().*(?=\\)(\\s)*[\r\n])");

    private QueryModelPriorities() {
    }

    public static String[] getModelPrioritiesFromComment(String sql) {
        String[] models = new String[]{};
        try {
            RawSql rawSql = new RawSqlParser(sql).parse();
            models = QueryModelPriorities.getModelPrioritiesFromHintStr(rawSql.getFirstHintString());
        }
        catch (Throwable t) {
            log.error("Error on parse sql when invoking getModelPrioritiesFromComment", t);
        }
        if (models.length == 0) {
            models = QueryModelPriorities.loadCubePriorityFromComment(sql);
        }
        return models;
    }

    public static String[] getModelPrioritiesFromHintStrOrComment(String hintStr, String sql) {
        String[] models = QueryModelPriorities.getModelPrioritiesFromHintStr(hintStr);
        if (models.length == 0) {
            models = QueryModelPriorities.loadCubePriorityFromComment(sql);
        }
        return models;
    }

    public static String[] getModelPrioritiesFromHintStr(String hintStr) {
        Matcher matcher;
        if (StringUtils.isNotBlank((CharSequence)hintStr) && (matcher = MODEL_PRIORITY_PATTERN.matcher(hintStr)).find(0)) {
            String modelPriorityHint = matcher.group().toUpperCase(Locale.ROOT);
            return QueryModelPriorities.extractModelPriorityModelNames(modelPriorityHint);
        }
        return new String[0];
    }

    private static String[] extractModelPriorityModelNames(String modelPriorityHint) {
        if (StringUtils.isBlank((CharSequence)modelPriorityHint) || modelPriorityHint.indexOf("MODEL_PRIORITY(") != 0) {
            return new String[0];
        }
        String[] modelNames = modelPriorityHint.replace("MODEL_PRIORITY(", "").replace(")", "").split(",");
        for (int i = 0; i < modelNames.length; ++i) {
            modelNames[i] = modelNames[i].trim();
        }
        return modelNames;
    }

    static String[] loadCubePriorityFromComment(String sql) {
        Matcher matcher = CUBE_PRIORITY_PATTERN.matcher(sql + "\n");
        if (matcher.find()) {
            String cubeNames = matcher.group().trim().toUpperCase(Locale.ROOT);
            return cubeNames.split(",");
        }
        return new String[0];
    }
}

