/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.discovery;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ClusterConstant;
import org.apache.kylin.metadata.system.NodeRegistry;
import org.apache.kylin.metadata.system.NodeRegistryManager;
import org.apache.kylin.rest.cluster.ClusterManager;
import org.apache.kylin.rest.discovery.ConditionalOnNodeRegistryJdbcEnabled;
import org.apache.kylin.rest.response.ServerInfoResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@ConditionalOnNodeRegistryJdbcEnabled
@Component
public class JdbcClusterManager
implements ClusterManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcClusterManager.class);

    public String getLocalServer() {
        NodeRegistryManager manager = NodeRegistryManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        NodeRegistry.NodeInstance localInstance = manager.getLocalNodeInstance();
        return JdbcClusterManager.instance2Str((NodeRegistry.NodeInstance)localInstance);
    }

    public List<ServerInfoResponse> getQueryServers() {
        return JdbcClusterManager.getServerByMode((ClusterConstant.ServerModeEnum[])new ClusterConstant.ServerModeEnum[]{ClusterConstant.ServerModeEnum.ALL, ClusterConstant.ServerModeEnum.QUERY});
    }

    public List<ServerInfoResponse> getServersFromCache() {
        return this.getServers();
    }

    public List<ServerInfoResponse> getJobServers() {
        return JdbcClusterManager.getServerByMode((ClusterConstant.ServerModeEnum[])new ClusterConstant.ServerModeEnum[]{ClusterConstant.ServerModeEnum.ALL, ClusterConstant.ServerModeEnum.JOB});
    }

    public List<ServerInfoResponse> getServers() {
        return JdbcClusterManager.getServerByMode((ClusterConstant.ServerModeEnum[])new ClusterConstant.ServerModeEnum[]{ClusterConstant.ServerModeEnum.ALL, ClusterConstant.ServerModeEnum.JOB, ClusterConstant.ServerModeEnum.QUERY});
    }

    private static List<ServerInfoResponse> getServerByMode(ClusterConstant.ServerModeEnum ... serverModeEnum) {
        ArrayList<ServerInfoResponse> servers = new ArrayList<ServerInfoResponse>();
        if (serverModeEnum == null || serverModeEnum.length == 0) {
            return servers;
        }
        NodeRegistryManager manager = NodeRegistryManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        for (ClusterConstant.ServerModeEnum mode : serverModeEnum) {
            servers.addAll(manager.getNodeInstances(mode).stream().map(instance -> new ServerInfoResponse(JdbcClusterManager.instance2Str((NodeRegistry.NodeInstance)instance), instance.getServerMode().getName())).collect(Collectors.toList()));
        }
        return servers;
    }

    private static String instance2Str(NodeRegistry.NodeInstance instance) {
        return String.format(Locale.ROOT, "%s:%s", instance.getHost(), instance.getPort());
    }
}

