/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.scheduler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.logging.SetLogCategory;
import org.apache.kylin.common.util.ExecutorServiceUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.ThreadUtils;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.job.JobContext;
import org.apache.kylin.job.core.AbstractJobExecutable;
import org.apache.kylin.job.core.lock.JdbcJobLock;
import org.apache.kylin.job.core.lock.LockAcquireListener;
import org.apache.kylin.job.core.lock.LockException;
import org.apache.kylin.job.dao.ExecutablePO;
import org.apache.kylin.job.domain.JobInfo;
import org.apache.kylin.job.domain.JobLock;
import org.apache.kylin.job.domain.PriorityFistRandomOrderJob;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.rest.JobMapperFilter;
import org.apache.kylin.job.runners.JobCheckUtil;
import org.apache.kylin.job.scheduler.JobExecutor;
import org.apache.kylin.job.scheduler.JobScheduler;
import org.apache.kylin.job.util.JobContextUtil;
import org.apache.kylin.job.util.JobInfoUtil;
import org.apache.kylin.metadata.cube.utils.StreamingUtils;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.resourcegroup.ResourceGroupManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcJobScheduler
implements JobScheduler {
    private static final Logger logger = LoggerFactory.getLogger((String)"schedule");
    private final JobContext jobContext;
    private final AtomicBoolean isMaster;
    private final Map<String, Pair<AbstractJobExecutable, Long>> runningJobMap;
    private final Map<String, PriorityQueue<JobInfo>> readyJobCache;
    private JdbcJobLock masterLock;
    private ScheduledExecutorService master;
    private ScheduledExecutorService slave;
    private ThreadPoolExecutor executorPool;
    private final int consumerMaxThreads;

    public JdbcJobScheduler(JobContext jobContext) {
        this.jobContext = jobContext;
        this.isMaster = new AtomicBoolean(false);
        this.runningJobMap = Maps.newConcurrentMap();
        this.readyJobCache = Maps.newHashMap();
        this.consumerMaxThreads = jobContext.getKylinConfig().getNodeMaxConcurrentJobLimit();
    }

    @Override
    public void publishJob() {
        this.masterLock = new JdbcJobLock("master_scheduler", this.jobContext.getServerNode(), this.jobContext.getKylinConfig().getJobSchedulerMasterRenewalSec(), this.jobContext.getKylinConfig().getJobSchedulerMasterRenewalRatio(), this.jobContext.getLockClient(), new MasterAcquireListener());
        this.master.schedule(this::standby, 0L, TimeUnit.SECONDS);
        this.master.schedule(this::produceJob, 0L, TimeUnit.SECONDS);
    }

    @Override
    public void subscribeJob() {
        this.slave.schedule(this::consumeJob, 0L, TimeUnit.SECONDS);
    }

    public boolean hasRunningJob() {
        return !this.runningJobMap.isEmpty();
    }

    public Map<String, Pair<AbstractJobExecutable, Long>> getRunningJob() {
        return Collections.unmodifiableMap(this.runningJobMap);
    }

    @Override
    public String getJobNode(String jobId) {
        return JobContextUtil.getJobSchedulerHost(jobId);
    }

    @Override
    public boolean isMaster() {
        return this.isMaster.get();
    }

    @Override
    public String getJobMaster() {
        return this.jobContext.getJobLockMapper().selectByJobId("master_scheduler").getLockNode();
    }

    public void start() {
        this.master = ThreadUtils.newDaemonSingleThreadScheduledExecutor((String)"JdbcJobScheduler-Master");
        this.slave = ThreadUtils.newDaemonSingleThreadScheduledExecutor((String)"JdbcJobScheduler-Slave");
        int maxThreads = this.consumerMaxThreads <= 0 ? 1 : this.consumerMaxThreads;
        this.executorPool = ThreadUtils.newDaemonScalableThreadPool((String)"JdbcJobScheduler-Executor", (int)1, (int)maxThreads, (long)5L, (TimeUnit)TimeUnit.MINUTES);
        this.publishJob();
        this.subscribeJob();
    }

    public void destroy() {
        if (Objects.nonNull(this.masterLock)) {
            try {
                this.masterLock.tryRelease();
            }
            catch (LockException e) {
                logger.warn("Something's wrong when removing master lock");
            }
        }
        if (Objects.nonNull(this.master)) {
            this.master.shutdownNow();
        }
        if (Objects.nonNull(this.slave)) {
            this.slave.shutdownNow();
        }
        if (Objects.nonNull(this.executorPool)) {
            ExecutorServiceUtil.shutdownGracefully((ExecutorService)this.executorPool, (int)60);
        }
    }

    private void standby() {
        try {
            if (this.jobContext.getJobLockMapper().selectByJobId("master_scheduler") == null) {
                this.jobContext.getJobLockMapper().insertSelective(new JobLock("master_scheduler", "_global", 0, JobLock.JobTypeEnum.MASTER));
            }
        }
        catch (Exception e) {
            logger.error("Try insert 'master_scheduler' failed.", (Throwable)e);
        }
        try {
            this.masterLock.tryAcquire();
        }
        catch (LockException e) {
            logger.error("Something's wrong when acquiring master lock.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void produceJob() {
        long delaySec = this.jobContext.getKylinConfig().getJobSchedulerMasterPollIntervalSec();
        try {
            if (!this.isMaster.get()) {
                return;
            }
            this.releaseExpiredLock();
            List<JobInfo> processingJobInfoList = this.getProcessingJobInfoWithOrder();
            HashMap projectRunningCountMap = Maps.newHashMap();
            HashMap projectRunningRecModelMap = Maps.newHashMap();
            HashMap projectRunningIndexPlannerBuildJobMap = Maps.newHashMap();
            this.collectProcessingJobInfo(processingJobInfoList, projectRunningCountMap, projectRunningRecModelMap, projectRunningIndexPlannerBuildJobMap);
            Map<String, Integer> projectProduceCountMap = this.getProjectProduceCount(projectRunningCountMap);
            Map<String, Integer> projectProduceIndexPlannerBuildJobCountMap = this.getProjectProduceCount(projectRunningIndexPlannerBuildJobMap, "REC");
            boolean produced = false;
            for (Map.Entry<String, Integer> entry : projectProduceCountMap.entrySet()) {
                String project = entry.getKey();
                int produceCount = entry.getValue();
                if (produceCount == 0) {
                    logger.info("Project {} has reached max concurrent limit", (Object)project);
                    continue;
                }
                PriorityQueue<JobInfo> projectReadyJobCache = this.readyJobCache.get(project);
                if (CollectionUtils.isEmpty(projectReadyJobCache)) continue;
                produced = true;
                if (produceCount > projectReadyJobCache.size()) {
                    produceCount = projectReadyJobCache.size();
                }
                StreamingUtils.replayAuditlog();
                logger.info("Begin to produce job for project: {}, product count: {}", (Object)project, (Object)produceCount);
                for (int i = 0; i < produceCount; ++i) {
                    this.produceJobForProject(produceCount, projectReadyJobCache, (Set)projectRunningRecModelMap.get(project), projectProduceIndexPlannerBuildJobCountMap);
                }
            }
            if (produced) {
                delaySec = 0L;
            }
        }
        catch (Exception e) {
            logger.error("Something's wrong when publishing job", (Throwable)e);
        }
        finally {
            this.master.schedule(this::produceJob, delaySec, TimeUnit.SECONDS);
        }
    }

    private void collectProcessingJobInfo(List<JobInfo> processingJobInfoList, Map<String, Integer> projectRunningCountMap, Map<String, Set<String>> projectRunningRecModelMap, Map<String, Integer> projectRunningIndexPlannerBuildJobMap) {
        for (JobInfo processingJobInfo : processingJobInfoList) {
            if (!projectRunningCountMap.containsKey(processingJobInfo.getProject())) {
                projectRunningRecModelMap.put(processingJobInfo.getProject(), new HashSet());
            }
            if (ExecutableState.READY.name().equals(processingJobInfo.getJobStatus())) {
                this.addReadyJobToCache(processingJobInfo);
                continue;
            }
            String project = processingJobInfo.getProject();
            if (!projectRunningCountMap.containsKey(project)) {
                projectRunningCountMap.put(project, 0);
                projectRunningIndexPlannerBuildJobMap.put(project, 0);
            }
            projectRunningCountMap.put(project, projectRunningCountMap.get(project) + 1);
            if (!projectRunningRecModelMap.get(project).contains(processingJobInfo.getModelId()) && this.isIndexPlannerRecJob(processingJobInfo)) {
                projectRunningRecModelMap.get(project).add(processingJobInfo.getModelId());
            }
            if (!this.isIndexPlannerBuildJob(processingJobInfo) || !projectRunningIndexPlannerBuildJobMap.containsKey(project)) continue;
            projectRunningIndexPlannerBuildJobMap.put(project, projectRunningIndexPlannerBuildJobMap.get(project) + 1);
        }
    }

    private void produceJobForProject(int produceCount, PriorityQueue<JobInfo> projectReadyJobCache, Set<String> runningRecModels, Map<String, Integer> projectRunningIndexPlannerBuildJob) {
        int i = 0;
        while (i < produceCount && !projectReadyJobCache.isEmpty()) {
            JobInfo jobInfo = projectReadyJobCache.poll();
            if (!this.doProduce(jobInfo, runningRecModels, projectRunningIndexPlannerBuildJob)) continue;
            ++i;
        }
    }

    private boolean doProduce(JobInfo jobInfo, Set<String> runningRecModels, Map<String, Integer> projectRunningIndexPlannerBuildJob) {
        try {
            if (JdbcJobScheduler.markSuicideJobWithTransaction(jobInfo)) {
                logger.info("Suicide job = {} on produce", (Object)jobInfo.getJobId());
                return false;
            }
            if (this.isIndexPlannerBuildJob(jobInfo)) {
                if (projectRunningIndexPlannerBuildJob.get(jobInfo.getProject()) > 0) {
                    projectRunningIndexPlannerBuildJob.put(jobInfo.getProject(), projectRunningIndexPlannerBuildJob.get(jobInfo.getProject()) - 1);
                } else {
                    logger.info("Project {} has reached max concurrent limit for index planner fill index job", (Object)jobInfo.getProject());
                    return false;
                }
            }
            if (this.isIndexPlannerRecJob(jobInfo)) {
                if (runningRecModels.contains(jobInfo.getModelId())) {
                    return false;
                }
                runningRecModels.add(jobInfo.getModelId());
            }
            return (Boolean)JobContextUtil.withTxAndRetry(() -> {
                String jobId = jobInfo.getJobId();
                JobLock lock = this.jobContext.getJobLockMapper().selectByJobId(jobId);
                if (lock == null && this.jobContext.getJobLockMapper().insertSelective(new JobLock(jobId, jobInfo.getProject(), jobInfo.getPriority(), JobLock.JobTypeEnum.OFFLINE)) == 0) {
                    logger.error("Create job lock for [{}] failed!", (Object)jobId);
                    return false;
                }
                ExecutableManager.getInstance(KylinConfig.getInstanceFromEnv(), jobInfo.getProject()).publishJob(jobId, (AbstractExecutable)this.getJobExecutable(jobInfo));
                logger.debug("Job {} has bean produced successfully", (Object)jobInfo.getJobId());
                return true;
            });
        }
        catch (Exception e) {
            logger.error("Failed to produce job: {}", (Object)jobInfo.getJobId(), (Object)e);
            return false;
        }
    }

    private static boolean markSuicideJobWithTransaction(JobInfo jobInfo) {
        return (Boolean)EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> JobCheckUtil.markSuicideJob(jobInfo), (String)jobInfo.getProject());
    }

    private List<JobInfo> getProcessingJobInfoWithOrder() {
        JobMapperFilter jobMapperFilter = new JobMapperFilter();
        jobMapperFilter.setStatuses(ExecutableState.READY, ExecutableState.PENDING, ExecutableState.RUNNING);
        jobMapperFilter.setOrderByFiled("priority,create_time");
        jobMapperFilter.setOrderType("ASC");
        return this.jobContext.getJobInfoMapper().selectByJobFilter(jobMapperFilter);
    }

    private void addReadyJobToCache(JobInfo jobInfo) {
        String project = jobInfo.getProject();
        this.readyJobCache.computeIfAbsent(project, k -> new PriorityQueue());
        if (!this.readyJobCache.get(project).contains(jobInfo)) {
            this.readyJobCache.get(project).add(jobInfo);
        }
    }

    private Map<String, Integer> getProjectProduceCount(Map<String, Integer> projectRunningCountMap, String jobType) {
        HashMap projectProduceCount = Maps.newHashMap();
        NProjectManager projectManager = NProjectManager.getInstance((KylinConfig)this.jobContext.getKylinConfig());
        List allProjects = projectManager.listAllProjects();
        for (ProjectInstance projectInstance : allProjects) {
            String project = projectInstance.getName();
            projectInstance.getConfig().getMaxConcurrentJobLimit();
            int projectMaxConcurrent = "REC".equals(jobType) ? projectInstance.getConfig().getMaxConcurrentFillIndexJobLimit() : projectInstance.getConfig().getMaxConcurrentJobLimit();
            int projectRunningCount = projectRunningCountMap.getOrDefault(project, 0);
            if (projectRunningCount < projectMaxConcurrent) {
                projectProduceCount.put(project, projectMaxConcurrent - projectRunningCount);
                continue;
            }
            projectProduceCount.put(project, 0);
        }
        int globalRunningCount = projectRunningCountMap.getOrDefault("_global", 0);
        projectProduceCount.put("_global", globalRunningCount == 0 ? 1 : 0);
        return projectProduceCount;
    }

    private Map<String, Integer> getProjectProduceCount(Map<String, Integer> projectRunningCountMap) {
        return this.getProjectProduceCount(projectRunningCountMap, "ALL");
    }

    private void releaseExpiredLock() {
        int batchSize = this.jobContext.getKylinConfig().getJobSchedulerMasterPollBatchSize();
        JobMapperFilter filter = new JobMapperFilter();
        List<String> jobIds = this.jobContext.getJobLockMapper().findExpiredORNonLockIdList(batchSize);
        if (jobIds.isEmpty()) {
            return;
        }
        filter.setJobIds(jobIds);
        List<JobInfo> jobs = this.jobContext.getJobInfoMapper().selectByJobFilter(filter);
        List jobInfoIds = jobs.stream().map(JobInfo::getJobId).collect(Collectors.toList());
        List<String> toRemoveLocks = Lists.newArrayList(jobIds).stream().filter(jobId -> !jobInfoIds.contains(jobId)).collect(Collectors.toList());
        for (JobInfo job : jobs) {
            ExecutableState state;
            ExecutablePO po = JobInfoUtil.deserializeExecutablePO(job);
            if (po == null || !(state = ExecutableState.valueOf(po.getOutput().getStatus())).isNotProgressing() && !state.isFinalState()) continue;
            toRemoveLocks.add(job.getJobId());
        }
        if (!toRemoveLocks.isEmpty()) {
            this.jobContext.getJobLockMapper().batchRemoveLock(toRemoveLocks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumeJob() {
        long delay = this.jobContext.getKylinConfig().getSchedulerPollIntervalSecond().intValue();
        try {
            List projects;
            List<String> jobIdList;
            int exeFreeSlots = this.consumerMaxThreads - this.runningJobMap.size();
            if (exeFreeSlots <= 0) {
                logger.info("No free slots to execute job");
                return;
            }
            int batchSize = this.jobContext.getKylinConfig().getJobSchedulerSlavePollBatchSize();
            if (exeFreeSlots < batchSize) {
                batchSize = exeFreeSlots;
            }
            if (CollectionUtils.isEmpty(jobIdList = this.findNonLockIdListInOrder(batchSize, projects = ResourceGroupManager.getInstance((KylinConfig)this.jobContext.getKylinConfig()).listProjectWithPermission()))) {
                return;
            }
            if (!this.isMaster.get()) {
                StreamingUtils.replayAuditlog();
            }
            jobIdList.forEach(jobId -> {
                AbstractJobExecutable jobExecutable;
                if (this.runningJobMap.containsKey(jobId)) {
                    logger.warn("Job {} has already been submitted", jobId);
                    return;
                }
                Pair<JobInfo, AbstractJobExecutable> job = this.fetchJob((String)jobId);
                if (null == job) {
                    return;
                }
                JobInfo jobInfo = (JobInfo)job.getFirst();
                if (!this.canSubmitJob((String)jobId, jobInfo, jobExecutable = (AbstractJobExecutable)job.getSecond())) {
                    return;
                }
                this.runningJobMap.put((String)jobId, (Pair<AbstractJobExecutable, Long>)new Pair((Object)jobExecutable, (Object)System.currentTimeMillis()));
                this.executorPool.execute(() -> this.executeJob(jobExecutable, jobInfo));
            });
        }
        catch (Exception e) {
            logger.error("Something's wrong when consuming job", (Throwable)e);
        }
        finally {
            logger.info("{} running jobs in current scheduler", (Object)this.getRunningJob().size());
            this.slave.schedule(this::consumeJob, delay, TimeUnit.SECONDS);
        }
    }

    public List<String> findNonLockIdListInOrder(int batchSize, List<String> projects) {
        KylinConfig config = this.jobContext.getKylinConfig();
        ArrayList<String> projectsAndGlobal = new ArrayList<String>(projects);
        projectsAndGlobal.add("_global");
        if (projectsAndGlobal.size() == NProjectManager.getInstance((KylinConfig)config).listAllProjects().size() + 1) {
            projectsAndGlobal = null;
        }
        List<PriorityFistRandomOrderJob> jobIdList = this.jobContext.getJobLockMapper().findNonLockIdList(batchSize, projectsAndGlobal);
        if (this.hasRunningJob()) {
            Collections.sort(jobIdList);
        }
        return jobIdList.stream().map(PriorityFistRandomOrderJob::getJobId).collect(Collectors.toList());
    }

    private Pair<JobInfo, AbstractJobExecutable> fetchJob(String jobId) {
        try {
            JobInfo jobInfo = this.jobContext.getJobInfoMapper().selectByJobId(jobId);
            if (jobInfo == null) {
                logger.warn("can not find job info {}", (Object)jobId);
                return null;
            }
            AbstractJobExecutable jobExecutable = this.getJobExecutable(jobInfo);
            return new Pair((Object)jobInfo, (Object)jobExecutable);
        }
        catch (Exception e) {
            logger.error("Fetch job failed, job id: {}", (Object)jobId, (Object)e);
            return null;
        }
    }

    private boolean canSubmitJob(String jobId, JobInfo jobInfo, AbstractJobExecutable jobExecutable) {
        try {
            if ("master_scheduler".equals(jobId)) {
                return false;
            }
            if (Objects.isNull(jobInfo)) {
                logger.warn("Job not found: {}", (Object)jobId);
                return false;
            }
            if (!this.jobContext.getResourceAcquirer().tryAcquire(jobExecutable)) {
                return false;
            }
        }
        catch (Exception e) {
            logger.error("Error when preparing to submit job: {}", (Object)jobId, (Object)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeJob(AbstractJobExecutable jobExecutable, JobInfo jobInfo) {
        JdbcJobLock jobLock;
        block61: {
            block62: {
                block59: {
                    block60: {
                        block57: {
                            block58: {
                                jobLock = null;
                                try {
                                    block56: {
                                        try (JobExecutor jobExecutor = new JobExecutor(this.jobContext, jobExecutable);){
                                            Throwable throwable;
                                            SetLogCategory ignore;
                                            block55: {
                                                block54: {
                                                    ignore = new SetLogCategory("build");
                                                    throwable = null;
                                                    try {
                                                        AbstractExecutable executable = (AbstractExecutable)jobExecutable;
                                                        ExecutableState jobStatus = executable.getStatus();
                                                        if (ExecutableState.PENDING != jobStatus) {
                                                            logger.warn("Unexpected status for {} <{}>, should not execute job", (Object)jobExecutable.getJobId(), (Object)jobStatus);
                                                            if (ExecutableState.RUNNING == jobStatus && (jobLock = this.tryJobLock(jobExecutable)) != null) {
                                                                logger.warn("Resume <RUNNING> job {}", (Object)jobExecutable.getJobId());
                                                                ExecutableManager.getInstance(KylinConfig.getInstanceFromEnv(), executable.getProject()).resumeJob(jobExecutable.getJobId(), true);
                                                            }
                                                            if (jobLock != null) {
                                                                this.stopJobLockRenewAfterExecute(jobLock);
                                                            }
                                                            this.runningJobMap.remove(jobExecutable.getJobId());
                                                            return;
                                                        }
                                                        jobLock = this.tryJobLock(jobExecutable);
                                                        if (null == jobLock) break block54;
                                                        if (this.jobContext.isProjectReachQuotaLimit(jobExecutable.getProject()) && JobCheckUtil.stopJobIfStorageQuotaLimitReached(this.jobContext, jobInfo.getProject(), jobInfo.getJobId())) break block55;
                                                        jobExecutor.execute();
                                                        break block56;
                                                    }
                                                    catch (Throwable throwable2) {
                                                        throwable = throwable2;
                                                        throw throwable2;
                                                    }
                                                }
                                                if (jobLock == null) break block57;
                                                break block58;
                                            }
                                            if (jobLock == null) break block59;
                                            break block60;
                                            finally {
                                                if (ignore != null) {
                                                    if (throwable != null) {
                                                        try {
                                                            ignore.close();
                                                        }
                                                        catch (Throwable throwable3) {
                                                            throwable.addSuppressed(throwable3);
                                                        }
                                                    } else {
                                                        ignore.close();
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    if (jobLock == null) break block61;
                                    break block62;
                                }
                                catch (Exception e) {
                                    logger.error("Execute job failed {}", (Object)jobExecutable.getJobId(), (Object)e);
                                    return;
                                }
                            }
                            this.stopJobLockRenewAfterExecute(jobLock);
                        }
                        this.runningJobMap.remove(jobExecutable.getJobId());
                        return;
                    }
                    this.stopJobLockRenewAfterExecute(jobLock);
                }
                this.runningJobMap.remove(jobExecutable.getJobId());
                return;
            }
            this.stopJobLockRenewAfterExecute(jobLock);
        }
        this.runningJobMap.remove(jobExecutable.getJobId());
        return;
        finally {
            if (jobLock != null) {
                this.stopJobLockRenewAfterExecute(jobLock);
            }
            this.runningJobMap.remove(jobExecutable.getJobId());
        }
    }

    private JdbcJobLock tryJobLock(AbstractJobExecutable jobExecutable) throws LockException {
        JdbcJobLock jobLock = new JdbcJobLock(jobExecutable.getJobId(), this.jobContext.getServerNode(), this.jobContext.getKylinConfig().getJobSchedulerJobRenewalSec(), this.jobContext.getKylinConfig().getJobSchedulerJobRenewalRatio(), this.jobContext.getLockClient(), new JobAcquireListener(jobExecutable));
        if (!jobLock.tryAcquire()) {
            logger.info("Acquire job lock failed.");
            return null;
        }
        return jobLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopJobLockRenewAfterExecute(JdbcJobLock jobLock) {
        try {
            String jobId = jobLock.getLockId();
            JobInfo jobInfo = this.jobContext.getJobInfoMapper().selectByJobId(jobId);
            AbstractExecutable jobExecutable = (AbstractExecutable)this.getJobExecutable(jobInfo);
            if (jobExecutable.getStatusInMem() == ExecutableState.RUNNING) {
                logger.error("Unexpected status for {} <{}>, mark job error", (Object)jobId, (Object)jobExecutable.getStatusInMem());
                this.markErrorJob(jobId, jobExecutable.getProject());
            }
        }
        catch (Exception e) {
            logger.error("Fail to check status before stop renew job lock {}", (Object)jobLock.getLockId(), (Object)e);
        }
        finally {
            jobLock.stopRenew();
        }
    }

    private void markErrorJob(String jobId, String project) {
        try {
            ExecutableManager manager = ExecutableManager.getInstance(KylinConfig.getInstanceFromEnv(), project);
            manager.errorJob(jobId);
        }
        catch (Exception e) {
            logger.warn("[UNEXPECTED_THINGS_HAPPENED] project {} job {} should be error but mark failed", new Object[]{project, jobId, e});
        }
    }

    private boolean isIndexPlannerRecJob(JobInfo jobInfo) {
        if (!"REC".equals(JobTypeEnum.getEnumByName(jobInfo.getJobType()).getCategory())) {
            return false;
        }
        ExecutablePO po = JobInfoUtil.deserializeExecutablePO(jobInfo);
        return po != null && StringUtils.equalsIgnoreCase((CharSequence)po.getParams().get("kylin.planner.autoApproveEnabled"), (CharSequence)"true");
    }

    private boolean isIndexPlannerBuildJob(JobInfo jobInfo) {
        if (!"BUILD".equals(JobTypeEnum.getEnumByName(jobInfo.getJobType()).getCategory())) {
            return false;
        }
        ExecutablePO po = JobInfoUtil.deserializeExecutablePO(jobInfo);
        return po != null && StringUtils.equalsIgnoreCase((CharSequence)po.getParams().get("kylin.planner.autoApproveEnabled"), (CharSequence)"true");
    }

    private AbstractJobExecutable getJobExecutable(JobInfo jobInfo) {
        ExecutablePO executablePO = JobInfoUtil.deserializeExecutablePO(jobInfo);
        return ExecutableManager.getInstance(KylinConfig.getInstanceFromEnv(), jobInfo.getProject()).fromPO(executablePO);
    }

    private static class JobAcquireListener
    implements LockAcquireListener {
        private final AbstractJobExecutable jobExecutable;

        JobAcquireListener(AbstractJobExecutable jobExecutable) {
            this.jobExecutable = jobExecutable;
        }

        @Override
        public void onSucceed() {
        }

        @Override
        public void onFailed() {
        }

        @Generated
        public AbstractJobExecutable getJobExecutable() {
            return this.jobExecutable;
        }
    }

    private class MasterAcquireListener
    implements LockAcquireListener {
        private MasterAcquireListener() {
        }

        @Override
        public void onSucceed() {
            if (JdbcJobScheduler.this.isMaster.compareAndSet(false, true)) {
                logger.info("Job scheduler become master.");
            } else {
                logger.debug("Job scheduler keep on master");
            }
        }

        @Override
        public void onFailed() {
            if (JdbcJobScheduler.this.isMaster.compareAndSet(true, false)) {
                logger.info("Job scheduler fallback standby.");
            } else {
                logger.debug("Job scheduler keep on standby");
            }
            JdbcJobScheduler.this.master.schedule(() -> JdbcJobScheduler.this.standby(), JdbcJobScheduler.this.masterLock.getRenewalSec(), TimeUnit.SECONDS);
        }
    }
}

