/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.runners;

import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.annotation.Clarification;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.job.JobContext;
import org.apache.kylin.metadata.cube.storage.ProjectStorageInfoCollector;
import org.apache.kylin.metadata.cube.storage.StorageInfoEnum;
import org.apache.kylin.metadata.cube.storage.StorageVolumeInfo;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Clarification(priority=Clarification.Priority.MAJOR, msg="Enterprise")
public class QuotaStorageCheckRunner
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(QuotaStorageCheckRunner.class);
    private final ProjectStorageInfoCollector collector;
    private JobContext jobContext;

    public QuotaStorageCheckRunner(JobContext jobContext) {
        this.jobContext = jobContext;
        this.collector = new ProjectStorageInfoCollector((List)Lists.newArrayList((Object[])new StorageInfoEnum[]{StorageInfoEnum.STORAGE_QUOTA, StorageInfoEnum.TOTAL_STORAGE}));
    }

    @Override
    public void run() {
        if (!KylinConfig.getInstanceFromEnv().isStorageQuotaEnabled()) {
            return;
        }
        logger.info("Start check all project storage quota.");
        NProjectManager nProjectManager = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        List projectInstanceList = nProjectManager.listAllProjects();
        for (ProjectInstance projectInstance : projectInstanceList) {
            String project = projectInstance.getName();
            this.jobContext.setProjectReachQuotaLimit(project, this.reachStorageQuota(project));
        }
    }

    private boolean reachStorageQuota(String project) {
        StorageVolumeInfo storageVolumeInfo = this.collector.getStorageVolumeInfo(KylinConfig.getInstanceFromEnv(), project);
        long totalSize = storageVolumeInfo.getTotalStorageSize();
        int retryCount = 3;
        while (retryCount-- > 0 && totalSize < 0L) {
            storageVolumeInfo = this.collector.getStorageVolumeInfo(KylinConfig.getInstanceFromEnv(), project);
            totalSize = storageVolumeInfo.getTotalStorageSize();
        }
        long storageQuotaSize = storageVolumeInfo.getStorageQuotaSize();
        if (totalSize < 0L) {
            logger.error("Project '{}' : an exception occurs when getting storage volume info, no job will be scheduled!!! The error info : {}", (Object)project, storageVolumeInfo.getThrowableMap().get(StorageInfoEnum.TOTAL_STORAGE));
            return true;
        }
        if (totalSize >= storageQuotaSize) {
            logger.info("Project '{}' reach storage quota, no job will be scheduled!!!", (Object)project);
            return true;
        }
        return false;
    }
}

