/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.handler;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.util.TimeUtil;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.job.common.ExecutableUtil;
import org.apache.kylin.job.dao.ExecutablePO;
import org.apache.kylin.job.dao.JobStatisticsManager;
import org.apache.kylin.job.exception.JobSubmissionException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ChainedExecutable;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.model.JobParam;
import org.apache.kylin.job.util.JobContextUtil;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJobHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractJobHandler.class);

    public final void handle(JobParam jobParam) {
        this.checkBeforeHandle(jobParam);
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            this.checkBeforeHandle(jobParam);
            this.doHandle(jobParam);
            return null;
        }, (String)jobParam.getProject(), (int)1);
    }

    protected boolean needComputeJobBucket() {
        return true;
    }

    public final void doHandle(JobParam jobParam) {
        AbstractExecutable job;
        if (this.needComputeJobBucket()) {
            ExecutableUtil.computeJobBucket(jobParam);
        }
        if ((job = this.createJob(jobParam)) == null) {
            log.info("Job {} no need to create job ", (Object)jobParam);
            jobParam.setJobId(null);
            return;
        }
        job.setSparkYarnQueueIfEnabled(jobParam.getProject(), jobParam.getYarnQueue());
        job.setPriority(jobParam.getPriority());
        job.setTag(jobParam.getTag());
        log.info("Job {} creates job {}", (Object)jobParam, (Object)job);
        String project = jobParam.getProject();
        UnitOfWork.doAfterUpdate(() -> this.persistJob(project, job));
        this.updateStatistics(project, jobParam, job);
    }

    private void persistJob(String project, AbstractExecutable job) {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        ExecutablePO po = ExecutableManager.toPO(job, project);
        ExecutableManager executableManager = this.getExecutableManager(project, kylinConfig);
        executableManager.addJob(po);
        if (job instanceof ChainedExecutable) {
            Set deps = ((ChainedExecutable)((Object)job)).getTasks().stream().flatMap(j -> j.getDependencies(kylinConfig).stream()).collect(Collectors.toSet());
            HashMap info = Maps.newHashMap();
            info.put("dependentFiles", StringUtils.join(deps, (String)","));
            JobContextUtil.withTxAndRetry(() -> {
                executableManager.updateJobOutput(po.getId(), null, info, null, null);
                return true;
            });
        }
    }

    private void updateStatistics(String project, JobParam jobParam, AbstractExecutable job) {
        if (job instanceof ChainedExecutable) {
            KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
            JobStatisticsManager jobStatisticsManager = JobStatisticsManager.getInstance(kylinConfig, project);
            long startOfDay = TimeUtil.getDayStart((long)System.currentTimeMillis());
            String model = jobParam.getModel();
            if (model != null) {
                jobStatisticsManager.updateStatistics(startOfDay, model, 0L, 0L, 1);
            } else {
                jobStatisticsManager.updateStatistics(startOfDay, 0L, 0L, 1);
            }
        }
    }

    protected abstract AbstractExecutable createJob(JobParam var1);

    protected void checkBeforeHandle(JobParam jobParam) {
        String model = jobParam.getModel();
        String project = jobParam.getProject();
        Preconditions.checkNotNull((Object)project);
        Preconditions.checkNotNull((Object)model);
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        NDataflow dataflow = NDataflowManager.getInstance((KylinConfig)kylinConfig, (String)project).getDataflow(model);
        ExecutableManager execManager = ExecutableManager.getInstance(kylinConfig, project);
        List<AbstractExecutable> executables = jobParam.isMultiPartitionJob() ? execManager.listMultiPartitionModelExec(model, ExecutableState::isRunning, jobParam.getJobTypeEnum(), jobParam.getTargetPartitions(), null) : execManager.listExecByModelAndStatus(model, ExecutableState::isRunning, null);
        LinkedList<String> failedSegs = new LinkedList<String>();
        if (JobParam.isBuildIndexJob(jobParam.getJobTypeEnum())) {
            for (String segmentId : jobParam.getTargetSegments()) {
                if (!this.isOverlapWithJob(executables, segmentId, jobParam, dataflow)) continue;
                failedSegs.add(segmentId);
            }
        } else if (this.isOverlapWithJob(executables, jobParam.getSegment(), jobParam, dataflow)) {
            failedSegs.add(jobParam.getSegment());
        }
        if (failedSegs.isEmpty()) {
            return;
        }
        JobSubmissionException jobSubmissionException = new JobSubmissionException((ErrorCodeProducer)ErrorCodeServer.JOB_CREATE_CHECK_FAIL, new Object[0]);
        for (String failedSeg : failedSegs) {
            jobSubmissionException.addJobFailInfo(failedSeg, new KylinException((ErrorCodeProducer)ErrorCodeServer.JOB_CREATE_CHECK_FAIL, new Object[0]));
        }
        throw jobSubmissionException;
    }

    public boolean isOverlapWithJob(List<AbstractExecutable> executables, String segmentId, JobParam jobParam, NDataflow dataflow) {
        NDataSegment dealSegment = dataflow.getSegment(segmentId);
        HashMap relatedSegment = new HashMap();
        dataflow.getSegments().forEach(segment -> relatedSegment.put(segment.getId(), segment));
        for (AbstractExecutable job : executables) {
            List<String> targetSegments = job.getTargetSegments();
            for (String segId : targetSegments) {
                if (relatedSegment.get(segId) == null || !dealSegment.getSegRange().overlaps(((NDataSegment)relatedSegment.get(segId)).getSegRange())) continue;
                log.debug("JobParam {} segment range  conflicts with running job {}", (Object)jobParam, (Object)job);
                return true;
            }
        }
        return false;
    }

    protected ExecutableManager getExecutableManager(String project, KylinConfig config) {
        return ExecutableManager.getInstance(config, project);
    }
}

