/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.execution;

import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultExecutableOnModel;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.manager.JobManager;
import org.apache.kylin.job.model.JobParam;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExecutableHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExecutableHandler.class);
    protected static final String SUBJECT_NOT_EXIST_COMMENT = "subject does not exist or is broken, roll back to to-be-accelerated status";
    private String project;
    private String modelId;
    private String owner;
    private String segmentId;
    private String jobId;

    public abstract void handleFinished();

    public abstract void handleDiscardOrSuicidal();

    protected ExecutableManager getExecutableManager(String project, KylinConfig config) {
        return ExecutableManager.getInstance(config, project);
    }

    protected void addJob(String segmentId, JobTypeEnum jobTypeEnum) {
        JobManager manager = JobManager.getInstance(KylinConfig.getInstanceFromEnv(), this.getProject());
        NDataSegment segment = NDataSegment.empty();
        if (segmentId != null) {
            segment.setId(segmentId);
        }
        manager.addJob(new JobParam(segment, this.modelId, this.owner).withJobTypeEnum(jobTypeEnum));
    }

    protected DefaultExecutableOnModel getExecutable() {
        AbstractExecutable executable = this.getExecutableManager(this.project, KylinConfig.getInstanceFromEnv()).getJob(this.jobId);
        Preconditions.checkNotNull((Object)executable);
        Preconditions.checkArgument((boolean)(executable instanceof DefaultExecutableOnModel));
        return (DefaultExecutableOnModel)executable;
    }

    public int getErrorOrPausedJobCount() {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        ExecutableManager executableManager = this.getExecutableManager(this.project, kylinConfig);
        return executableManager.listExecByModelAndStatus(this.modelId, ExecutableState::isNotProgressing, JobTypeEnum.INC_BUILD).size();
    }

    @Generated
    public ExecutableHandler() {
    }

    @Generated
    public ExecutableHandler(String project, String modelId, String owner, String segmentId, String jobId) {
        this.project = project;
        this.modelId = modelId;
        this.owner = owner;
        this.segmentId = segmentId;
        this.jobId = jobId;
    }

    @Generated
    public String getProject() {
        return this.project;
    }

    @Generated
    public void setProject(String project) {
        this.project = project;
    }

    @Generated
    public String getModelId() {
        return this.modelId;
    }

    @Generated
    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    @Generated
    public String getOwner() {
        return this.owner;
    }

    @Generated
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Generated
    public String getSegmentId() {
        return this.segmentId;
    }

    @Generated
    public void setSegmentId(String segmentId) {
        this.segmentId = segmentId;
    }

    @Generated
    public String getJobId() {
        return this.jobId;
    }

    @Generated
    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public static enum HandlerType {
        ADD_CUBOID,
        ADD_SEGMENT,
        MERGE_OR_REFRESH,
        SAMPLING,
        SNAPSHOT,
        LOAD_INTERNAL_TABLE;

    }
}

