/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.dao;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.job.dao.ExecutableOutputPO;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.JobSchedulerModeEnum;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.metadata.cube.model.NDataSegment;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class ExecutablePO
extends RootPersistentEntity {
    public static final int HIGHEST_PRIORITY = 0;
    public static final int DEFAULT_PRIORITY = 3;
    public static final int LOWEST_PRIORITY = 4;
    private static final String V4_0_TYPE_PREFIX = "io.kyligence.kap.engine.spark.job";
    private static final String V5_0_TYPE_PREFIX = "org.apache.kylin.engine.spark.job";
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="tasks")
    private List<ExecutablePO> tasks;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="handler_type")
    private String handlerType;
    @JsonProperty(value="params")
    private Map<String, String> params = Maps.newHashMap();
    @JsonProperty(value="segments")
    private Set<NDataSegment> segments = Sets.newHashSet();
    @JsonProperty(value="job_type")
    private JobTypeEnum jobType;
    @JsonProperty(value="data_range_start")
    private long dataRangeStart;
    @JsonProperty(value="data_range_end")
    private long dataRangeEnd;
    @JsonProperty(value="target_model")
    private String targetModel;
    @JsonProperty(value="target_segments")
    private List<String> targetSegments;
    @JsonProperty(value="output")
    private ExecutableOutputPO output = new ExecutableOutputPO();
    @JsonProperty(value="project")
    private String project;
    @JsonProperty(value="target_partitions")
    private Set<Long> targetPartitions = Sets.newHashSet();
    @JsonProperty(value="priority")
    private int priority = 3;
    @JsonProperty(value="tag")
    private Object tag;
    @JsonProperty(value="stages_map")
    private Map<String, List<ExecutablePO>> stagesMap;
    @JsonProperty(value="job_scheduler_mode")
    private JobSchedulerModeEnum jobSchedulerMode = JobSchedulerModeEnum.CHAIN;
    @JsonProperty(value="previous_step")
    private String previousStep;
    @JsonProperty(value="next_steps")
    private Set<String> nextSteps = Sets.newHashSet();

    public void setPriority(int p) {
        this.priority = ExecutablePO.isPriorityValid(p) ? p : 3;
    }

    public static boolean isPriorityValid(int priority) {
        return priority >= 0 && priority <= 4;
    }

    public static boolean isHigherPriority(int p1, int p2) {
        return p1 < p2;
    }

    public void addYarnApplicationJob(String appId) {
        String oldAppIds = this.output.getInfo().getOrDefault("yarn_application_ids", "");
        HashSet<String> appIds = new HashSet<String>(Arrays.asList(oldAppIds.split(",")));
        if (!appIds.contains(appId)) {
            String newAppIds = oldAppIds + (StringUtils.isEmpty((CharSequence)oldAppIds) ? "" : ",") + appId;
            this.output.getInfo().put("yarn_application_ids", newAppIds);
        }
    }

    public String getType() {
        return this.backwardConvertType(this.type);
    }

    public String getTargetModelId() {
        return AbstractExecutable.getTargetModelId(this.getProject(), this.getTargetModel());
    }

    public long getDurationByPO() {
        long jobDuration = this.getTaskDuration();
        List<ExecutablePO> subTasks = this.getTasks();
        if (CollectionUtils.isNotEmpty(subTasks)) {
            jobDuration = 0L;
            for (ExecutablePO subTask : subTasks) {
                long taskDuration = subTask.getTaskDuration();
                if (MapUtils.isNotEmpty(subTask.getStagesMap()) && subTask.getStagesMap().size() == 1) {
                    AtomicLong jobAtomicDuration = new AtomicLong(0L);
                    for (Map.Entry<String, List<ExecutablePO>> entry : subTask.getStagesMap().entrySet()) {
                        entry.getValue().forEach(po -> jobAtomicDuration.addAndGet(po.getTaskDuration()));
                    }
                    taskDuration = jobAtomicDuration.get();
                }
                jobDuration += taskDuration;
            }
        }
        return jobDuration;
    }

    private long getTaskDuration() {
        ExecutableOutputPO jobOutput = this.getOutput();
        if (jobOutput.getDuration() != 0L) {
            long taskDuration = jobOutput.getDuration();
            if (ExecutableState.RUNNING == ExecutableState.valueOf(jobOutput.getStatus())) {
                taskDuration = taskDuration + System.currentTimeMillis() - jobOutput.getLastRunningStartTime();
            }
            return taskDuration;
        }
        if (jobOutput.getStartTime() == 0L) {
            return 0L;
        }
        return jobOutput.getEndTime() == 0L ? System.currentTimeMillis() - jobOutput.getStartTime() : jobOutput.getEndTime() - jobOutput.getStartTime();
    }

    private String backwardConvertType(String oldType) {
        if (oldType != null && oldType.startsWith(V4_0_TYPE_PREFIX)) {
            return oldType.replace(V4_0_TYPE_PREFIX, V5_0_TYPE_PREFIX);
        }
        return oldType;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setTasks(List<ExecutablePO> tasks) {
        this.tasks = tasks;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setHandlerType(String handlerType) {
        this.handlerType = handlerType;
    }

    @Generated
    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    @Generated
    public void setSegments(Set<NDataSegment> segments) {
        this.segments = segments;
    }

    @Generated
    public void setJobType(JobTypeEnum jobType) {
        this.jobType = jobType;
    }

    @Generated
    public void setDataRangeStart(long dataRangeStart) {
        this.dataRangeStart = dataRangeStart;
    }

    @Generated
    public void setDataRangeEnd(long dataRangeEnd) {
        this.dataRangeEnd = dataRangeEnd;
    }

    @Generated
    public void setTargetModel(String targetModel) {
        this.targetModel = targetModel;
    }

    @Generated
    public void setTargetSegments(List<String> targetSegments) {
        this.targetSegments = targetSegments;
    }

    @Generated
    public void setOutput(ExecutableOutputPO output) {
        this.output = output;
    }

    @Generated
    public void setProject(String project) {
        this.project = project;
    }

    @Generated
    public void setTargetPartitions(Set<Long> targetPartitions) {
        this.targetPartitions = targetPartitions;
    }

    @Generated
    public void setTag(Object tag) {
        this.tag = tag;
    }

    @Generated
    public void setStagesMap(Map<String, List<ExecutablePO>> stagesMap) {
        this.stagesMap = stagesMap;
    }

    @Generated
    public void setJobSchedulerMode(JobSchedulerModeEnum jobSchedulerMode) {
        this.jobSchedulerMode = jobSchedulerMode;
    }

    @Generated
    public void setPreviousStep(String previousStep) {
        this.previousStep = previousStep;
    }

    @Generated
    public void setNextSteps(Set<String> nextSteps) {
        this.nextSteps = nextSteps;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<ExecutablePO> getTasks() {
        return this.tasks;
    }

    @Generated
    public String getHandlerType() {
        return this.handlerType;
    }

    @Generated
    public Map<String, String> getParams() {
        return this.params;
    }

    @Generated
    public Set<NDataSegment> getSegments() {
        return this.segments;
    }

    @Generated
    public JobTypeEnum getJobType() {
        return this.jobType;
    }

    @Generated
    public long getDataRangeStart() {
        return this.dataRangeStart;
    }

    @Generated
    public long getDataRangeEnd() {
        return this.dataRangeEnd;
    }

    @Generated
    public String getTargetModel() {
        return this.targetModel;
    }

    @Generated
    public List<String> getTargetSegments() {
        return this.targetSegments;
    }

    @Generated
    public ExecutableOutputPO getOutput() {
        return this.output;
    }

    @Generated
    public String getProject() {
        return this.project;
    }

    @Generated
    public Set<Long> getTargetPartitions() {
        return this.targetPartitions;
    }

    @Generated
    public int getPriority() {
        return this.priority;
    }

    @Generated
    public Object getTag() {
        return this.tag;
    }

    @Generated
    public Map<String, List<ExecutablePO>> getStagesMap() {
        return this.stagesMap;
    }

    @Generated
    public JobSchedulerModeEnum getJobSchedulerMode() {
        return this.jobSchedulerMode;
    }

    @Generated
    public String getPreviousStep() {
        return this.previousStep;
    }

    @Generated
    public Set<String> getNextSteps() {
        return this.nextSteps;
    }
}

