/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.constant;

import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;

public enum JobActionEnum {
    RESUME,
    DISCARD,
    PAUSE,
    RESTART;

    private static final Set<String> validValues;

    public static void validateValue(String value) {
        if (!validValues.contains(value.toUpperCase(Locale.ROOT))) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PARAMETER_INVALID_SUPPORT_LIST, new Object[]{"action", "RESUME, DISCARD, PAUSE, RESTART"});
        }
    }

    static {
        validValues = Arrays.stream(JobActionEnum.values()).map(Enum::name).collect(Collectors.toSet());
    }
}

