/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.common;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.job.common.ExecutableUtil;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.model.JobParam;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.cube.model.SegmentPartition;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshJobUtil
extends ExecutableUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RefreshJobUtil.class);

    @Override
    public void computeLayout(JobParam jobParam) {
        NDataflow df = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)jobParam.getProject()).getDataflow(jobParam.getModel());
        NDataSegment newSeg = df.getSegment(jobParam.getSegment());
        List segments = df.getSegments().stream().filter(segment -> segment.getSegRange().startStartMatch(newSeg.getSegRange())).filter(segment -> segment.getSegRange().endEndMatch(newSeg.getSegRange())).filter(segment -> SegmentStatusEnum.READY == segment.getStatus() || SegmentStatusEnum.WARNING == segment.getStatus()).collect(Collectors.toList());
        if (segments.size() != 1) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.JOB_CREATE_CHECK_SEGMENT_READY_FAIL, new Object[0]);
        }
        IndexPlan indexPlan = NIndexPlanManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)jobParam.getProject()).getIndexPlan(jobParam.getModel());
        Set<Long> targetLayouts = jobParam.getTargetLayouts();
        HashSet layouts = Sets.newHashSet();
        if (targetLayouts.isEmpty()) {
            Boolean refreshAll = (Boolean)jobParam.getCondition().get("REFRESH_ALL_LAYOUTS");
            if (refreshAll.booleanValue()) {
                layouts.addAll(indexPlan.getAllLayouts());
            } else {
                if (((NDataSegment)segments.get(0)).getLayoutsMap().isEmpty() && !KylinConfig.getInstanceFromEnv().isUTEnv()) {
                    throw new KylinException((ErrorCodeProducer)ErrorCodeServer.JOB_CREATE_CHECK_INDEX_FAIL, new Object[0]);
                }
                ((NDataSegment)segments.get(0)).getLayoutsMap().values().forEach(layout -> layouts.add(layout.getLayout()));
            }
        } else {
            indexPlan.getAllLayouts().forEach(layout -> {
                if (targetLayouts.contains(layout.getId())) {
                    layouts.add(layout);
                }
            });
        }
        jobParam.setProcessLayouts(this.filterTobeDelete(layouts));
        this.checkLayoutsNotEmpty(jobParam);
    }

    @Override
    public ErrorCodeProducer getCheckIndexErrorCode() {
        return ErrorCodeServer.JOB_REFRESH_CHECK_INDEX_FAIL;
    }

    @Override
    public void computePartitions(JobParam jobParam) {
        NDataflowManager dfm = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)jobParam.getProject());
        NDataflow df = dfm.getDataflow(jobParam.getModel());
        NDataSegment segment = df.getSegment(jobParam.getSegment());
        if (JobTypeEnum.INDEX_REFRESH == jobParam.getJobTypeEnum()) {
            jobParam.setTargetPartitions(segment.getMultiPartitions().stream().map(SegmentPartition::getPartitionId).collect(Collectors.toSet()));
        }
    }

    static {
        RefreshJobUtil.registerImplementation(JobTypeEnum.INDEX_REFRESH, new RefreshJobUtil());
        RefreshJobUtil.registerImplementation(JobTypeEnum.SUB_PARTITION_REFRESH, new RefreshJobUtil());
    }
}

