/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.junit;

import java.util.TimeZone;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.DateFormat;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeZoneTestRunner
extends BlockJUnit4ClassRunner {
    private static final Logger logger = LoggerFactory.getLogger(KylinConfig.class);
    private static String[] timeZones = new String[]{"UTC"};

    public TimeZoneTestRunner(Class<?> clazz) throws Exception {
        super(clazz);
    }

    public void run(final RunNotifier notifier) {
        TimeZone aDefault = TimeZone.getDefault();
        for (String timeZone : timeZones) {
            TimeZone.setDefault(TimeZone.getTimeZone(timeZone));
            DateFormat.cleanCache();
            logger.info("Running {} with time zone {}", (Object)this.getTestClass().getJavaClass().toString(), (Object)timeZone);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    TimeZoneTestRunner.super.run(notifier);
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("current time zone is " + timeZone, e);
            }
            finally {
                DateFormat.cleanCache();
            }
        }
        TimeZone.setDefault(aDefault);
    }
}

